
	typedef union {
		double	real64;
		long	int32[2];
		short	int16[4];
		char	byte8[8];
	}convertor64;

	typedef union {
		float	real32;
		long	int32;
		short	int16[2];
		char	byte8[4];
	}convertor32;



extern "C" __declspec(dllexport) void __stdcall VEEUnion (double* real64, float* real32, long* int32, 
									 short* int16, short* byte8, int type)
{
	convertor64 c1;
	convertor32 c2;
	int		i;

	switch (type) {
	case 1:  // real64 -> byte, int16 and int32
		c1.real64 = *real64;
		for (i=0; i<8; i++)
			byte8[i] = (c1.byte8[i] & 0xff);  // prevent sign extention
		for (i=0; i<4; i++)
			int16[i] = (c1.int16[i] & 0xffff);  // prevent sign extention
		for (i=0; i<2; i++)
			int32[i] = c1.int32[i];
		break;

	case 2:  // int32 -> byte, int16 and real64
		for (i=0; i<2; i++)
			c1.int32[i] = int32[i];
		for (i=0; i<8; i++)
			byte8[i] = (c1.byte8[i] & 0xff);  // prevent sign extention
		for (i=0; i<4; i++)
			int16[i] = (c1.int16[i] & 0xffff);  // prevent sign extention
		*real64 = c1.real64;
		break;

	case 3:  // int16 -> byte, int32 and real64
		for (i=0; i<4; i++)
			c1.int16[i] = int16[i];
		for (i=0; i<8; i++)
			byte8[i] = (c1.byte8[i] & 0xff);  // prevent sign extention
		for (i=0; i<2; i++)
			int32[i] = c1.int32[i];
		*real64 = c1.real64;
		break;

	case 4:  // byte -> int16, int32 and real64
		for (i=0; i<8; i++)
			c1.byte8[i] = (char)byte8[i];
		for (i=0; i<4; i++)
			int16[i] = (c1.int16[i] & 0xffff);  // prevent sign extention
		for (i=0; i<2; i++)
			int32[i] = c1.int32[i];
		*real64 = c1.real64;
		break;

	case 5:  // real32 -> byte, int16 and int32
		c2.real32 = *real32;
		for (i=0; i<4; i++)
			byte8[i] = (c2.byte8[i] & 0xff);  // prevent sign extention
		for (i=0; i<2; i++)
			int16[i] = (c2.int16[i] & 0xffff);  // prevent sign extention
		*int32 = c2.int32;
		break;

	case 6:  // int32 -> byte, int16 and real32
		c2.int32 = *int32;
		for (i=0; i<4; i++)
			byte8[i] = (c2.byte8[i] & 0xff);  // prevent sign extention
		for (i=0; i<2; i++)
			int16[i] = (c2.int16[i] & 0xffff);  // prevent sign extention
		*real32 = c2.real32;
		break;

	case 7:  // int16 -> byte, int32 and real32
		for (i=0; i<2; i++)
			c2.int16[i] = int16[i];
		for (i=0; i<4; i++)
			byte8[i] = (c2.byte8[i] & 0xff);  // prevent sign extention
		*int32 = c2.int32;
		*real32 = c2.real32;
		break;

	case 8:  // byte -> int16, int32 and real32
		for (i=0; i<4; i++)
			c2.byte8[i] = (char)byte8[i];
		for (i=0; i<2; i++)
			int16[i] = (c2.int16[i] & 0xffff);  // prevent sign extention
		*int32 = c2.int32;
		*real32 = c2.real32;
		break;

	}

}

