// vee_comm_vee.h : main header file for the vee_comm DLL
//

int veeCommPortOpen (int nPort, int baud, int size, int parity, int stopBits, int txBufferSize, int rxBufferSize);
// Opens serial port
// returns error codes:
//-1: bad baud rate
//-2: invalid parity
//-3: invalid stop bits
//-4: invalid data size
//-5: CreateFile failed
//-6: buffer creation error
//-7: port status failed after sucessful 'CreateFile'

int veeCommPortClose (int closeDelay);
// closes serial port & waits 'closeDelay' milliseconds.
// returns error codes 0:failed, 1:success.

int veeCommRead (int dataLen, char *dataBuffer);
// reads maximum of 'dataLen' characters from the RX buffer into *databuffer
// returns number of characters read
// or error codes:
// -1 timeout
// -2 RX buffer full, but no EOL detected
// -3 ReadFile error
// -4 Port unopened

int veeCommReadLine (int dataLen, char *dataBuffer, char *searchData);
// reads maximum of 'dataLen' characters from the serial port RX buffer into *databuffer, 
// until '*searchData' string is found.
// returns number of characters read
// or error codes:
// -1 timeout
// -2 RX buffer full, but no EOL detected
// -3 ReadFile error
// -4 Port unopened

int veeCommWrite (int dataLen, char *dataBuffer);
// writes 'dataLen' number of characters from '*dataBuffer' to serial port TX buffer.
// returns 1:success, -1:port died.

int veeCommTimeout (int timeout);
// sets the timeout for receive & opening the serial port.
// returns 1:success.

int veeCommDataAvailable (void);
// returns number of characters remaining in the RX buffer.

int veeCommGetState (void);
// returns the state of the current serial port.
// returns 0:port closed, 2:port open

void veeCommDebug (long *StartDataPtr, long *EndDataPtr, long *DAVraw, long *debugVariable, char *CB_bufferDebug, long *buffLen);
// returns debug information regarding RAM circular buffer pointer positions etc.
