VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clSpecialFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'This is an example implementation of a class called 'clSpecialFile' - that's
'a bit of a joke because it is not very special at all and could more easily be
'dealt with using VEE direct... however, the spirit is to show the VB ActiveX
'creation and interface with VEE.  Writing the specialist VB code is your job
'( although for a fee I might be interested - but I digress...)

Option Explicit         'just my preference
Private PathSet As Boolean
Private LclPath As String
Private LclFileSize As Integer


'we can expect to be able to 'read' and 'write' a property called Path, but would
'also like to know if the path has been set before opening the file.  So there are
'two sections to deal with the Path property.  If there was no checking involved
'it could just be declared as a public variable
Public Property Let Path(FilePath As String)
  LclPath = FilePath      'we may want to check the file exists first
  PathSet = True
End Property

Public Property Get Path() As String
  Path = LclPath
End Property

'the FileSize is read-only
Public Property Get FileSize() As Integer
  'check the path has been set
  If PathSet Then
    Open LclPath For Input As #1
    FileSize = LOF(1)   ' Get length of file.
    Close #1   ' Close file.
  Else
    MsgBox "No file path set"
  End If
End Property


Private Sub class_initialize()
  'just need to make sure the PathSet flag is false to start with
  PathSet = False
End Sub


Public Function readALine() As String
  'check the path has been set
  If PathSet Then
    Open LclPath For Input As #1
    Dim TempStr As String
    Input #1, TempStr     'read some data from the file
    readALine = TempStr   'assign value to the function
    Close #1   ' Close file.
  Else
    MsgBox "No file path set"
    readALine = ""
  End If
End Function

Public Sub show()
  'check the path has been set
  If PathSet Then
    Open LclPath For Input As #1
    
    Dim LineStr As String, TempStr As String
    
    Do While Not EOF(1)                   'Loop until end of file.
      Input #1, TempStr                   'Read data into string array
      LineStr = LineStr & " " & TempStr   'copy to a concatenated array
    Loop
    
    Close #1   ' Close file.
    fmShowText.txtBox = LineStr
    fmShowText.show 1    'modal
  Else
    MsgBox "No file path set"
  End If
End Sub

Public Sub append(TextLine As String)
  'check the path has been set
  If PathSet Then
    Open LclPath For Append As #1
    Print #1, TextLine            'print the text provided
    Close #1   ' Close file.
  Else
    MsgBox "No file path set"
  End If

End Sub
