// ****************************************************************************
// HMS antenna interface public routines and data.
// Global defines to distinguish between a:
// Intermec Jannus 2010                    /* in a DOS environment                 */
// Intermec TRAKKER Antares 2420 and 2425  /* Must use Microsoft Visual C++ V1.51 */
// Hand held PC                            /* Standard DOS with a full screen.    */

#define HMS_MEM_SIZE        736  // Number of data bytes in an HMS tag. 0 to MEM_SIZE-1.
#define TOP_MUXADR         0x1F  // Largest valid MUX32 address. 0 to TOP_MUXADR.
#define NUM_MUXADR  (TOP_MUXADR + 1) // Zero to the top MUX32 address has zero index.
#define HMS_TAG_START       0    // HMS tags start data address is this.
#define ID_NUM_SIZE         4    // Tag identification number size, in bytes.

#define MIF_SEARCH_TI      250   // Timeout value for search tag command.
#define MIFARE_TIME_OUT   1000   // Timeout value sent to mifare chip, in ms.
#define MIF_WRITE_TI      1000   // Big block write command timeout value.
#define MIFARE_CLR_SET    1000   // For the clear and set tag commands, allow more time.
#define TAG_PRES_SRCH        2   // Seconds waiting for a response for Check antenna.

#define MSG_BEGIN          0xAA  // All commands begin with this.
#define MSG_TERM           0xFF  // Message Terminators.
#define NONCO_READ         0x01  // Non-contiguous Read command.
#define NONCO_WRITE        0x02  // Non-contiguous Write command.
#define CONF_NONCO         0x03  // Configure Non-contiguous R/W address.
#define FILL_TAG           0x04  // Fill tag command.
#define BLK_READ           0x05  // Block Read command.
#define BLK_WRITE          0x06  // Block write command.
#define GET_TAG_ID         0x07  // Get the tag's identification number.
#define SEARCH_TAG         0x08  // Tag Search command.
#define BAUD_CHANG         0x0A  // Change baud rate command.
#define PRO_BL_WRITE       0x0B  // Protected block write command.
#define CON_READ_MODE      0x0C  // Enter/exit continual read mode for how many bytes.

#define MSG_BEG_INX           0  // Array index for Message Begin byte (MSG_BEGIN).
#define MSG_FUN_INX           1  // Array index for Message function number.
#define MSG_TIMH_IX           2  // High byte of time-out value in command.
#define MSG_TIML_IX           3  // Low byte of time-out value in command.

#define NONCON_READFAIL    0x01  // Non-Contiguous Read has failed.
#define NONCON_WRITEFAIL   0x02  // Non-Contiguous Write has failed.
#define NONCON_CONFFAL     0x03  // Non-Contiguous Read/Write Configuration failed.
#define FILL_FAIL          0x04  // Fill Operation has failed.
#define READ_BLOCKFAIL     0x05  // Contiguous Block Read has failed.
#define WRITE_BLOCKFAIL    0x06  // Contiguous Block Write has failed.
#define SEARCH_FAIL        0x08  // Search Tag Operation has failed.
#define PROTECT_VIOLATE    0x19  // Protected Address violation.. 
#define NONCON_NOCONF      0x20  // Non-contiguous Read/Write no configuration. 
#define INP_NOTMATCH       0x21  // Command does not match pre-defined format.

#if ANTARES
#define INTERMEC_LEN     1024 // im_receive_bufffer() length, from Intermec.
#endif

#if PORT_PC                    // Note: this may be the same as ANTARES and JANUS!

#if TEST_MUX32                 // These two are for HMS827 interface.
#define HMS_MAX_DATA      55   // Data bytes in write/write command, for hole tag.
#else
#define HMS_MAX_DATA      80   // Maximun number of data bytes in read/write command.
#endif                         // This is for the HMS814.  Set it to 100 for HMS827.

#elif ANTARES OR JANUS         // This is for HMS814 interfac
#define HMS_MAX_DATA      80   // Maximun number of data bytes in read/write command.
#endif

/* Command Sent to HMS RF R/W Controller -------------------------------------*/

// ****************************************************************************
// Non-Contiguour Read Command 
//   
// Input:        Time out value of some type.  It is sent in the command packet.
// Return:       None.
// Side effects: A packet is queued to be sent.
extern void NCReadTx(WORD timeout);

// ****************************************************************************
// Transmit the Non-Contiguous Write Command 
//   
// Input:        Time out value of some type.  It is sent in the command packet.
//               Pointer to the data to be written.
//               Number of data bytes.
// Return:       NONE.
// Side effects: A packet is queued to be sent.
extern void NCWriteTx(WORD timeout, unsigned char *data_buf, 
   WORD data_size);

// ****************************************************************************
// Non-Contiguous Read/Write Configuration Command 
// Input:        Time out value of some type.  It is sent in the command packet.
//               Pointer to two buffers, that go in the read/write command.
//               Number of bytes in each buffer.
// Return:       NONE.
// Side effects: A packet is queued to be sent.
extern void NCConfTx(WORD timeout, unsigned char *read_buf, 
   WORD read_size, unsigned char *write_buf, WORD write_size) ;

// ****************************************************************************
// Transmit a proteced mode Block Write Command 
// Input:        Begin write at this start address in the tag.
//               Number of bytes to be written from tag.
//               Antenna timeout time.
//               Pointer to the bytes to be written.
// Return:       None.
// Side effects: None.
extern void pro_BLWriteTx(WORD start_add, WORD data_size, WORD timeout, 
   BYTE *data_buf);

// ****************************************************************************
// Transmit the Fill Command 
// Input:        Begin fill at what address in the tag?
//               How many bytes to fill with the data byte.
//               Antenna timeout time.
//               The data to be filled in the tag.
// Return:       None.
// Side effects: None.
extern void FillTx(WORD start_add, WORD data_size, 
   WORD timeout, unsigned char data);

// ****************************************************************************
// Transmit the Block Read Command 
// Input:        Begin reading at this start address in the tag.
//               Number of bytes to be read from tag.
//               Antenna timeout time.
// Return:       None.
// Side effects: None.
extern void BLReadTx(WORD start_add, WORD data_size, 
   WORD timeout);

// ****************************************************************************
// Transmit Enter Colntinual Block Read mode Command 
// Input:        Begin read tag address.
//               Number of bytes to read from tag.
// Return:       None.
// Side effects: None.
extern void ContReadTx(WORD start_add, WORD data_size);

// ****************************************************************************
// Transmit a proteced mode Block Write Command 
// Input:        Begin write at this start address in the tag.
//               Number of bytes to be written from tag.
//               Antenna timeout time.
//               Pointer to the bytes to be written.
// Return:       None.
// Side effects: None.
extern void BLWriteTx(WORD start_add, WORD data_size, 
   WORD timeout, unsigned char *data_buf);

// ****************************************************************************
// Transmit get tag's identification number Command 
// Input:        Antenna timeout time.
// Return:       None.
// Side effects: None.
extern void Get_Tag_IDTx(WORD timeout);

// ****************************************************************************
// Transmit Tag Search Command 
// Input:        Antenna timeout time.
// Return:       None.
// Side effects: None.
extern void SearchTx(WORD timeout);

// ****************************************************************************
// Transmit the Change baud rate
// Input:        New baud rate value. (See Operators's Manual for antenna.)
// Return:       None.
// Side effects: None.
extern void BaudrateTx(WORD baudrate);

// --------------------------------------------------------------------------
// Command Received from HMS RF R/W Controller. -----------------------------

// ****************************************************************************
// Recevive response form Non-Contiguous read.
// Input:        Pointer to where the data can be place.
//               Do not more than the data size number of bytes.
// Return:       Read status.
// Side effects: None.
extern BYTE NCReadRx(BYTE *data_buf, WORD data_size);

// ****************************************************************************
// Receive response from Non-Contiguous write.
// Input:        None.
// Return:       Was the command echoed?
// Side effects: None.
extern BYTE NCWriteRx(void);

// ****************************************************************************
// Receive response from Non-Contiguous configuration.
// Input:        None.
// Return:       Was the command echoed?
// Side effects: None.
extern BYTE NCConfRx(void);

// ****************************************************************************
// Receive response from fill command.
// Input:        None.
// Return:       Was the command echoed?
// Side effects: None.
extern BYTE FillRx(void);

// ****************************************************************************
// Receive response from Block Read.
// Input:        where to place the data.
//               Receive no more data than this. Note: BYTE received in a WORD.
// Return:       Command status.
// Side effects: None.
extern BYTE BLReadRx(BYTE *data_buf, WORD data_size);

// ****************************************************************************
// Receive response from Continual Block Read.
// Input:        where to place the data.
//               Receive no more data than this. Note: BYTE received in a WORD.
// Return:       Command status.
// Side effects: None.
extern BYTE ContBLReadRx(BYTE *data_buf, WORD data_size);

// ****************************************************************************
// Receive response from Enter Continual Read mode command.
// Input:        None.
// Return:       Was the command echoed? Tag present?
// Side effects: None.
extern BYTE ContReadRx(void);

// ****************************************************************************
// Receive response from block write.
// Input:        None.
// Return:       Was the command echoed?
// Side effects: None.
extern BYTE BLWriteRx(void);

// ****************************************************************************
// Receive response from Protected Write Block command.
// Input:        None.
// Return:       Was the command echoed? Tag present?
// Side effects: None.
extern BYTE pro_BLWriteRx(void);

// ****************************************************************************
// Receive response get tag's identification number command.
// Input:        None.
// Return:       Was the command echoed? Tag present?
// Side effects: None.
extern BYTE Get_Tag_IDRx(BYTE *data_buf);

// ****************************************************************************
// Receive response from search tag.
// Input:        None.
// Return:       Was the command echoed? Tag present?
// Side effects: None.
extern BYTE SearchRx(void);
