/*
 * Include file for IBM PC comm.c routines
 */

/* Defines */

#ifndef    NULL
#define    NULL    0
#endif

#define OP_OK                 0  // TAG Operation successful.

// General Antenna communication error codes:
#define COMM_ER1           0xF0  // Mask for any Antenna communication error
#define COMM_FAIL          0xff  // Waiting for a valid packet, timeout, no response.
#define COMM_INV           0xF1  // Received an invalid packet.  Close but not quite.
#define COMM_ERR           0xf2  // Could not authenticate what was received..

#define MIN_COM        1     // Minimum smallest COM port number allowed.
#define MAX_COM        2     // Largest COM port number allowed.

typedef unsigned char uchar;
typedef unsigned int uint;

#define XOFF       0x13    /* XON/XOFF */
#define XON        0x11

// Line Control Register value.  
// The bit mask meaning is stated below.
// 0x01 - Word length: least significant bit.
// 0x02 - Word length: most significant bit.
// 0x04 - Stop bits?
// 0x08 - Parity enable?
// 0x10 - Parity select.
// 0x20 - Parity one.
// 0x40 - Break.
// 0x80 - Divisor latch access bit.

// UART controll register values.
#define WORD_LENGTH   0x03   /* Word length bits.          */
#define WORD_FIVE     0x00   /* Five data bits.            */
#define WORD_SIX      0x01   /* Six data bits.             */
#define WORD_SEVEN    0x02   /* Seven data bits.           */
#define WORD_EIGHT    0x03   /* Eight data bits.           */
#define TWO_STOP_BITS 0x04   /* Two stop bits?             */
#define PARITY_EN     0x08   /* Parity enable?             */
#define EVEN_PARITY   0x10   /* Parity select.             */
#define PARITY_ONE    0x20   /* Parity one.                */
#define SET_BREAK     0x40   /* Break.                     */
#define DIV_LATCH     0x80   /* Divisor latch access bit.  */
 
#if TEST_MUX32
extern BYTE now_mux_addr;      // Current MUX32 address to send and receive commands.
#endif

extern void set_cont_reg(int, unsigned char);
extern void new_soft_hand(int);
extern int soft_handshaking(void);
extern void xoffed(void);
extern void xoned(void);
extern int xoff_sent(void);

extern void comm_close(void);
extern void comm_flush(void);
extern void comm_putc(uchar);
extern int comm_open(int, long unsigned int, unsigned char);
extern int comm_avail(void);
extern int comm_getc(void);

// ****************************************************************************
// Get the number of requested bytes form COMX.  Handle
// the interface with Intermec Application Development Tools.
// In particular, take what im_receive_buffer() gives us and try to get enough.
//
// Input:        Pointer to a buffer big enough for the number of bytes wonted.
//               The number of bytes being requested. How many wonted.
//               Units of 100ms for im_receive_buffer() timeout.
// Return:       BOOLEAN - TRUE, got requested number of bytes.
//                         FALSE, did NOT get the requested number of bytes.
// Side effects: None.
extern int com_rec_buf(BYTE *gotten_bytes, WORD wonted, WORD timeout);

// ****************************************************************************
// Send out data stream through serial port 
//   
// Input:        Pointer to bytes to be transmitted our COMX.
//               Number of bytes to be transmitted.
// Return:       None.
// Side effects: None.
void SendStream (BYTE *tx_buf, WORD data_size);
