using System;
using System.Windows.Forms;

namespace GlomClicks
{
	/// <summary>
	/// Subscribes a single click event to multiple click sources.
	/// </summary>
	public class ConglomerateClicks
	{
		public ConglomerateClicks() {}
		
		public void SubscribeTo(System.Windows.Forms.Button source)
		{
			// Subscribes our handler to the source's Click event.
			source.Click += new EventHandler(Handler);
		}

		void Handler(object sender, EventArgs e)
		{
			MessageBox.Show("Got click from " + sender.ToString(),
				"Got click", MessageBoxButtons.OK, MessageBoxIcon.Exclamation
			);
		}
	}
}
