#include <stdio.h>
#include <string.h>
#include <visa.h>
#include "FindInstr.h"

ViSession	defaultRM;
ViChar		buffer [VI_FIND_BUFLEN];
ViRsrc		instrDesc = buffer;
ViUInt32	instrCount;
ViFindList	scan_list;
ViStatus	status = 0;
char		buf [256] ;

/********************************************************************************************/

DLLEXPORT char* get_device_count(void)	 
{
	status = viOpenDefaultRM(&defaultRM);
	if(status<VI_SUCCESS){
		viStatusDesc(defaultRM,status,(ViPString)buf);
		return(buf);
		}
	
	viFindRsrc( defaultRM,"?*INSTR", &scan_list, &instrCount, instrDesc);
	if(!instrCount) {
		viClose(defaultRM); // closes all sessions using that resource manager session 
	}
	sprintf(buf,"%d",instrCount);
	return(buf);
}

/********************************************************************************************/

DLLEXPORT void  get_device_list(char** instrArray)
{
	// get instrument string, array element size reserved by VEE 
	ViSession temp_session;
	int i;

	if((int)instrCount == 0){
		instrArray[0]="no Instruments were found !";
		return;
	}
	
	status = viOpen(defaultRM,instrDesc,VI_NULL,VI_NULL,&temp_session);
	if(status == VI_SUCCESS_DEV_NPRESENT){
		strcat(instrArray[0],", dev not present");
	}
	viClose(temp_session);

	strcpy(instrArray[0],instrDesc);
	for (i=1;i<(int)instrCount;i++){
		viFindNext(scan_list,instrDesc);
		status = viOpen(defaultRM,instrDesc,VI_NULL,VI_NULL,&temp_session);
		strcpy(instrArray[i],instrDesc);
		if(status == VI_SUCCESS_DEV_NPRESENT){
			strcat(instrArray[i],", dev not present");
		}
		viClose(temp_session);
		}
	viClose(scan_list);
	viClose(defaultRM);
	defaultRM  = 0;
	scan_list  = 0;
	instrCount = 0;
}

/********************************************************************************************/