/////////////////////////////////////////////////////////////////////////////
// FTD2.c: fake Future Technologies dll used to test
//         the integrety of VEE function declarations.
//
// Copyright (C) 2004 by Black Cat Softwarare.
// Written by Shawn Fessenden (Author) for Rick Hart.
// The Author claims all rights to this source module.
//
// Tabs set at two (2) spaces.
// Environment: Microsoft Visual C++ 6.0 Enterprise SP5.
//
//
// The following specify STRICT type checking and disinclusion of rarely used stuff.
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

// The following specifies that this module is exporting function definitions.
#define FTD2XX_EXPORTS	//Fake like we're exporting funcs.
#include "FTD2XX.h"			//Future Tech. types & constants.

// The following are includes from the C RTL.
#include <stdio.h>	//For _vsnprintf.
#include <stdarg.h>	//For _vsnprintf (va_list).

// GLOBALS.
static HINSTANCE	ghInst = NULL;

/////////////////////////////////////////////////////////////////////////////
// DLLENTRY.
BOOL WINAPI DllMain(HINSTANCE hInst, DWORD fdwReason, LPVOID lpvReserved)
{
	switch(fdwReason) {
		case DLL_PROCESS_ATTACH:
			if(ghInst) return FALSE;
			DisableThreadLibraryCalls(hInst);
			ghInst = hInst;
		break;
		case DLL_PROCESS_DETACH:
			ghInst = NULL;
		break;
	}
	return TRUE;
}

void __cdecl Msg(LPSTR pFmt, ...)
{
	int		iBuf;
	char	szBuf[1024];

	va_list args;
	va_start(args, pFmt);

	iBuf = _vsnprintf(szBuf, 1024, pFmt, args);
	if(iBuf > 0) MessageBox(0, szBuf, NULL, MB_OK);

	va_end(args);
}

void ShowPftpd(LPSTR pContext, FT_HANDLE hDev, PFT_PROGRAM_DATA pData)
{
	char	szMsgBuf[10240];
	char	szIntBuf[81];

	wsprintf(szMsgBuf, "%s:\r\n\thDev = %08x\r\n\tpData = %08x\r\n\r\nBreakdown Follows:", pContext, hDev, pData);
	wsprintf(szIntBuf, "\r\n\tVendorId\t\t= 0x%04hx",		pData->VendorId);								lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tProductId\t\t= 0x%04hx",	pData->ProductId);							lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tManufacturer\t= %s",			pData->Manufacturer);						lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tManufacturerId\t= %s",		pData->ManufacturerId);					lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tDescription\t= %s",				pData->Description);						lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tSerialNumber\t= %s",			pData->SerialNumber);						lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tMaxPower\t= %hd",					pData->MaxPower);								lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tPnP\t\t= %hd",						pData->PnP);										lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tSelfPowered\t= %hd",			pData->SelfPowered);						lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tRemoteWakeup\t= %hd",			pData->RemoteWakeup);						lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tRev4\t\t= %d",						(int)pData->Rev4);							lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tIsoIn\t\t= %d",						(int)pData->IsoIn);							lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tIsoOut\t\t= %d",					(int)pData->IsoOut);						lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tPullDownEnable\t= %d",		(int)pData->PullDownEnable);		lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tSerNumEnable\t= %d",			(int)pData->SerNumEnable);			lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tUSBVersionEnable\t= %d",	(int)pData->USBVersionEnable);	lstrcat(szMsgBuf, szIntBuf);
	wsprintf(szIntBuf, "\r\n\tUSBVersion\t= 0x%04hx",		pData->USBVersion);							lstrcat(szMsgBuf, szIntBuf);
	MessageBox(NULL, szMsgBuf, "FT_PROGRAM_DATA", MB_OK);
}

FTD2XX_API FT_STATUS WINAPI FT_Open(int iDevice, FT_HANDLE *pHandle)
{
	Msg("Open:\r\n\tiDevice = %d\r\n\tpHandle = %08x\r\n\r\nPassing back 0xa5a5a5a5.", iDevice, pHandle);
	*pHandle = (FT_HANDLE)0xa5a5a5a5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_OpenEx(PVOID pvArg1, DWORD dwFlags, FT_HANDLE *pHandle)
{
	Msg("OpenEx:\r\n\tpvArg1 = %08x\r\n\tdwFlags = %08x\r\n\tpHandle = %08x\r\n\r\nPassing back 0xa5a5a5a5.", pvArg1, dwFlags, pHandle);
	*pHandle = (FT_HANDLE)0x5a5a5a5a;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_ListDevices(PVOID pvArg1, PVOID pvArg2, DWORD dwFlags)
{
	Msg("ListDevices:\r\n\tpvArg1 = %08x\r\n\tpvArg2 = %08x\r\n\tdwFlags = %08x\r\n\r\nPassing back 0xa5a5a5a5, 0x5a5a5a5a", pvArg1, pvArg2, dwFlags);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_Close(FT_HANDLE hDev)
{
	Msg("Close:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_Read(FT_HANDLE hDev, LPVOID pBuf, DWORD dwSize, LPDWORD pdwRead)
{
	Msg("Read:\r\n\thDev = %08x\r\n\tpBuf = %08x (%s)\r\n\tdwSize = %d\r\n\tpdwRead = %08x (%d)\r\n\r\nPassing back 'Samantha', 17", hDev, pBuf, (LPCSTR)pBuf, dwSize, pdwRead, *pdwRead);
	lstrcpy((LPSTR)pBuf, "Samantha");
	*pdwRead = (DWORD)17;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_Write(FT_HANDLE hDev, LPVOID pBuf, DWORD dwSize, LPDWORD pdwWritten)
{
	Msg("Write:\r\n\thDev = %08x\r\n\tpBuf = %08x (%s)\r\n\tdwSize = %d\r\n\tpdwWritten = %08x (%d)\r\n\r\nPassing back 0xa5a5a5a5", hDev, pBuf, (LPCSTR)pBuf, dwSize, pdwWritten, *pdwWritten);
	*pdwWritten = (DWORD)0xa5a5a5a5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_IoCtl(FT_HANDLE hDev, DWORD dwCtlCode, LPVOID pInBuf, DWORD dwInSize, LPVOID pOutBuf, DWORD dwOutSize, LPDWORD pdwBytesReturned, LPOVERLAPPED pOverlapped)
{
	Msg("IoCtl:\r\n\thDev = %08x\r\n\tdwCtlCode = %d\r\n\tpInBuf = %08x\r\n\tdwInSize = %d\r\n\tpOutBuf = %08x\r\n\tdwOutSize = %d\r\n\tpdwBytesReturned = %08x\r\n\tpOverlapped = %08x\r\n\r\nPassing back 1024", hDev, dwCtlCode, pInBuf, dwInSize, pOutBuf, dwOutSize, pdwBytesReturned, pOverlapped);
	*pdwBytesReturned = (DWORD)1024;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetBaudRate(FT_HANDLE hDev, ULONG ulBaudRate)
{
	Msg("SetBaudRate:\r\n\thDev = %08x\r\n\tulBaudRate = %d", hDev, ulBaudRate);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetDivisor(FT_HANDLE hDev, USHORT usDivisor)
{
	Msg("SetDivisor:\r\n\thDev = %08x\r\n\tusDivisor = %hd", hDev, usDivisor);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetDataCharacteristics(FT_HANDLE hDev, UCHAR ucWordLen, UCHAR ucStopBits, UCHAR ucParity)
{
	Msg("SetDataCharacterists:\r\n\thDev = %08x\r\n\tucWordLen = %d\r\n\tucStopBits = %d\r\n\tucParity = %d", hDev, (int)ucWordLen, (int)ucStopBits, (int)ucParity);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetFlowControl(FT_HANDLE hDev, USHORT usFlowControl, UCHAR ucXonChar, UCHAR ucXoffChar)
{
	Msg("SetFlowControl:\r\n\thDev = %08x\r\n\tusFlowControl = %d\r\n\tucXonChar = %02x\r\n\tucXoffChar = %02x", hDev, (int)usFlowControl, (int)ucXonChar, (int)ucXoffChar);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_ResetDevice(FT_HANDLE hDev)
{
	Msg("ResetDevice:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetDtr(FT_HANDLE hDev)
{
	Msg("SetDtr:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_ClrDtr(FT_HANDLE hDev)
{
	Msg("ClrDtr:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetRts(FT_HANDLE hDev)
{
	Msg("SetRts:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_ClrRts(FT_HANDLE hDev)
{
	Msg("ClrRts:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_GetModemStatus(FT_HANDLE hDev, PULONG pulStatus)
{
	Msg("GetModemStatus:\r\n\thDev = %08x\r\n\tpulStatus = %08x\r\n\r\nPassing back 0xa5", hDev, pulStatus);
	*pulStatus = (ULONG)0xa5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetChars(FT_HANDLE hDev, UCHAR ucEvent, UCHAR ucEventEnable, UCHAR ucErr, UCHAR ucErrEnable)
{
	Msg("SetChars:\r\n\thDev = %08x\r\n\tucEvent = %02x\r\n\tucEventEnable = %02x\r\n\tucErr = %02x\r\n\tucErrEnable = %02x", hDev, ucEvent, ucEventEnable, ucErr, ucErrEnable);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_Purge(FT_HANDLE hDev, ULONG ulMask)
{
	Msg("Purge:\r\n\thDev = %08x\r\n\tulMask = %08x", hDev, ulMask);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetTimeouts(FT_HANDLE hDev, ULONG ulRead, ULONG ulWrite)
{
	Msg("SetTimeouts:\r\n\thDev = %08x\r\n\tulRead = %d\r\n\tulWrite = %d", hDev, ulRead, ulWrite);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_GetQueueStatus(FT_HANDLE hDev, LPDWORD pdwRxBytes)
{
	Msg("GetQueueStatus:\r\n\thDev = %08x\r\n\tpdwRxBytes = %08x\r\n\r\nPassing back 0xa5a5a5a5", hDev, pdwRxBytes);
	*pdwRxBytes = (DWORD)0xa5a5a5a5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_GetStatus(FT_HANDLE hDev, LPDWORD pdwRxBytes, LPDWORD pdwTxBytes, LPDWORD pdwEventDWord)
{
	Msg("GetStatus:\r\n\thDev = %08x\r\n\tpdwRxBytes = %08x\r\n\tpdwTxBytes = %08x\r\n\tpdwEventDWord = %08x\r\n\r\nPassing back 0xa5a5a5a5, 0x5a5a5a5a, 0x01020304", pdwRxBytes, pdwTxBytes, pdwEventDWord);
	*pdwRxBytes			= (DWORD)0xa5a5a5a5;
	*pdwTxBytes			= (DWORD)0x5a5a5a5a;
	*pdwEventDWord	= (DWORD)0x01020304;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetBreakOn(FT_HANDLE hDev)
{
	Msg("SetBreakOn:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetBreakOff(FT_HANDLE hDev)
{
	Msg("SetBreakOff:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetWaitMask(FT_HANDLE hDev, DWORD dwMask)
{
	Msg("SetWaitMask:\r\n\thDev = %08x\r\n\tdwMask = %08x", hDev, dwMask);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_WaitOnMask(FT_HANDLE hDev, LPDWORD pdwMask)
{
	Msg("WaitOnMask:\r\n\thDev = %08x\r\n\tpdwMask = %08x\r\n\r\nPassing back 0xa5a5a5a5", hDev, pdwMask);
	*pdwMask = (DWORD)0xa5a5a5a5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_ReadEE(FT_HANDLE hDev, DWORD dwWordOffset, LPWORD pwValue)
{
	Msg("ReadEE:\r\n\thDev = %08x\r\n\tdwWordOffset = %d\r\n\tpwValue = %08x\r\n\r\nPassing back 0xa5a5", hDev, dwWordOffset, pwValue);
	*pwValue = (WORD)0xa5a5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_WriteEE(FT_HANDLE hDev, DWORD dwWordOffset, WORD wValue)
{
	Msg("WriteEE:\r\n\thDev = %08x\r\n\tdwWordOffset = %d\r\n\twValue = %04hx", hDev, dwWordOffset, wValue);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_EraseEE(FT_HANDLE hDev)
{
	Msg("EraseEE:\r\n\thDev = %08x", hDev);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_EE_Program(FT_HANDLE hDev, PFT_PROGRAM_DATA pData)
{
	ShowPftpd("EE_Program", hDev, pData);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_EE_Read(FT_HANDLE hDev, PFT_PROGRAM_DATA pData)
{
	ShowPftpd("EE_Read", hDev, pData);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_EE_UASize(FT_HANDLE hDev, LPDWORD pdwSize)
{
	Msg("EE_UASize:\r\n\thDev = %08x\r\n\tpdwSize = %08x\r\n\r\nPassing back 0xa5a5a5a5", hDev, pdwSize);
	*pdwSize = (DWORD)0xa5a5a5a5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_EE_UAWrite(FT_HANDLE hDev, PUCHAR pucData, DWORD dwDataLen)
{
	Msg("EE_UAWrite:\r\n\thDev = %08x\r\n\tpucData = %08x\r\n\tdwDataLen = %d", hDev, pucData, dwDataLen);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_EE_UARead(FT_HANDLE hDev, PUCHAR pucData, DWORD dwDataLen, LPDWORD pdwBytesReturned)
{
	Msg("EE_UARead:\r\n\thDev = %08x\r\n\tpucData = %08x\r\n\tdwDataLen = %d\r\n\tpdwBytesReturned = %08x\r\n\r\nPassing back 0xa5a5a5a5", hDev, pucData, dwDataLen, pdwBytesReturned);
	*pdwBytesReturned = (DWORD)0xa5a5a5a5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetLatencyTimer(FT_HANDLE hDev, UCHAR ucLatency)
{
	Msg("SetLatencyTimer:\r\n\thDev = %08x\r\n\tucLatency = %d", hDev, (int)ucLatency);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_GetLatencyTimer(FT_HANDLE hDev, PUCHAR pucLatency)
{
	Msg("GetLatencyTimer:\r\n\thDev = %08x\r\n\tpucLatency = %08x\r\n\r\nPassing back 0xa5", hDev, pucLatency);
	*pucLatency = (char)0xa5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetBitMode(FT_HANDLE hDev, UCHAR ucMask, UCHAR ucEnable)
{
	Msg("SetBitMode:\r\n\thDev = %08x\r\n\tucMask = %02x\r\n\tucEnable = %d", hDev, (int)ucMask, (int)ucEnable);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_GetBitMode(FT_HANDLE hDev, PUCHAR pucMode)
{
	Msg("GetBitMode:\r\n\thDev = %08x\r\n\tpucMode = %08x\r\n\r\nPassing back 0xa5", hDev, pucMode);
	*pucMode = (char)0xa5;
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_SetUSBParameters(FT_HANDLE hDev, ULONG ulInXferSize, ULONG ulOutXferSize)
{
	Msg("SetUSBParameters:\r\n\thDev = %08x\r\n\tulInXferSize = %08x\r\n\tulOutXferSize = %08x", hDev, ulInXferSize, ulOutXferSize);
	return FT_OK;
}

FTD2XX_API FT_STATUS WINAPI FT_GetDeviceInfo(FT_HANDLE hDev, FT_DEVICE *pDev, LPDWORD pdwID, PCHAR pSerialNumber, PCHAR pDescription, LPVOID pvDummy)
{
	Msg("GetDeviceInfo:\r\n\thDev = %08x\r\n\tpDev = %08x (%d)\r\n\tpdwID = %08x (%d)\r\n\tpSerialNumber = %08x (%s)\r\n\tpDescription = %08x (%s)\r\n\tpvDummy = %08x\r\n\r\nPassing back FT_DEVICE_UNKNOWN (3), 2, 'SN03', 'Decription', 0xa5a5a5a5", hDev, pDev, *pDev, pSerialNumber, pSerialNumber, pDescription, pDescription, pvDummy);
	*pDev = FT_DEVICE_UNKNOWN;
	*pdwID = (DWORD)2;
	lstrcpy(pSerialNumber, "SN03");
	lstrcpy(pDescription, "Description");
	*(PINT)pvDummy = 0xa5a5a5a5;
	return FT_OK;
}
