// Clipbrd1.cpp : implementation file
//

#include "stdafx.h"
#include "Clipbrd.h"
#include "Clipbrd1.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClipbrd

IMPLEMENT_DYNCREATE(CClipbrd, CCmdTarget)

CClipbrd::CClipbrd()
{
	EnableAutomation();
	
	// To keep the application running as long as an OLE automation 
	//	object is active, the constructor calls AfxOleLockApp.
	
	AfxOleLockApp();
}

CClipbrd::~CClipbrd()
{
	// To terminate the application when all objects created with
	// 	with OLE automation, the destructor calls AfxOleUnlockApp.
	
	AfxOleUnlockApp();
}


void CClipbrd::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CClipbrd, CCmdTarget)
	//{{AFX_MSG_MAP(CClipbrd)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CClipbrd, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CClipbrd)
	DISP_FUNCTION(CClipbrd, "SetText", SetText, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CClipbrd, "GetText", GetText, VT_BSTR, VTS_NONE)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IClipbrd to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {8D902D77-2829-4F0B-B539-753800A1C04D}
static const IID IID_IClipbrd =
{ 0x8d902d77, 0x2829, 0x4f0b, { 0xb5, 0x39, 0x75, 0x38, 0x0, 0xa1, 0xc0, 0x4d } };

BEGIN_INTERFACE_MAP(CClipbrd, CCmdTarget)
	INTERFACE_PART(CClipbrd, IID_IClipbrd, Dispatch)
END_INTERFACE_MAP()

// {E363C1CE-250C-4ABB-81C8-4003374041E9}
IMPLEMENT_OLECREATE(CClipbrd, "Clipbrd.Clipbrd", 0xe363c1ce, 0x250c, 0x4abb, 0x81, 0xc8, 0x40, 0x3, 0x37, 0x40, 0x41, 0xe9)

/////////////////////////////////////////////////////////////////////////////
// CClipbrd message handlers

void CClipbrd::SetText(LPCTSTR pText) 
{
	UINT		uLen;
	HANDLE	hData;
	LPTSTR	pData;

	// Copy text to clipboard.
	OpenClipboard(NULL);
	EmptyClipboard();
	uLen = lstrlen(pText) + 1;
	hData = GlobalAlloc(GMEM_MOVEABLE, uLen);
	pData = (LPTSTR)GlobalLock(hData);
	lstrcpy(pData, pText);
	GlobalUnlock(hData);
	SetClipboardData(CF_TEXT, hData);
	CloseClipboard();
}

BSTR CClipbrd::GetText() 
{
	DWORD		dwLen;
	LPTSTR	pData;
	HANDLE	hData;
	CString strResult;

	// Get clipboard text.
	OpenClipboard(NULL);
	if((hData = GetClipboardData(CF_TEXT))) {
		dwLen = GlobalSize(hData);
		pData = (LPTSTR)GlobalLock(hData);
		lstrcpy(strResult.GetBuffer(dwLen + 1), pData);
		strResult.ReleaseBuffer();
		GlobalUnlock(hData);
	}
	CloseClipboard();

	return strResult.AllocSysString();
}
