// Clipbrd.cpp : Implementation of CClipbrd
#include "stdafx.h"
#include "Clip.h"
#include "Clipbrd.h"

#include <comdef.h>

/////////////////////////////////////////////////////////////////////////////
// CClipbrd
STDMETHODIMP CClipbrd::get_Text(BSTR *pVal)
{
	HANDLE	hData;
	LPTSTR	pData;
	_bstr_t tmp;

	// If there's text on the clipboard, copy it.
	OpenClipboard(NULL);
	if((hData = GetClipboardData(CF_TEXT)) != NULL) {
		pData = (LPTSTR)GlobalLock(hData);
		tmp = pData;
		GlobalUnlock(hData);
	}
	CloseClipboard();

	// Return data to VEE.
	*pVal = SysAllocString(tmp);

	return S_OK;
}

STDMETHODIMP CClipbrd::put_Text(BSTR newVal)
{
	HANDLE	hData;
	LPTSTR	pData;

	// Wrap passed string.
	_bstr_t	tmp(newVal, false);

	// Get memory, copy string & pass to clipboard.
	hData = GlobalAlloc(GMEM_MOVEABLE, tmp.length() + 1);
	if((pData = (LPTSTR)GlobalLock(hData)) != NULL) {
		OpenClipboard(NULL);
		EmptyClipboard();
		lstrcpy(pData, tmp);
		GlobalUnlock(hData);
		SetClipboardData(CF_TEXT, hData);
		CloseClipboard();
	}
	else GlobalFree(hData);

	return S_OK;
}
