// Clipbrd.cpp : Implementation of CClipbrd
#include "stdafx.h"
#include "Clip.h"
#include "Clipbrd.h"

/////////////////////////////////////////////////////////////////////////////
// CClipbrd
STDMETHODIMP CClipbrd::get_Text(BSTR *pVal)
{
	INT			cch;
	HANDLE	hData, hCopy;
	LPTSTR	pData;
	OLECHAR	*pCopy;

	// If there's text on the clipboard, copy it.
	OpenClipboard(NULL);
 	if((hData = GetClipboardData(CF_TEXT)) != NULL) {
		if((pData = (LPTSTR)GlobalLock(hData)) != NULL) {

			// Find length of the OLECHAR version of the text and allocate a buffer.
			cch = (lstrlen(pData) + 1) * sizeof(OLECHAR);
			hCopy = GlobalAlloc(0, cch);
			pCopy = (OLECHAR*)GlobalLock(hCopy);
			
			// Convert the string to OLECHAR and copy it back to VEE.
			MultiByteToWideChar(CP_THREAD_ACP, 0, pData, -1, pCopy, cch);
			*pVal = SysAllocString(pCopy);

			// Clean  up.
			GlobalUnlock(hCopy);
			GlobalFree(hCopy);
			GlobalUnlock(hData);
		}
	}
	CloseClipboard();

	// Return a-ok.
	return S_OK;
}

STDMETHODIMP CClipbrd::put_Text(BSTR newVal)
{
	UINT		cch;
	HANDLE	hData;
	LPTSTR	pData;

	// Get length of string in characters.
	cch = SysStringLen(newVal);

	// Get memory, copy string & pass to clipboard.
	hData = GlobalAlloc(GMEM_MOVEABLE, cch + 1);
	if((pData = (LPTSTR)GlobalLock(hData)) != NULL) {
		OpenClipboard(NULL);
		EmptyClipboard();
		WideCharToMultiByte(CP_THREAD_ACP, 0, newVal, cch, pData, cch + 1, NULL, NULL);
		GlobalUnlock(hData);
		SetClipboardData(CF_TEXT, hData);
		CloseClipboard();
	}
	else GlobalFree(hData);

	return S_OK;
}
