#include "PeekPoke.h"

long openDriver(char *driverName){
	char *cookieString;
	HANDLE driverHandle;

	cookieString=(char *)malloc(strlen(driverName) + 1);
	if(!cookieString){
		return -1;
	}

	sprintf(cookieString, "\\\\.\\%s", driverName);

	driverHandle=CreateFile(cookieString, GENERIC_READ, 0, NULL,
							OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(INVALID_HANDLE_VALUE == driverHandle){
		return -2;
	}

	CloseHandle(driverHandle);

	return 0;
}

long writeByte(long port, long dataByte){
	return((long)(_outp((unsigned short)port, (int)dataByte)));
}

long writeWord(long port, long dataWord){
	return((long)(_outpw((unsigned short)port, (unsigned short)dataWord)));
}

long writeLongWord(long port, long dataLong){
	return((long)(_outpd((unsigned short)port, (unsigned long)dataLong)));
}

long readByte(long port){
	return((long)(_inp((unsigned short)port)));
}

long readWord(long port){
	return((long)(_inpw((unsigned short)port)));
}

long readLongWord(long port){
	return((long)(_inpd((unsigned short)port)));
}
