VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "BrosweCallbackClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Base 0
Option Explicit

Const WM_USER As Long = &H400

' Browse dialog message values.
Public Enum BrowseMessages
  ' Messages that can be sent to dialog during callback.
  bffmSetStatusText = WM_USER + 100 'Sets status text - see BrowseCallbackProc dox.
  bffmEnableOk = WM_USER + 101      'Enable the OK button.
  bffmSetSelection = WM_USER + 102  'Set selected path - see BrowseCallbackProc dox.
  bffmSetOkText = WM_USER + 105     'Sets text on OK button - see BrowseCallbackProc dox.
  bffmSetExpanded = WM_USER + 106   'Expand path - see BrowseCallbackProc dox.

  ' Messages received from dialog.
  bffmInitialized = 1     'Indicates dialog has finished initializing.
  bffmSelChanged = 2      'Indicates the selection has changed.
  bffmValidateFailed = 3  'Indicates that user typed an invalid name in the edit box.
  bffmIUnknown = 5        'Provides an IUnknown interface to the client.
End Enum

' BROWSEINFO Flags values.
Public Enum BrowseFlags
  bifReturnOnlyFSDirs = &H1       'Drives & Folders only.
  bifDontGoBelowDomain = &H2      'Show only domains but not below (BrowseForComputer).
  bifStatusText = &H4             'Optional status text below title.
  bifReturnFSAncestors = &H8
  bifEditBox = &H10               'Add edit box to dialog.
  bifValidate = &H20              'Only valid entries or cancel accepted.
  bifNewDialogStyle = &H40        'New layout (places bar) & sizable.
  bifUseNewUI = &H10 + &H40       'Use new dialog style & edit box.
  bifBrowseIncludeURLs = &H80     'Allow URLs.
  bifUAHint = &H100               'Add a UA hint in place of the edit box.
  bifNoNewFolderButton = &H200    'Don't show "New Folder" button in NewUI.
  bifNoTranslateTargets = &H400   'Don't traverse target as shortcut.
  bifBrowseForComputer = &H1000   'Browse for computers.
  bifBrowseForPrinters = &H2000   'Browse for printers.
  bifBrowseIncludeFiles = &H4000  'Browse for everything.
  bifBrowseShares = &H8000        'Include shares.
End Enum

' The BROWSEINFO structrue is used to initialize the browse dialog.
Public Type BROWSEINFO
  hWnd As Long            'IN:  Owner window.
  pidlRoot As Long        'IN:  Starts here.
  szDisplayName As String 'OUT: Returns display name of selection.
  szTitle As String       'IN:  Text that goes into the banner over the tree.
  ulFlags As Long         'IN:  Flags that control stuff.
  lpfn As Long            'IN:  Pointer to callback function.
  lParam As Long          'IN:  Extra data passed to callback.
  iImage As Long          'OUT: Index of icon image in system icon list.
End Type

Event Callback(ByVal hWnd As Long, ByVal uMsg As Long, ByVal lParam As Long, ByVal lpData As Long)

Private Sub Class_Initialize()
  ' Set global instance to Me.
  Set gCallback = Me
End Sub

Public Function GetCallback() As Long
  ' Return address of Callback function.
  GetCallback = AsLong(AddressOf modCallback.Callback)
End Function

Private Function AsLong(ByVal l As Long) As Long
  AsLong = l
End Function

Public Function Fire(ByVal hWnd As Long, ByVal uMsg As Long, ByVal lParam As Long, ByVal lpData As Long) As Long
  RaiseEvent Callback(hWnd, uMsg, lParam, lpData)
End Function
