#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define CHUNK_SIZE	16

#define DllExport __declspec(dllexport)

#define E_CREATE_OUT		-1	//STDOUT pipe creation failed.
#define E_REDIR_OUT			-2	//Redirecting STDOUT failed.
#define E_DUPE_HANDLE		-3	//DuplicateHandle failed.
#define E_CREATE_PROC		-4	//CreateProcess failed.
#define E_CLOSE_HANDLE	-5	//CloseHandle failed.
// NOTE: If CapOut returns a negative number other than these, then
//       the VEE array passed down is either just large enough or too
//       small to contain the output from the command executed.

// Because I can't find GetConsoleWindow...
typedef HWND (WINAPI* PFNGETCONSOLEWINDOW)();

// Because there's no such thing as libvapi.dll...
typedef void* (__cdecl* PFNVEEREALLOC)(void *pBlock, long iNumBytes);

BOOL	ImportGlobalFunctions(VOID);
BOOL	CreateChildProcess(PSTR pCmdLine);
DWORD	ReadFromPipe(PCHAR *ppBuf);
LONG	ParseBuf(PCHAR pBuf, PSTR* ppVeeStrings, LONG lNumStrings);

static	HANDLE		ghHeap = NULL;
static	HANDLE		hChildStdoutRd, hChildStdoutWr, hChildStdoutRdDup, hSaveStdout;
static	HINSTANCE	ghInst = NULL;

static	PFNVEEREALLOC				veeRealloc				= NULL;
static	PFNGETCONSOLEWINDOW	GetConsoleWindow	= NULL;

BOOL WINAPI DllMain(HINSTANCE hInst, DWORD dwReason, LPVOID lpvReserved)
{
	if(ghInst) return FALSE;

	switch(dwReason) {
		case DLL_PROCESS_ATTACH:
			if(!ImportGlobalFunctions()) return FALSE;
			ghInst = hInst;
			ghHeap = HeapCreate(HEAP_NO_SERIALIZE, 102400, 0);
			DisableThreadLibraryCalls(hInst);
		break;
		case DLL_PROCESS_DETACH:
			HeapDestroy(ghHeap);
			ghHeap = NULL;
			ghInst = NULL;
		break;
	}
	return TRUE;
}

BOOL ImportGlobalFunctions(VOID)
{
	INT			iLen;
	HKEY		hKeyVee;
	BYTE		szDir[MAX_PATH];
	DWORD		cbDir;
	HANDLE	hFind;
	HMODULE	hVeeRun;
	WIN32_FIND_DATA	fd;

	// Apparently, somebody forgot to include GetConsoleWindow in my headers.
	GetConsoleWindow = (PFNGETCONSOLEWINDOW)
		GetProcAddress(GetModuleHandle("kernel32"), "GetConsoleWindow");

	// Apparently, somebody forgot to tell lib that libvapi is implemented in veerun.
	// This is evil because it has to be version independent. Try both HP and Agilent.
	RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\Hewlett-Packard\\VEE", 0, KEY_READ, &hKeyVee);
	if(!hKeyVee) {
		RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\Agilent\\VEE", 0, KEY_READ, &hKeyVee);
		if(!hKeyVee) return FALSE;
	}

	// Ok, get install dir.
	cbDir = MAX_PATH;
	RegQueryValueEx(hKeyVee, "InstallDir", NULL, NULL, szDir, &cbDir);
	RegCloseKey(hKeyVee);

	// Unquote the directory.
	if(szDir[0] == '"') {
		iLen = lstrlen(szDir);
		MoveMemory(szDir, szDir + 1, iLen - 2);
		szDir[iLen - 2] = 0;
	}

	// Look for veerun*.dll.
	lstrcat(szDir, "\\veerun*.dll");
	hFind = FindFirstFile(szDir, &fd);
	if(hFind == INVALID_HANDLE_VALUE) return FALSE;
	FindClose(hFind);

	// At last.
	hVeeRun = GetModuleHandle(fd.cFileName);
	veeRealloc = (PFNVEEREALLOC)GetProcAddress(hVeeRun, "veeRealloc");

	// Wa absolutely *must* have veeRealloc.
	return (BOOL)veeRealloc;
}

DllExport LONG __stdcall CapOut(PSTR pCmdLine, PSTR* ppVeeStrings, LONG lNumStrings)
{
	HWND	hCon;
	BOOL	bAllocCon, bRet;
	LONG	lErr = 0;
	PCHAR	pBuf = NULL;
	SECURITY_ATTRIBUTES sa;

	// Set the bInheritHandle flag so pipe handles are inherited.
	sa.nLength = sizeof(sa);
	sa.bInheritHandle = TRUE;
	sa.lpSecurityDescriptor = NULL;

	// If necessary, create a console.
	// NOTE: if this is a dll called from VEE, there won't be a console.
	bAllocCon = FALSE;
	if(GetConsoleWindow) {
		hCon = GetConsoleWindow();
		if(!hCon) bAllocCon = AllocConsole();
		hCon = GetConsoleWindow();
		ShowWindow(hCon, SW_HIDE);
	}

	// Save the handle to the current STDOUT.
	hSaveStdout = GetStdHandle(STD_OUTPUT_HANDLE);

	// Create a pipe for the child process's STDOUT.
	if(!CreatePipe(&hChildStdoutRd, &hChildStdoutWr, &sa, 0)) {lErr = E_CREATE_OUT; goto ErrExit;}

	// Set a write handle to the pipe to be STDOUT.
	if(!SetStdHandle(STD_OUTPUT_HANDLE, hChildStdoutWr)) {lErr = E_REDIR_OUT; goto ErrExit;}

	// Create noninheritable read handle and close the inheritable read handle.
	bRet = DuplicateHandle(GetCurrentProcess(), hChildStdoutRd,
    GetCurrentProcess(), &hChildStdoutRdDup , 0, FALSE,	DUPLICATE_SAME_ACCESS);
	if(!bRet) {lErr = E_DUPE_HANDLE; goto ErrExit;}
	CloseHandle(hChildStdoutRd);

	// Now create the child process.
	if(!CreateChildProcess(pCmdLine)) {lErr = E_CREATE_PROC; goto ErrExit;}

	// After process creation, restore the saved STDOUT.
	if(!SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout)) {lErr = E_REDIR_OUT; goto ErrExit;}

	// Close the write end and read from the read end.
	CloseHandle(hChildStdoutWr);
	ReadFromPipe(&pBuf);
	CloseHandle(hChildStdoutRdDup);

	// Parse results.
	lErr = ParseBuf(pBuf, ppVeeStrings, lNumStrings);

	// Clean up.
ErrExit:
	if(pBuf) HeapFree(ghHeap, HEAP_NO_SERIALIZE, pBuf);
	if(bAllocCon) FreeConsole();
	return lErr;
}

BOOL CreateChildProcess(PSTR pCmdLine)
{
	CHAR								pCommand[MAX_PATH];
	STARTUPINFO					si;
	PROCESS_INFORMATION	pi;

	// Set up members of the PROCESS_INFORMATION structure.
	ZeroMemory(&pi, sizeof(pi));

	// Set up members of the STARTUPINFO structure.
	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);

	// Construct command line.
	GetEnvironmentVariable("COMSPEC", pCommand, MAX_PATH);
	lstrcat(pCommand, " /c ");
	wsprintf(pCommand + lstrlen(pCommand), "%s", pCmdLine);

	// Create.
	return CreateProcess(NULL, pCommand, NULL, NULL, TRUE, 0, NULL, NULL, &si, &pi);
}

DWORD ReadFromPipe(PCHAR *ppBuf)
{
	DWORD	dwTotal, dwAvail, dwRead;

	// Read output from the child process & stash it.
	dwTotal = 0;
	*ppBuf = HeapAlloc(ghHeap, HEAP_NO_SERIALIZE, CHUNK_SIZE);

	while(PeekNamedPipe(hChildStdoutRdDup, NULL, 0, NULL, &dwAvail, NULL)) {
		if(dwAvail > 0) {
			dwRead = 0;
			ReadFile(hChildStdoutRdDup, *ppBuf + dwTotal, CHUNK_SIZE, &dwRead, NULL);
			dwTotal += dwRead;
			HeapReAlloc(ghHeap, HEAP_NO_SERIALIZE | HEAP_REALLOC_IN_PLACE_ONLY, *ppBuf, dwTotal + CHUNK_SIZE);
		} else {
			Sleep(100);
		}
	}

	// Terminate buffer.
	(*ppBuf)[dwTotal] = 0;
	return dwTotal;
}

LONG ParseBuf(PCHAR pBuf, PSTR* ppVeeStrings, LONG lNumStrings)
{
	CHAR	c;
	LONG	lIdx = 0;
	PSTR	pString;
	BOOL	bTooSmall = FALSE;
	PCHAR	p = pBuf;

	// Init first.
	pString = p;

	// Parse.
	while(c = *p) {
		if(c == '\r') {
			*p = 0;
			ppVeeStrings[lIdx] = veeRealloc(ppVeeStrings[lIdx], lstrlen(pString) + 1);
			if(ppVeeStrings[lIdx]) lstrcpy(ppVeeStrings[lIdx], pString);
			pString = p + 2; lIdx++;
			if(lIdx == lNumStrings) {bTooSmall = TRUE; break;}
		}
		p++;
	}
	lIdx--;
	return (bTooSmall ? -lIdx : lIdx);
}
