// TESTIMPL.H : Declaration of the TTestImpl

#ifndef xTestImplH
#define xTestImplH

#include "test_server_TLB.h"


/////////////////////////////////////////////////////////////////////////////
// TTestImpl     Implements ITest, default interface of Test
// ThreadingModel : Apartment
// Dual Interface : TRUE
// Event Support  : FALSE
// Default ProgID : test_server.Test
// Description    :
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TTestImpl :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<TTestImpl, &CLSID_Test>,
  public IDispatchImpl<ITest, &IID_ITest, &LIBID_test_server>
{
public:
  TTestImpl()
  {
  }

  // Data used when registering Object
  //
  DECLARE_THREADING_MODEL(otApartment);
  DECLARE_PROGID("test_server.Test");
  DECLARE_DESCRIPTION("test");

  // Function invoked to (un)register object
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
  {
    TTypedComServerRegistrarT<TTestImpl>
    regObj(GetObjectCLSID(), GetProgID(), GetDescription());
    return regObj.UpdateRegistry(bRegister);
  }


BEGIN_COM_MAP(TTestImpl)
  COM_INTERFACE_ENTRY(ITest)
  COM_INTERFACE_ENTRY2(IDispatch, ITest)
END_COM_MAP()

// ITest
public:

  STDMETHOD(get_TestProperty(TVariant* Value));
};

#endif //TestImplH
