using System;
using System.Windows.Forms;

namespace GlomClicks
{
	/// <summary>
	/// Subscribes a single click event to multiple click sources.
	/// </summary>
	public class ConglomerateClicks
	{
		public ConglomerateClicks() {}

		public delegate void GotClick(object sender, EventArgs e);
		public event GotClick Click;
		
		public void SubscribeTo(Button source)
		{
			// Subscribes our handler to the source's Click event.
			source.Click += new EventHandler(Handler);
		}

		void Handler(object sender, EventArgs e) {Click(sender, e);}
	}
}
