﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO.Ports;
using System.IO;


namespace COMPort
{
    public class Serial
    {
        public static System.IO.Ports.SerialPort ComPort;
        private static bool gogo=false;
         
        private static string outstring;
        public static byte[] outbyte; //output in bytes

        private static void OnSerialDataReceived(
        object sender, SerialDataReceivedEventArgs args)
        {
 
            //string stringdata = "";
            while (ComPort.BytesToRead > 0)
            {
                outstring += Convert.ToChar(ComPort.ReadByte());
            }

            // convert a string to a byte array.
            System.Text.ASCIIEncoding encoding=new System.Text.ASCIIEncoding();
            outbyte = encoding.GetBytes(outstring);


            gogo = true;
        }

        public static void OpenCom(string port,int baud) 
        {
            string lport;
            int lbaud;

            if (port=="0")
            {
                lport = "COM1";
            }
            else if (port.Length < 4)
            {
                lport = "COM" + port;
            }
            else
            {
                lport = port;
            }
            if (baud == 0)
            {
                lbaud = 9600;
            }
            else
            {
                lbaud = baud;
            }
            
            outstring = "";

            gogo = false;
            ComPort = new System.IO.Ports.SerialPort(port, baud);
            ComPort.Parity = Parity.None;
            ComPort.StopBits = StopBits.One;
            ComPort.DataBits = 8;
            ComPort.Handshake = Handshake.None;
            ComPort.RtsEnable = true;
            ComPort.DataReceived += new SerialDataReceivedEventHandler(OnSerialDataReceived);            
            ComPort.Open();
           
        }

        public static void Close()
        {
            ComPort.Close();
        }

        
        

        public static string GetData(int timeoutseconds)
        {
            DateTime start = DateTime.Now;
            
            if(ComPort.IsOpen==false)
            {
                byte[] returnmsg = new byte[23];
                outstring="Error: Port Unavailable";
                for (int i = 0; i < 27;i++ )
                {
                    returnmsg[i] = (byte)Convert.ToByte(outstring[i]);
                }
                outbyte = returnmsg;

            }
            if (timeoutseconds < 3)
            {
                timeoutseconds = 3;
            }
            while (gogo==false)
            {
                System.Threading.Thread.Sleep(10);
                if ((DateTime.Now - start) > System.TimeSpan.FromSeconds(timeoutseconds))
                {
                    gogo = true;

                }
            }
            outstring = outstring.Replace("\r", "\n");
            
            return outstring;

        }




    }
}
