Attribute VB_Name = "modCallback"
Option Base 0
Option Explicit

Type RECT
  left As Long
  top As Long
  right As Long
  bottom As Long
End Type

Type SIZE
  cx As Long
  cy As Long
End Type

Declare Function GetWindowRect Lib "user32" (ByVal hWnd As Long, ByRef rc As RECT) As Long
Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
Declare Function MoveWindow Lib "user32" (ByVal hWnd As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal bRepaint As Long) As Long
Declare Function SHGetPathFromIDList Lib "shell32" Alias "SHGetPathFromIDListA" (ByVal pidl As Long, ByVal pPath As String) As Long
Declare Function SHParseDisplayName Lib "shell32" Alias "SHParseDisplayNameW" (ByVal sName As String, ByRef pbc As Any, ByRef ppidl As Long, ByVal sfgaofIn As Long, ByRef sfgaofOut As Long) As Long

Public m_hWnd As Long

Public Function Callback(ByVal hWnd As Long, ByVal uMsg As Long, ByVal lParam As Long, ByVal lpData As Long) As Long
  Dim rc As RECT, sz As SIZE
  Dim wi As Long, hi As Long
  Dim x As Long, y As Long

  ' If m_hWnd has not been initialized then do that now.
  If m_hWnd = 0 Then m_hWnd = hWnd

  ' Wait for bffmInitialized message.
  If uMsg = bffmInitialized Then

    ' Get window coords & screen size.
    Call GetWindowRect(hWnd, rc)
    sz.cx = GetSystemMetrics(0)
    sz.cy = GetSystemMetrics(1)

    ' Calculate center.
    wi = rc.right - rc.left
    hi = rc.bottom - rc.top
    x = (sz.cx - wi) / 2
    y = (sz.cy - hi) / 2

    ' Move dialog window.
    Call MoveWindow(hWnd, x, y, wi, hi, True)
  End If

  ' Dox say return 0.
  Callback = 0
End Function
