Attribute VB_Name = "modSubclass"
Option Base 0
Option Explicit

' Api functions.
Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal pszClass As String, ByVal pszWindow As Long) As Long
Public Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal iIndex As Long, ByVal lNewVal As Long) As Long
Public Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpfnPrevWndProc As Long, ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function GetLastError Lib "kernel32" () As Long

' Constants for api functions.
Public Const GWL_WNDPROC As Long = -4

' Local error constants.
Public Const ERR_NOWINDOW As Long = 1

' WM_xxx constants.
Public Const WM_COMMAND As Long = &H111

' Globals for general use.
Public ghVeeWnd As Long         'VEE's window handle.
Public glpfnPrevWndProc As Long 'VEE's original window proc.
Public glLastErr As Long        'Last error that occured.
Public gLRESULT As Long         'LRESULT to return from subclassing window proc.
Public gSubclass As SubCls      'Global used to fire event back to VEE.

' Global collection of message recognizer objects.
Public gmrRecognizers As Recognizers

Public Function WindowProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
  Dim mr As Recognizer

  ' See if this is a recognized message.
  For Each mr In gmrRecognizers
    If mr.uCompMsg = uMsg Then

      ' Check if we're recognizing wParam.
      If mr.wCompParam = -1 Or mr.wCompParam = wParam Then

        ' Check if we're recognizing lParam.
        If mr.lCompParam = -1 Or mr.lCompParam = lParam Then

          ' Message is recognized. Do replacements if requested.
          If mr.hRepWnd <> -1 Then hWnd = mr.hRepWnd
          If mr.uRepMsg <> -1 Then uMsg = mr.uRepMsg
          If mr.wRepParam <> -1 Then wParam = mr.wRepParam
          If mr.lRepParam <> -1 Then lParam = mr.lRepParam

          ' Notify VEE if requested.
          If mr.bFire Then Call gSubclass.Fire(hWnd, uMsg, wParam, lParam)

          ' If not to call original WP then return something.
          If Not mr.bCallWP Then
            If mr.lRetVal <> -1 Then
              WindowProc = mr.lRetVal
            Else
              WindowProc = gLRESULT
            End If
            Exit Function
          End If
        End If
      End If
    End If
  Next mr

  ' Message not recognized or we've chosen to call the original WP.
  WindowProc = CallWindowProc(glpfnPrevWndProc, hWnd, uMsg, wParam, lParam)
End Function
