VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SubCls"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Base 0
Option Explicit

' Used to notify VEE of recognized message events.
Event GotMsg(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long)

Private Sub Class_Initialize()
  ' Set global instance to me & init recognizer collection.
  Set gSubclass = Me
  Set gmrRecognizers = New Recognizers
End Sub

Private Sub Class_Terminate()
  ' Make sure we're unsubclassed.
  If glpfnPrevWndProc <> 0 Then
    Call Subclass(False)
  End If
End Sub

Public Function Subclass(ByVal bSubclass As Boolean, Optional ByVal hWnd As Long = 0) As Boolean
Attribute Subclass.VB_Description = "Subclass or unsubclass the VEE window."

  ' Init return.
  Subclass = False

  ' Subclassing or unsubclassing...
  If bSubclass Then

    ' If we're looking for the VEE window then look for it.
    If hWnd = 0 Then
      ghVeeWnd = FindWindow("Agilent_VEE", 0)
      If ghVeeWnd = 0 Then ghVeeWnd = FindWindow("HPVEE", 0)
      If ghVeeWnd = 0 Then
        glLastErr = ERR_NOWINDOW
        Exit Function
      End If
    Else
      ghVeeWnd = hWnd
    End If

    ' Subclass VEE window.
    glpfnPrevWndProc = SetWindowLong(ghVeeWnd, GWL_WNDPROC, AddressOf WindowProc)
    If glpfnPrevWndProc = 0 Then
      glLastErr = GetLastError()
      Exit Function
    End If

    ' All is ok.
    Subclass = True

  Else

    ' Unsubclass VEE window.
    glpfnPrevWndProc = SetWindowLong(ghVeeWnd, GWL_WNDPROC, glpfnPrevWndProc)
    If glpfnPrevWndProc = 0 Then
      glLastErr = GetLastError()
      Exit Function
    End If
    glpfnPrevWndProc = 0

    ' All is ok.
    Subclass = True
  End If
End Function

Public Sub RecognizeCommand(wParam As Long)
Attribute RecognizeCommand.VB_Description = "Recognize WM_COMMAND, wParam, notify VEE, return 0 and don't call original WindowProc."
  Dim mr As Recognizer
  Set mr = New Recognizer
  mr.uCompMsg = WM_COMMAND
  mr.wCompParam = wParam
  mr.lRetVal = 0
  Call AddRecognizer(mr)
End Sub

Public Function AddRecognizer(mr As Recognizer) As Recognizer
  Set AddRecognizer = gmrRecognizers.Add(mr)
End Function

Public Property Get Recognizers() As Recognizers
  Set Recognizers = gmrRecognizers
End Property

Public Property Set Recognizers(mrs As Recognizers)
  Set gmrRecognizers = mrs
End Property

Public Property Get Error() As Long
Attribute Error.VB_Description = "Returns last recorded error."
  Error = glLastErr
End Property

Public Property Let LRESULT(l As Long)
  gLRESULT = l
End Property

Public Property Get LRESULT() As Long
  LRESULT = gLRESULT
End Property

Public Function Fire(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Attribute Fire.VB_Description = "Hidden: used to fire event from subclassing WindowProc."
Attribute Fire.VB_MemberFlags = "40"
  RaiseEvent GotMsg(hWnd, uMsg, wParam, lParam)
End Function
