/*

How to register a DLL using regsvr32
------------------------------------
        Note the path to the dll on your machine

        Open a Command prompt  (Start -> Programs -> accessories -> command prompt )

        In the prompt type "cd" followed by a space and then  the path to the folder containing the dll .
        eg: if the dll was stored in C:\WINNT\system32 you would type "cd WINNT\system32"

        type regsvr32 followed by a space and the dll filename

        The DLL should then be successfully registered
*/

#include<stdlib.h>

#ifdef __cplusplus
#define EXPORT extern "C" __declspec (dllexport)
#else 
#define EXPORT __declspec (dllexport)
#endif

EXPORT int SndOpen();
EXPORT int SndRecord(char* name);
EXPORT int SndStop();
EXPORT int SndClose();

#ifdef UNICODE

#define SndOpen SndOpen 
#define SndSetParams SndSetParams 
#define SndRecord SndRecord 
#define SndClose SndClose

#else

#define SndOpen SndOpen 
#define SndSetParams SndSetParams 
#define SndRecord SndRecord 
#define SndClose SndClose

#endif