#include<windows.h>
#include<stdio.h>
#include<conio.h>
#include<mmsystem.h>

#include "sound.h"

union _WAVEPARAMS
{
        MCI_WAVE_OPEN_PARMS     WaveOpenParms;
        MCI_RECORD_PARMS        WaveRecordParms;
        MCI_SAVE_PARMS          WaveSaveParms;
        MCI_WAVE_SET_PARMS      WaveSetParms;
        LPMCI_GENERIC_PARMS GenericParams;
} WAVEPARAMS;

DWORD                           error;
union _WAVEPARAMS       params;
MCIDEVICEID                     devID;
char*                           szFileName;

int SndSave();
int SndStop();
int SndClose();
int SndSetParams();

int WINAPI DllMain(     HINSTANCE hInstance, DWORD dWord, LPVOID lpVoid ) {
        return TRUE;
}

void PrintWaveErrorMsg(DWORD err, TCHAR * str) {
#define BUFFERSIZE 128
        char    buffer[BUFFERSIZE];
        
        printf("ERROR 0x%08X: %s\r\n", err, str);
        if (mciGetErrorString(err, &buffer[0], sizeof(buffer))) {
                printf("%s\r\n", &buffer[0]);
        } else {
                printf("0x%08X returned!\r\n", err);
        }
}

EXPORT int SndOpen() {
        params.WaveOpenParms.lpstrDeviceType = (LPSTR) MCI_DEVTYPE_WAVEFORM_AUDIO;
        params.WaveOpenParms.lpstrElementName = "";
        
        error = mciSendCommand(0,MCI_OPEN,
                MCI_WAIT                        |
                MCI_OPEN_ELEMENT        |
                MCI_OPEN_TYPE           |
                MCI_OPEN_TYPE_ID        ,
                (DWORD)(LPVOID)&params.WaveOpenParms 
        );
                
        if( error ) {
                PrintWaveErrorMsg(error,"Could not open wave audio device");
                return -1;
        } else {
                devID = params.WaveOpenParms.wDeviceID;
                SndSetParams();
                return FALSE;
        }
} 

int SndSetParams() {

        //MessageBox(NULL,TEXT("SndSetParams says hiii"),TEXT(""),MB_ICONERROR);
        
        ZeroMemory( &params.WaveSetParms, sizeof( MCI_WAVE_SET_PARMS ));
        
        params.WaveSetParms.wFormatTag = WAVE_FORMAT_PCM;
        params.WaveSetParms.nChannels = 1;
        params.WaveSetParms.nSamplesPerSec = 44100;
        params.WaveSetParms.wBitsPerSample = 16;
        
        params.WaveSetParms.nBlockAlign = 2;
                //(( params.WaveSetParms.wBitsPerSample)/8) 
                //* params.WaveSetParms.nChannels;

        params.WaveSetParms.nAvgBytesPerSec = 44100;
                //params.WaveSetParms.nBlockAlign 
                //* params.WaveSetParms.nSamplesPerSec;

        error = mciSendCommand( devID, MCI_SET,
                MCI_WAVE_SET_FORMATTAG          |
                MCI_WAVE_SET_BITSPERSAMPLE      |
                MCI_WAVE_SET_CHANNELS           |
                MCI_WAVE_SET_SAMPLESPERSEC      |
                MCI_WAVE_SET_AVGBYTESPERSEC     |
                MCI_WAVE_SET_BLOCKALIGN         ,
                (DWORD)(LPVOID)&params.WaveSetParms     );

        if( error ) {
                PrintWaveErrorMsg(error,"Could not set parameters");
                return -1;
        } else {
                return 0;
        }
} 

EXPORT int SndRecord(char* name) {

        szFileName = name;

        error = mciSendCommand( devID, MCI_RECORD, 
                MCI_NOTIFY      |
                MCI_RECORD_OVERWRITE    ,
                (DWORD)(LPVOID)&params.WaveRecordParms );

        if( error ) {
                PrintWaveErrorMsg( error, "Could not record" );
                return -1;
        } 
        return 0;
}

int SndStop(){
        
        error = mciSendCommand( devID, MCI_STOP, 
                MCI_WAIT, (DWORD) (LPMCI_GENERIC_PARMS) & params.GenericParams );

        if( error ) {
                PrintWaveErrorMsg( error, "Could not stop" );
                return -1;
        }

        SndSave();
        return 0;
}

int SndSave( char* name ) {
        params.WaveSaveParms.lpfilename = szFileName;
        
        error = mciSendCommand( devID, MCI_SAVE,
                MCI_WAIT                |
                MCI_SAVE_FILE   ,
                (DWORD)(LPVOID)&params.WaveSaveParms);

        if( error ) {
                PrintWaveErrorMsg( error, "Could not save" );
                return -1;
        } 
        return 0;
}

EXPORT int SndClose() {
        mciSendCommand( devID, MCI_CLOSE, 
                MCI_WAIT, (DWORD)(LPVOID)&params.WaveOpenParms);
        return 0;
}
