////////////////////////////////////////////////////////////////////////////////
//
// File:
//
//    Ni845x.h
//
// Purpose:
//
//    This file contains function prototypes exported by the driver,
//    error codes, function arguments, and basic type definitions.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef __Ni845x_HEADER__
#define __Ni845x_HEADER__

#ifdef __cplusplus
   extern "C" {
#endif

#define NI845X_FUNC  __stdcall


///////////////////////////////////////////////////////////////////////////////
//
// Type Definitions
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _NI_int8_DEFINED_
#define _NI_int8_DEFINED_
   typedef char            int8;
#endif
#ifndef _NI_uInt8_DEFINED_
#define _NI_uInt8_DEFINED_
   typedef unsigned char   uInt8;
#endif
#ifndef _NI_int16_DEFINED_
#define _NI_int16_DEFINED_
   typedef short           int16;
#endif
#ifndef _NI_uInt16_DEFINED_
#define _NI_uInt16_DEFINED_
   typedef unsigned short  uInt16;
#endif
#ifndef _NI_int32_DEFINED_
#define _NI_int32_DEFINED_
   typedef long            int32;
#endif
#ifndef _NI_uInt32_DEFINED_
#define _NI_uInt32_DEFINED_
   typedef unsigned long   uInt32;
#endif


///////////////////////////////////////////////////////////////////////////////
//
// Status Codes
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////
//
// Warnings 
//
///////////////////////////////////////
#define kNi845xWarningClockRateCoerced             301700
#define kNi845xWarningUnknown                      301719

///////////////////////////////////////
//
// Local Errors
//
///////////////////////////////////////
#define kNi845xErrorNoError                        0
#define kNi845xErrorInsufficientMemory            -301700
#define kNi845xErrorInvalidResourceName           -301701
#define kNi845xErrorInvalidClockRate              -301702
#define kNi845xErrorTooManyScriptReads            -301703
#define kNi845xErrorInvalidScriptReadIndex        -301704
#define kNi845xErrorInvalidScriptReference        -301705
#define kNi845xErrorInvalidDeviceId               -301706
#define kNi845xErrorConnectionLost                -301707
#define kNi845xErrorTimeout                       -301708
#define kNi845xErrorInternal                      -301709
#define kNi845xErrorInvalidConfigurationReference -301710
#define kNi845xErrorTooManyConfigurations         -301711
#define kNi845xErrorInvalidActiveProperty         -301712
#define kNi845xErrorInvalidParameter              -301713
#define kNi845xErrorResourceBusy                  -301714
#define kNi845xErrorUnknown                       -301719

///////////////////////////////////////
//
// General Errors from the device
//
///////////////////////////////////////
#define kNi845xErrorBadOpcode                     -301720
#define kNi845xErrorUnknownStatus                 -301721
#define kNi845xErrorProtocolViolation             -301722

///////////////////////////////////////
//
// SPI Errors from the device
//
///////////////////////////////////////
#define kNi845xErrorMasterWriteCollision          -301730
#define kNi845xErrorInvalidSpiPortNumber          -301732
#define kNi845xErrorInvalidCsPortNumber           -301733
#define kNi845xErrorInvalidChipSelect             -301734

///////////////////////////////////////
//
// I2C Errors from the device
//
///////////////////////////////////////
#define kNi845xErrorMasterBusFreeTimeout          -301740
#define kNi845xErrorMasterAddressNotAcknowledged  -301742
#define kNi845xErrorMasterDataNotAcknowledged     -301743
#define kNi845xErrorMasterAddressArbitrationLost  -301744
#define kNi845xErrorMasterDataArbitrationLost     -301745
#define kNi845xErrorInvalidI2CPortNumber          -301746

///////////////////////////////////////
//
// DIO Errors from the device
//
///////////////////////////////////////
#define kNi845xErrorInvalidDioPortNumber          -301750
#define kNi845xErrorInvalidDioLineNumber          -301751

///////////////////////////////////////
//
// SPI Function Arguments
//
///////////////////////////////////////
#define kNi845xSpiClockPolarityIdleLow             0
#define kNi845xSpiClockPolarityIdleHigh            1
#define kNi845xSpiClockPhaseFirstEdge              0
#define kNi845xSpiClockPhaseSecondEdge             1

///////////////////////////////////////
//
// I2C Function Arguments
//
///////////////////////////////////////
#define kNi845xI2cAddress7Bit                      0
#define kNi845xI2cAddress10Bit                     1
#define kNi845xI2cNakFalse                         0
#define kNi845xI2cNakTrue                          1

///////////////////////////////////////
//
// DIO Function Arguments
//
///////////////////////////////////////
#define kNi845xDioInput                            0
#define kNi845xDioOutput                           1
#define kNi845xDioLogicLow                         0
#define kNi845xDioLogicHigh                        1

///////////////////////////////////////
//
// Generic Function Arguments
//
///////////////////////////////////////
#define kNi845xOpenDrain                           0
#define kNi845xPushPull33Volts                     1


///////////////////////////////////////////////////////////////////////////////
//
// CVI User Protection
//
///////////////////////////////////////////////////////////////////////////////

#ifdef _CVI_
#pragma EnableLibraryRuntimeChecking
#endif


///////////////////////////////////////////////////////////////////////////////
//
// DEVICE FUNCTION PROTOTYPES
//
///////////////////////////////////////////////////////////////////////////////

int32 NI845X_FUNC ni845xFindDevice (
   char   * pFirstDevice,
   uInt32 * pFindDeviceHandle,
   uInt32 * pNumberFound
   );

int32 NI845X_FUNC ni845xFindDeviceNext (
   uInt32 FindDeviceHandle,
   char * pNextDevice
   );

int32 NI845X_FUNC ni845xCloseFindDeviceHandle(
   uInt32 FindDeviceHandle
   );

int32 NI845X_FUNC ni845xOpen(
   char   * pResourceName,
   uInt32 * pDeviceHandle
   );

int32 NI845X_FUNC ni845xClose (uInt32 DeviceHandle);

int32 NI845X_FUNC ni845xDeviceLock (uInt32 DeviceHandle);

int32 NI845X_FUNC ni845xDeviceUnlock (uInt32 DeviceHandle);

void NI845X_FUNC ni845xStatusToString( 
   int32   StatusCode,
   uInt32  MaxSize,
   int8  * pStatusString
   );


///////////////////////////////////////////////////////////////////////////////
//
// SPI BASIC API FUNCTION PROTOTYPES
//
///////////////////////////////////////////////////////////////////////////////
int32 NI845X_FUNC ni845xSpiWriteRead(
   uInt32   DeviceHandle,
   uInt32   ConfigurationHandle,
   uInt32   WriteSize,
   uInt8  * pWriteData,
   uInt32 * pReadSize,
   uInt8  * pReadData
   );

int32 NI845X_FUNC ni845xSpiConfigurationOpen (uInt32 * pConfigurationHandle);

int32 NI845X_FUNC ni845xSpiConfigurationClose (uInt32 ConfigurationHandle);

int32 NI845X_FUNC ni845xSpiConfigurationSetChipSelect (
   uInt32 ConfigurationHandle,
   uInt32 ChipSelect
   );

int32 NI845X_FUNC ni845xSpiConfigurationSetClockRate (
   uInt32 ConfigurationHandle,
   uInt16 ClockRate
   );

int32 NI845X_FUNC ni845xSpiConfigurationSetClockPolarity (
   uInt32 ConfigurationHandle,
   int32  ClockPolarity
   );

int32 NI845X_FUNC ni845xSpiConfigurationSetClockPhase (
   uInt32 ConfigurationHandle,
   int32  ClockPhase
   );

int32 NI845X_FUNC ni845xSpiConfigurationSetPort (
   uInt32 ConfigurationHandle,
   uInt8  Port
   );

int32 NI845X_FUNC ni845xSpiConfigurationGetChipSelect (
   uInt32   ConfigurationHandle, 
   uInt32 * pChipSelect
   );

int32 NI845X_FUNC ni845xSpiConfigurationGetClockRate (
   uInt32   ConfigurationHandle, 
   uInt16 * pClockRate
   );

int32 NI845X_FUNC ni845xSpiConfigurationGetClockPolarity (
   uInt32  ConfigurationHandle, 
   int32 * pClockPolarity
   );

int32 NI845X_FUNC ni845xSpiConfigurationGetClockPhase (
   uInt32  ConfigurationHandle, 
   int32 * pClockPhase
   );

int32 NI845X_FUNC ni845xSpiConfigurationGetPort (
   uInt32  ConfigurationHandle, 
   uInt8 * pPort
   );

///////////////////////////////////////////////////////////////////////////////
//
// SPI ADVANCED API FUNCTION PROTOTYPES
//
///////////////////////////////////////////////////////////////////////////////
int32 NI845X_FUNC ni845xSpiScriptOpen (uInt32 * pScriptHandle);

int32 NI845X_FUNC ni845xSpiScriptClose (uInt32 ScriptHandle);

int32 NI845X_FUNC ni845xSpiScriptRun (
   uInt32 ScriptHandle,
   uInt32 DeviceHandle,
   uInt8  PortNumber
   );

int32 NI845X_FUNC ni845xSpiScriptReset (uInt32 ScriptHandle);

int32 NI845X_FUNC ni845xSpiScriptClockPolarityPhase (
   uInt32 ScriptHandle,
   int32  Polarity,
   int32  Phase
   );

int32 NI845X_FUNC ni845xSpiScriptClockRate (
   uInt32 ScriptHandle,
   uInt16 ClockRate
   );

int32 NI845X_FUNC ni845xSpiScriptCSLow (
   uInt32 ScriptHandle,
   uInt32 ChipSelectNum
   );

int32 NI845X_FUNC ni845xSpiScriptCSHigh (
   uInt32 ScriptHandle,
   uInt32 ChipSelectNum
   );

int32 NI845X_FUNC ni845xSpiScriptWriteRead (
   uInt32   ScriptHandle,
   uInt32   WriteSize,
   uInt8  * pWriteData,
   uInt32 * pScriptReadIndex
   );

int32 NI845X_FUNC ni845xSpiScriptDelay (
   uInt32 ScriptHandle,
   uInt8  Delay
   );

int32 NI845X_FUNC ni845xSpiScriptEnableSPI (
   uInt32 ScriptHandle
   );

int32 NI845X_FUNC ni845xSpiScriptDisableSPI (
   uInt32 ScriptHandle
   );

int32 NI845X_FUNC ni845xSpiScriptDioConfigurePort(
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  ConfigurationValue
   );

int32 NI845X_FUNC ni845xSpiScriptDioWritePort (
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  WriteData
   );

int32 NI845X_FUNC ni845xSpiScriptDioReadPort (
   uInt32   ScriptHandle,
   uInt8    PortNumber,
   uInt32 * pScriptReadIndex
   );

int32 NI845X_FUNC ni845xSpiScriptDioConfigureLine (
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  LineNumber,
   int32  ConfigurationValue
   );

int32 NI845X_FUNC ni845xSpiScriptDioWriteLine ( 
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  LineNumber,
   int32  WriteData
   );

int32 NI845X_FUNC ni845xSpiScriptDioReadLine (
   uInt32   ScriptHandle,
   uInt8    PortNumber,
   uInt8    LineNumber,
   uInt32 * pScriptReadIndex
   );

int32 NI845X_FUNC ni845xSpiScriptExtractReadData (
   uInt32  ScriptHandle,
   uInt32  ScriptReadIndex,
   uInt8 * pReadData
   );

int32 NI845X_FUNC ni845xSpiScriptExtractReadDataSize (
   uInt32   ScriptHandle,
   uInt32   ScriptReadIndex,
   uInt32 * pReadDataSize
   );

///////////////////////////////////////////////////////////////////////////////
//
// I2C BASIC API FUNCTION PROTOTYPES
//
///////////////////////////////////////////////////////////////////////////////
int32 NI845X_FUNC ni845xI2cWrite (
   uInt32  DeviceHandle,
   uInt32  ConfigurationHandle,
   uInt32  WriteSize,
   uInt8 * pWriteData
   );

int32 NI845X_FUNC ni845xI2cRead (
   uInt32   DeviceHandle,
   uInt32   ConfigurationHandle,
   uInt32   NumBytesToRead,
   uInt32 * pReadSize,
   uInt8  * pReadData
   );

int32 NI845X_FUNC ni845xI2cWriteRead (
   uInt32   DeviceHandle,
   uInt32   ConfigurationHandle,
   uInt32   WriteSize,
   uInt8  * pWriteData,
   uInt32   NumBytesToRead,
   uInt32 * pReadSize,
   uInt8  * pReadData
   );

int32 NI845X_FUNC ni845xI2cConfigurationOpen (uInt32 * pConfigurationHandle);

int32 NI845X_FUNC ni845xI2cConfigurationClose (
   uInt32 ConfigurationHandle
   );

int32 NI845X_FUNC ni845xI2cConfigurationSetPort (
   uInt32 ConfigurationHandle,
   uInt8  PortNumber
   );

int32 NI845X_FUNC ni845xI2cConfigurationSetAddress (
   uInt32 ConfigurationHandle,
   uInt16 Address
   );

int32 NI845X_FUNC ni845xI2cConfigurationSetClockRate (
   uInt32 ConfigurationHandle,
   uInt16 ClockRate
   );

int32 NI845X_FUNC ni845xI2cConfigurationSetAddressSize (
   uInt32 ConfigurationHandle,
   int32  Size
   );

int32 NI845X_FUNC ni845xI2cConfigurationGetPort (
   uInt32  ConfigurationHandle,
   uInt8 * pPort
   );

int32 NI845X_FUNC ni845xI2cConfigurationGetAddress (
   uInt32   ConfigurationHandle,
   uInt16 * pAddress
   );

int32 NI845X_FUNC ni845xI2cConfigurationGetClockRate (
   uInt32   ConfigurationHandle,
   uInt16 * pClockRate
   );

int32 NI845X_FUNC ni845xI2cConfigurationGetAddressSize (
   uInt32  ConfigurationHandle,
   int32 * pSize
   );

///////////////////////////////////////////////////////////////////////////////
//
// I2C ADVANCED FUNCTION PROTOTYPES
//
///////////////////////////////////////////////////////////////////////////////
int32 NI845X_FUNC ni845xI2cScriptOpen (uInt32 * pScriptHandle);

int32 NI845X_FUNC ni845xI2cScriptClose (uInt32 ScriptHandle);

int32 NI845X_FUNC ni845xI2cScriptRun (
   uInt32 ScriptHandle,
   uInt32 DeviceHandle,
   uInt8  PortNumber
   );

int32 NI845X_FUNC ni845xI2cScriptReset (uInt32 ScriptHandle);

int32 NI845X_FUNC ni845xI2cScriptIssueStart (
   uInt32 ScriptHandle
   );

int32 NI845X_FUNC ni845xI2cScriptAddressWrite (
   uInt32 ScriptHandle,
   uInt8  Address
   );

int32 NI845X_FUNC ni845xI2cScriptAddressRead (
   uInt32 ScriptHandle,
   uInt8  Address
   );

int32 NI845X_FUNC ni845xI2cScriptIssueStop (
   uInt32 ScriptHandle
   );

int32 NI845X_FUNC ni845xI2cScriptWrite (
   uInt32   ScriptHandle,
   uInt32   WriteSize,
   uInt8  * pWriteData
   );

int32 NI845X_FUNC ni845xI2cScriptRead (
   uInt32   ScriptHandle,
   uInt32   NumBytesToRead,
   int32    NotAcknowledgeLastByte,
   uInt32 * pScriptReadIndex
   );

int32 NI845X_FUNC ni845xI2cScriptDelay (
   uInt32 ScriptHandle,
   uInt8  Delay
   );

int32 NI845X_FUNC ni845xI2cScriptClockRate (
   uInt32 ScriptHandle,
   uInt16 ClockRate
   );

int32 NI845X_FUNC ni845xI2cScriptDioConfigurePort (
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  ConfigurationValue
   );

int32 NI845X_FUNC ni845xI2cScriptDioWritePort (
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  WriteData
   );

int32 NI845X_FUNC ni845xI2cScriptDioReadPort (
   uInt32   ScriptHandle,
   uInt8    PortNumber,
   uInt32 * pScriptReadIndex
   );

int32 NI845X_FUNC ni845xI2cScriptDioConfigureLine (
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  LineNumber,
   int32  ConfigurationValue
   );

int32 NI845X_FUNC ni845xI2cScriptDioWriteLine (
   uInt32 ScriptHandle,
   uInt8  PortNumber,
   uInt8  LineNumber,
   int32  WriteData
   );

int32 NI845X_FUNC ni845xI2cScriptDioReadLine (
   uInt32   ScriptHandle,
   uInt8    PortNumber,
   uInt8    LineNumber,
   uInt32 * pScriptReadIndex
   );

int32 NI845X_FUNC ni845xI2cScriptExtractReadData (
   uInt32   ScriptHandle,
   uInt32   ScriptReadIndex,
   uInt8  * pReadData
   );

int32 NI845X_FUNC ni845xI2cScriptExtractReadDataSize (
   uInt32   ScriptHandle,
   uInt32   ScriptReadIndex,
   uInt32 * pReadDataSize
   );

///////////////////////////////////////////////////////////////////////////////
//
// DIO I/O FUNCTION PROTOTYPES
//
///////////////////////////////////////////////////////////////////////////////
int32 NI845X_FUNC ni845xDioWritePort (
   uInt32 DeviceHandle,
   uInt8  PortNumber,
   uInt8  WriteData
   );

int32 NI845X_FUNC ni845xDioReadPort (
   uInt32  DeviceHandle,
   uInt8   PortNumber,
   uInt8 * pReadData
   );

int32 NI845X_FUNC ni845xDioWriteLine (
   uInt32 DeviceHandle,
   uInt8  PortNumber,
   uInt8  LineNumber,
   int32  WriteData
   );

int32 NI845X_FUNC ni845xDioReadLine (
   uInt32  DeviceHandle,
   uInt8   PortNumber,
   uInt8   LineNumber,
   int32 * pReadData
   );

int32 NI845X_FUNC ni845xDioSetPortVoltageType (
   uInt32 DeviceHandle, 
   uInt8  DioPort,
   uInt8  Type
   );

int32 NI845X_FUNC ni845xDioSetPortLineDirectionMap (
   uInt32 DeviceHandle, 
   uInt8  DioPort,
   uInt8  Map
   );


#ifdef __cplusplus
   }
#endif 

#endif // __Ni845x_HEADER__
