	list	p=16f874
	include	<p16F874.inc>

	__CONFIG _CP_OFF & _XT_OSC & _PWRTE_ON  & _WDT_OFF & _BODEN_OFF & _LVP_OFF

DtoAAddress	equ	0x20
DtoAHiData	equ	0x21
DtoALoData	equ	0x22
AtoDAddress	equ	0x23
AtoDHiData	equ	0x24
AtoDLoData	equ	0x25
AtoDChannel	equ	0x26
TxError	equ	0x27
USBDataIn	equ	0x28
USBDataOut	equ	0x29
Counter		equ	0x2a
Temp		equ	0x3f


	org	0x00		; Set program memory at reset vector 0x00
Reset
	goto	Start


	org	0x04		; Set program memory to interupt vector
	goto ISRoutine




	org	0x08		; Set memory to beginning of the user code
Start
	bsf STATUS,RP0		; Use register bank 1

	movlw b'00001100'	;} Set bits 2 & 3 for input for USB (TXE & RXF)
	movwf TRISA		;} Set bits 0 & 1 for output for USB (WR & RD)

	clrf TRISB		; Set port B to output

	movlw b'00011000'	;} Set bits 3 & 4 for input for I2C
	movwf TRISC		;}

	movlw h'ff'		;} Set port D to input
	movwf TRISD		;}

	bcf SSPCON2,GCEN	; Disable general call mode (I2C)
	bsf SSPCON2,PEN		; Send stop signal

	movlw b'00000101'	;} 
	movwf SSPADD		;} Master mode clock <400kHz

	MOVLW	0x06
	MOVWF	ADCON1		;PORTA DIGITAL INPUTS

	bcf STATUS,RP0		; Use register bank 0

	movlw b'00101000'	;} Enable I2C (bit 5)
	movwf SSPCON		;} Master mode (1000 bits 0 to 3)

	movlw b'00100000'	;}
	movwf AtoDChannel	;} Talk to AtoD on I2C bus and set to channel 0
;	Call SlowAtoDSetup	;}


Main

	btfsc PORTA,3
	goto Main
	call USBRead
	movf USBDataIn,w
	sublw 0xff
	btfss STATUS,Z	
	goto Main

	incf USBDataOut,1
noTXF	btfsc PORTA,2	
	goto noTXF
	Call USBWrite
	goto Main	


;	call SlowAtoDRead
;	movf AtoDLoData,w
;	movwf PORTB
;	goto Main



USBRead	; Only call this routine if RXF is low

	bcf PORTA,1		; Take RD line low
	movf PORTD,w		; Transfer data into W
	bsf PORTA,1		; Take RD line high again
	movwf USBDataIn

	return


USBWrite	; Only call this routine if TXE is low

	bsf STATUS,RP0		; Use register bank 1
	clrf TRISD		; Set PortD as output
	bcf STATUS,RP0		; Use register bank 0

	bsf PORTA,1		; Ensure RD line is high

	movf USBDataOut,w	; Transfer output data into W
	movwf PORTD		; Output Data to port D
	bcf PORTA,0		; Take WR line low
	bsf PORTA,0		; Take WR line high again

	movlw h'ff'
	bsf STATUS,RP0		; Use register bank 1
	movwf TRISD		; Set PortD as input
	bcf STATUS,RP0		; Use register bank 0

	return





SlowAtoDSetup
	clrwdt
	
	bcf STATUS,RP1		;} 
	bcf STATUS,RP0		;} Use register bank 0

	call SendStart

	bcf AtoDAddress,0	; Clear write bit for address data
	movf AtoDAddress,w	;}
	call SendDat		;} Send address data to AtoD

	movlw 1			;} Set Address Pointer Register to 1 (Config register)
	call SendDat		;} 

	movf AtoDChannel,w	;} Send config register information to AtoD
	call SendDat		;} Bits 5-7 are channel No (1 to 4) bits 0-4 are 0

	Call SendStop

	clrwdt

	nop
	nop
	nop
	nop

	call SendStart

	bcf AtoDAddress,0	; Clear write bit for address data
	movf AtoDAddress,w	;}
	call SendDat		;} Send address data to AtoD

	movlw 4			;} Set Address Pointer Register to 4 (ADC read register)
	call SendDat		;} 

	Call SendStop

	Return



SlowAtoDRead
	clrwdt
	
	bcf STATUS,RP1		;} 
	bcf STATUS,RP0		;} Use register bank 0

	call SendStart

	bsf AtoDAddress,0	; Set read bit for address data
	movf AtoDAddress,w	;}
	call SendDat		;} Send address data to AtoD

	movf AtoDChannel,w	;} Send config register to AtoD
	call SendDat		;} Bits 5-7 are channel No (1 to 4) bits 0-4 are 0

	Call GetData		;}
	movwf AtoDHiData	;} Get Hi byte of data from AtoD
	movwf Temp
	call SendAck

	Call GetData		;}
	movwf AtoDLoData	;} Get Lo byte of data from AtoD

	Call SendStop

	;The data comes in with the MSB in bit 7 of AtoDHiData and the LSB in bit 6 of AtoDLoData

	movlw b'11000000'
	andwf AtoDLoData,1
	andwf AtoDHiData,1

	bcf STATUS,C		; Ensure carry flag is cleared for subsequent rotate instructions

	swapf AtoDHiData,1	;}
	rrf AtoDHiData,1	;} Move bits 7 & 6 to bits 1 & 0
	rrf AtoDHiData,1	;}

	swapf AtoDLoData,1	;}
	rrf AtoDLoData,1	;} Move bits 7 & 6 to bits 1 & 0
	rrf AtoDLoData,1	;}

	rlf Temp,1		;} Move bits 5 to 0 of Temp to bits 7 to 2 of W
	bcf STATUS,C		;} (Ensure carry flag is cleared for following rotate instructions)
	rlf Temp,0		;}

	andwf AtoDLoData,1	; AND W register (bits 7 to 2 of result) with AtoDLoData (bits 1 & 0 of result)

	Return





SlowDtoAOut	
	clrwdt
	
	bcf STATUS,RP1		;} 
	bcf STATUS,RP0		;} Use register bank 0

	call SendStart

	bcf DtoAAddress,0	; Clear write bit for address data
	movf DtoAAddress,w	;}
	call SendDat		;} Send address data to DtoA

	movf DtoAHiData,w	;}
	call SendDat		;} Send high data to DtoA

	movf DtoALoData,w	;}
	call SendDat		;} Send low data to DtoA

	Call SendStop

	clrwdt

	nop
	nop
	nop
	nop

	Call SendStart

	bsf DtoAAddress,0	; Set read bit for address data (will send data back)
	movf DtoAAddress,w	;
	call SendDat		; Send address data to DtoA

	call GetData		; Get high data back from DtoA
	andlw b'00001111'	; Mask off bits 6 & 7 which are not used
	subwf DtoAHiData,0	; Subtract DtoAHiData value from high value returned from DtoA
	btfss STATUS,Z		;}
	bsf TxError,0		;} If result is not zero then set TxError
	call SendAck

	call GetData		; Get low data back from DtoA
	subwf DtoALoData,0	; Subtract DtoALoData value from low value returned from DtoA
	btfss STATUS,Z		;}
	bsf TxError,0		;} If result is not zero then set TxError

	Call SendStop

	nop
	nop
	nop
	nop

	btfsc TxError,0		;}
	goto TranErr		;} If error occured then clear error & resend data

	return


TranErr
	bcf TxError,0		; Clear TxError
	goto SlowDtoAOut	; Resend data



SendStart	
	bsf STATUS,RP0		; Use register bank 1

	bcf SSPCON2,SEN		; Send start signal
	bsf SSPCON2,SEN		; Send start signal

	bcf STATUS,RP0		; Use register bank 0

	return



SendStop	
	bsf STATUS,RP0		; Use register bank 1

	bsf SSPCON2,PEN		; Send stop signal

	bcf STATUS,RP0		; Use register bank 0

	return



SendDat	
	bcf STATUS,RP0		; Use register bank 0

	movwf SSPBUF		; Transfer output byte to working register

	bsf STATUS,RP0		; Use register bank 1

LoopSD1	btfsc SSPSTAT,BF	;} Wait for transmission (BF is clear)
	goto LoopSD1		;}

LoopSD2	btfsc SSPCON2,ACKSTAT	;} Wait for acknowledge (ACKSTAT is clear)
	goto LoopSD2		;}

	bcf STATUS,RP0		; Use register bank 0

	return



GetData
	bsf STATUS,RP0		; Use register bank 1

	bsf SSPCON2,RCEN	; Enable receive mode

LoopGD1	btfss SSPSTAT,BF	;} Wait for byte to be received (BF is set)
	goto LoopGD1		;}

	bcf STATUS,RP0		; Use register bank 0

	movf SSPBUF,w		; Transfer received byte to working register

	return


SendAck
	bsf STATUS,RP0		; Use register bank 1

	bcf SSPCON2,ACKDT	; Set acknowledge bit state to send
	bsf SSPCON2,ACKEN	; Send acknowledge 
LoopSA1	btfsc SSPCON2,ACKEN	; Is acknowledge complete? 
	goto LoopSA1

	bcf STATUS,RP0		; Use register bank 0

	return









ISRoutine

	retfie			; Return and enable interupts	



	END
