/* mytcpServer.c */
/* Gopal Narayanan */
/* Dec. 2003 */
/* Simple serer that waits for client connection
 * receives data and then sends it back
 * using TCP sockets */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h> /* close */
#include <errno.h>
#include <signal.h>

#define SUCCESS 0
#define ERROR   1

#define END_LINE 0x0A
#define SERVER_PORT 5700
#define MAX_MSG 1024

/* function readline */
/* int read_line();*/


int main (int argc, char *argv[]) {
  
  int sd, newSd, cliLen;

  struct sockaddr_in cliAddr, servAddr;
  char line[MAX_MSG];
  int i, cnt_r, cnt_w;
  struct linger li;

  /* create socket */
  sd = socket(AF_INET, SOCK_STREAM, 0);
   if(sd<0) {
    perror("cannot open socket ");
    exit(1);
  }
  
  /* bind server port */
  servAddr.sin_family = AF_INET;
  servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servAddr.sin_port = htons(SERVER_PORT);
  
  if(bind(sd, (struct sockaddr *) &servAddr, sizeof(servAddr))<0) {
    perror("cannot bind port ");
    exit(1);
  }

  if (listen(sd,5) < 0) {
    perror("listen: ");
    exit(1);
  }

  /* Ignore child process termination.   */

  signal (SIGCHLD, SIG_IGN);
  
  /*  Place the server in an infinite loop, waiting
      on connection requests to come from clients.
      In practice, there would need to be a clean
      way to terminate this process, but for now it
      will simply stay resident until terminated by
      the starting terminal or the super-user.        */
  
  while(1) {

    printf("%s: waiting for data on port TCP %u\n",argv[0],SERVER_PORT);

    cliLen = sizeof(cliAddr);
    newSd = accept(sd, (struct sockaddr *) &cliAddr, &cliLen);

    if(newSd<0) {
      perror("cannot accept connection ");
      return ERROR;
    }
    
    li.l_onoff = 0;
    li.l_linger = 300;
    
    if ((setsockopt(newSd, SOL_SOCKET, SO_LINGER,
		    (char *)&li, sizeof (struct linger))) < 0) {
      perror("SO_LINGER: ");
      exit(1);
    }
    /*    memset(line,0x0,MAX_MSG);*/

    /* Create child server process.  Parent does no
       further processing -- it loops back to wait
       for another connection request.                */

    /*     printf("Socket address in server %d is %x, %s\n",
	   getpid(), cliAddr.sa_data, cliAddr.sa_data); */

    if (fork() == 0) {  /* child process */
      close (sd);  /* child does not need it  */

      /* actually read the data */
      do {
	memset (line, 0, sizeof(line));
	
	if ((cnt_r = read(newSd, line, sizeof(line))) < 0) {
	  perror("read: ");
	  close(newSd);
	  exit(1);
	} else 
	  if (cnt_r == 0) {
	    
	    printf ("Server with pid %d reached EOF with message of length %d: %s\n",
		    getpid(), cnt_r, line);
	    close(newSd);
	    continue;  /* break out of loop */
	  } else {
      /*      strcpy (line, "Message to client");
	      strcat (line, */
	    printf ("Server with pid %d got from %s:%u message of length %d: %s\n",
		    getpid(), inet_ntoa(cliAddr.sin_addr), 
		    ntohs(cliAddr.sin_port), cnt_r, line);
	    cnt_w = write(newSd, line, strlen(line));
	    if (cnt_w <0) {
	      perror("write: ");
	      exit(1);
	    }

      /*      printf("Socket address in server %d is %x, %s\n",
	      getpid(), cliAddr.sa_data, cliAddr.sa_data);*/

	  }
      } while (cnt_r != 0);  /* do loop condition*/
      /*  . . . . .  */
      close (newSd); /* close prior to exiting  */
      printf("Exiting child process %d\n", getpid());
      exit(0);
    }   /* closing bracket for if (fork() ... )  */
    else {
      close(newSd);
    }

    
  } /* while (1) */

}


