/* this is a part of a function that enables interrupt handling */

if(ComMod != 0 ){						// COMMAND MODULE
		
	status = viPrintf(ComMod,"STAT:OPER:ENAB 256 \n");	// enable interrupt event on bit8
	if( status < VI_SUCCESS )return(99);			// error code 99
	viPrintf(ComMod,"*SRE 128 \n");				// enable SRQ from bit7
	viPrintf(ComMod,"DIAG:INT:PRI1 1 \n");			// priority 1 to interrupt line 1
	viPrintf(ComMod,"DIAG:INT:SET1 ON \n");			// enable IRQ 1 to be serviced
	viPrintf(ComMod,"DIAG:INT:ACT ON \n");			// interrupt acknowledgment ON

	status = viEnableEvent(ComMod,VI_EVENT_SERVICE_REQ,VI_QUEUE,VI_NULL);

/*	Command Module forces a SRQ if an interrupt occurs, because GPIB interface
	can only handle	SRQ events. 
	Note: Direct interrupt handling via GPIB or GPIB-VXI is not available !!!	*/

if(FiWi != 0){     						// FIRE WIRE CONTROLLER
	status = viEnableEvent(FiWi,VI_EVENT_VXI_SIGP,VI_QUEUE,VI_NULL); 
	if( status < VI_SUCCESS )return(status);		// "event not supported by the resource"
}

/* this is a part of a function that waits for an interrupt */

if(ComMod != 0 ){
	status = viWaitOnEvent(ComMod,VI_EVENT_SERVICE_REQ,timeout,&event_type,&event);
	if(status<VI_SUCCESS){
		viStatusDesc(event,status,(ViPString)instrDesc);
		sprintf(buf,"%s",instrDesc);
		return(buf);
	}
	status = viPrintf(ComMod,"DIAG:INT:RESP? \n");
	status = viScanf(ComMod,"%d",&statID);
	statID = statID & 254;	
	// get DEVICE ID from STATUS/ID word should be 232(logical address)
	if(statID==232){					// (re)enable interrupt
		status = viPrintf(ComMod,"DIAG:INT:ACT ON \n");	// interrupt acknowledgment ON
		status = viPrintf(ComMod,"*CLS \n");		// clear status byte
	}
}