#include <windows.h>
#include "intfinstr.h"


typedef INSTRTYPE * (__stdcall *FINDIPPBPROC)(HANDLE, int *, int *, BOOL, int *);
typedef int (__stdcall *FINDPPROC)(void *);
FINDIPPBPROC findAllInstr = NULL;
FINDPPROC freeHeapMem = NULL;

HINSTANCE hDll;


/*************************************************
**
** Load the specified (instfinder.dll) DLL library
*/
int loadlib(char *libraryname)
{	
	hDll = LoadLibrary(libraryname);

	if (hDll > 0) 
	{
		freeHeapMem = (FINDPPROC)GetProcAddress(hDll, "freeHeapMem");
		findAllInstr = (FINDIPPBPROC)GetProcAddress(hDll, "findAllInstr");
	}
	return((hDll == NULL) ? -1 : 0);

}


/************************************************************
**
** Scan for active devices and return array of live addresses
*/
int getdevicelist(long *addresses)
{
	INSTRTYPE *instrumentList;
	HANDLE handle = 0;
	int numInterfaces = 0;
	int numInstruments = 0;
	int status = 0;
	int i;


	if (!hDll)
	{
		return(-1);
	}
	
	instrumentList = findAllInstr(handle, &numInterfaces, &numInstruments, 
							      DOALLOVER, &status);

	for (i=0; i<numInstruments; i++)
	{
		/*
		** Addresses are XXYY[ZZ],
		** where:
		**			XX = select code (1 or 2 digits)
		**			YY = primary address
		**			ZZ = secondary address
		**
		**	Calculated addresses are in integer format
		*/
		addresses[i] = (instrumentList[i].selCode*100) +
					    instrumentList[i].primAddr;
		addresses[i] = (instrumentList[i].secAddr < 0) ? addresses[i] : 
			            (addresses[i]*100)+instrumentList[i].secAddr;
	}
	
	if (freeHeapMem != NULL) 
	{
		freeHeapMem((void *)instrumentList);
	}


	return(numInstruments);
}
