/************************************************************************
*                                                                       *
*	 FILE: 		   delay.cpp                                                *
*   AUTHOR:			Mitchell J. Weitz                                       *
*   DATE:   		04/04/07                                                *
*	 REVISION:		1.01                                                    *
*                                                                       *
/************************************************************************
*/

#include "delay.h"


void MicroDelay (long MicroSecs)
{
  asm {
		mov cx, word ptr [MicroSecs+2]
    mov dx, word ptr [MicroSecs]
    mov ah, 0x86
		int 0x15
  }
}

void MilliDelay (long MilliSecs)
{
  MicroDelay (MilliSecs * 1000);
}

// each count is worth 0.41905 uSec

void program_8254(void)
{
	asm {
		pushf // save current inetrrupt status

		cli // no ints while we read the 8254
		mov al,0xb4 // command to latch counter for counter 2 for mode 2, binary
		out 0x43,al // tell the 8254 to latch the count
		db 0x24, 0xf0 // jmp $+2, this slow I/O on fast processors

		mov al,0xff //     write LSB     going for 65535
		out 0x42,al // tell the 8254 to latch the count
		db 0x24, 0xf0 // jmp $+2, this slow I/O on fast processors

		mov al,0xff //  write MSB
		out 0x42,al // tell the 8254 to latch the count
		db 0x24, 0xf0 // jmp $+2, this slow I/O on fast processors

		mov al, 0x01 // enable counting of counter 2, but keep the speaker off
		out 0x61,al // tell the 8254 to latch the count
		db 0x24, 0xf0 // jmp $+2, this slow I/O on fast processors

		popf // return saved interrupt status
	}
}

UINT16 read_8254_count (void)
{
	asm {
		pushf // save current inetrrupt status

		cli // no ints while we read the 8254
		mov al,0x80 // command to latch counter for counter 2
		out 0x43,al // tell the 8254 to latch the count
		db 0x24, 0xf0 // jmp $+2, this slow I/O on fast processors

		in al,0x42 // read LSB of 8254's count
		mov ah,al // temp save
		db 0x24, 0xf0 // jmp $+2

		in al,0x42 // read MSB of count
		xchg al,ah // get right order of MSB/LSB

		popf // return saved interrupt status
	}
	return _AX;
}

void delay_8254(unsigned int milliseconds)
{
	unsigned long delay_counts = milliseconds * COUNT_TIME;
	UINT16 first_counts, last_counts;
	unsigned long total_counts = 0;
	static int was_here_once = 0;

	if (!was_here_once)
	{
		program_8254();
		was_here_once = 1;
	}

	UINT8 i = 0;
	first_counts = read_8254_count();

	while (total_counts < delay_counts)
	{
//		first_counts = read_8254_count();
		while ( ++i != 0 ) // loop until zero (256 times), a do nothing wait loop
		;
		last_counts = read_8254_count();
		total_counts += first_counts - last_counts; // 8254 always counts down
		first_counts = last_counts;
//		printf(" first_counts = %x, last_counts = %x\n", first_counts, last_counts);
	}
}


