#ifdef __cplusplus
   extern "C" {
#endif
/*************************************************************************
 *
 *    NI-DAQ Windows - Function Prototypes
 *    Copyright    (C) National Instruments 1994.
 *
 *************************************************************************/
/*	This file was created from the file WDAQ_C.H provided by National Instruments
	with NI-DAQ for Windows.  This file has been modified from the original as
	follows in order to use it successfully with HPVEE.
	
	-	On each of the function prototypes, the return data type was changed from
		"extern int FAR PASCAL" to "short "
	-	All instances of the keyword "far" were changed to "_far"
	-	All instances of "unsigned long" were changed to "long" and all instances
		of "unsigned int" were changed to "int".  All cases where this was done
		have been indicated.  Care should be taken when using these functions because
		the function prototype only has been changed, not the function itself, which
		is still looking for the original data type.  Keep in mind the following:
		-	if a data type has been changed from "unsigned long" to "long", then the
			function will be looking for an integer in the range from 0 to 
			4,294,967,295.  The data type you will be sending to this function is "long"
			which is a signed integer in the range from -2,147,483,648 to 2,147,483,647.
			Therefore, you should not have any problem as long as you only send positive 
			numbers in the range from 0 to 2,147,483,647.  In most cases, this should be
			okay.
		-	In the cases where the data type has been changed from "unsigned int" to 
			"int", the same type of situation arises.  In this case, restrict the 
			range of numbers sent to the function to 0 to 32,767.

		-	ALL 'INT' DECLARATION WERE CONVERTED TO 'SHORT' DECLARATIONS.

	Dennis L. Stanley
	Wilcox Electric, Inc.
	1/16/96
*/
short A2000_Calibrate (short device, short saveNewValues, short
 calMethod, short channel, double extRefVoltage);
short A2000_Config (short device, short sampClkSrc, short sampClkDrv,
 short dither);
short  A2150_Calibrate (short device, short ref0, short ref1);
short  AI_Check (short device, short *status, short *value);
short  AI_Clear (short device);
short  AI_Configure (short device, short chan, short inputMode,
 short inputRange, short polarity, short driveAIS);
short  AI_Mux_Config (short device, short numMuxBrds);
short  AI_Read (short device, short chan, short gain, short  *value);
short AI_Read_Scan (short device, short *reading);
short AI_Setup (short device, short chan, short gain);
short AI_VRead (short device, short chan, short gain, double
 _far *volts);
short AI_VRead_Scan (short device, double *reading);
short AI_VScale (short device, short chan, short gain, double
 gainAdjust, double offset, short reading, double _far *voltage);
 
// cnt, bufSize and *alignIndex have been changed from "unsigned long" to "long" 
short Align_DMA_Buffer (short device, short resource, short _far
 buffer[], long cnt, long bufSize, long _far *alignIndex);

short AO_Calibrate (short device, short operation, short EEPROMloc);

// paramID and paramValue have been changed from "unsigned long" to "long"
short AO_Change_Parameter (short device, short channel, 
 long paramID, long paramValue);
 
short AO_Configure (short device, short chan, short outputPolarity,
 short shortOrExtRef, double refVoltage, short updateMode);
short AO_Update (short device);
short AO_VScale (short device, short chan, double voltage,
 short *value);
short AO_VWrite (short device, short chan, double voltage);
short AO_Write (short device, short chan, short value);
short Calibrate_1200 (short device, short calOP, short saveNewCal,
 short EEPROMloc, short calRefChan, short grndRefChan, short DAC0chan, short DAC1chan,
 double calRefVolts, double gain);

// calOP and setofCalConst have been changed from "unsigned long" to "long"  

short Calibrate_E_Series (short device, long calOP,
 long setofCalConst, double calRefVolts);

// callbackAddr has been changed from "unsigned long" to "long"
short Config_Alarm_Deadband (short device, short mode, char
 _far chanStr[], double trigLvl, double deadbandWidth, short handle, short alarmOnMsg,
 short alarmOffMsg, long callbackAddr);

// skipCnt, preTrigScans, postTrigScans and callBackAddr have been changed from
// "unsigned long" to "long"
short Config_ATrig_Event_Message (short device, short mode, char _far chanStr[],
 double trigLvl, double winSize, short trigSlope, long skipCnt, long preTrigScans, 
 long postTrigScans, short handle, short msg, long callBackAddr);

// skipCnt, preTrigScans, postTrigScans and callBackAddr have been changed from
// "unsigned long" to "long"
short Config_DAQ_Event_Message (short device, short mode, char _far chanStr[], 
short DAQEvent, long trigVal0, long trigVal1, long skipCnt, long preTrigScans, 
long postTrigScans, short handle, short msg, long callBackAddr);

// onOrOff and mode have been changed from "unsigned long" to "long" 
short Configure_HW_Analog_Trigger (short device, 
 long onOrOff, long lowValue, long highValue, long mode, long trigSource);

short CTR_Config (short device, short ctr, short edgeMode, short
 gateMode, short outType, short outPolarity);
short CTR_EvCount (short device, short ctr, short timebase, short
 cont);

// *counts has been changed from "unsigned short" to "short"
short CTR_EvRead (short device, short ctr, short _far *overflow,
 short _far *counts);

short CTR_FOUT_Config (short device, short FOUT, short mode,
 short timebase, short division);
short CTR_Period (short device, short ctr, short timebase);

// delay and pulseWidth have been changed from "unsigned short" to "short"
short CTR_Pulse (short device, short ctr, short timebase, 
 short delay, short pulseWidth);

// *period1 and *period2 have been changed from "unsigned short" to "short"
short CTR_Rate (double freq, double duty, short _far *timebase,
 short _far *period1, short _far *period2);

short CTR_Reset (short device, short ctr, short outState);
short CTR_Restart (short device, short ctr);
short CTR_Simul_Op (short device, short numCtrs, short _far ctrList[],
 short mode);

// period1 and period2 have been changed from "unsigned short" to "short"
short CTR_Square (short device, short ctr, short timebase, 
 short period1, short period2);

short CTR_State (short device, short ctr, short _far *outState);
short CTR_Stop (short device, short ctr);

// *retrieved has been changed from "unsigned long" to "long"
short DAQ_Check (short device, short _far *status, 
 long _far *retrieved);

short DAQ_Clear (short device);
short DAQ_Config (short device, short startTrig, short extConv);
short DAQ_DB_Config (short device, short dbMode);
short DAQ_DB_HalfReady (short device, short _far *halfReady,
 short _far *status);

// *ptsTfr has been changed from "unsigned long" to "long"
short DAQ_DB_StrTransfer (short device, char _far buffer[],
 long _far *ptsTfr, short _far *status);

// *ptsTfr has been changed from "unsigned long" to "long"
short DAQ_DB_Transfer (short device, short _far hbuffer[], 
 long _far *ptsTfr, short _far *status);

// monitorCnt and *newestIndex have been changed from "unsigned long" to "long"
short DAQ_Monitor (short device, short chan, short seq, 
 long monitorCnt, short _far monitorBuf[], long _far *newestIndex,
 short _far *status);

// cnt has been changed from "unsigned long" to "long"
short DAQ_Op (short device, short chan, short gain, short _far buffer[],
 long cnt, double sampleRate);

// *sampleshort has been changed from "unsigned short" to "short"
short DAQ_Rate (double rate, short units, short _far *timebase,
 short _far *sampleshort);

// cnt has been changed from "unsigned long" to "long" and sampshort has been
// changed from "unsigned short" to "short"
short DAQ_Start (short device, short chan, short gain, short
 *buffer, long cnt, short timebase, short sampshort);

// preTrigCnt has been changed from "unsigned long" to "long"
short DAQ_StopTrigger_Config (short device, short preTrig,
 long preTrigCnt);

// cnt has been changed from "unsigned long" to "long"
short DAQ_to_Disk (short device, short chan, short gain, char
*fileName, long cnt, double sampleRate, short concat);

// cnt has been changed from "unsigned long" to "long"
short DAQ_VScale (short device, short chan, short gain, double
 gainAdjust, double offset, long cnt, short *binArray, double
 *voltArray);

// *remaining has been changed from "unsigned long" to "long"
short DIG_Block_Check (short device, short grp, long
  *remaining);                                     
 
short DIG_Block_Clear (short device, short grp);

// cnt has been changed from "unsigned long" to "long"
short DIG_Block_In (short device, short grp, short _far buffer[],
 long cnt);

// cnt has been changed from "unsigned long" to "long"
short DIG_Block_Out (short device, short grp, short _far buffer[],
 long cnt);

// shorterval has been changed from "unsigned short" to "short"
short DIG_Block_PG_Config (short device, short grp, short PGmode,
 short reqSource, short timebase, short shorterval, short externalGate);

short DIG_DB_Config (short device, short grp, short DBMode, short
 oldDataStop, short partialTransfer);
short  DIG_DB_HalfReady (short device, short grp, short _far *halfReady);

// ptsTfr has been changed from "unsigned long" to "long"
short  DIG_DB_StrTransfer (short device, short grp, char _far
 halfBuffer[], long ptsTfr);

// ptsTfr has been changed from "unsigned long" to "long"
short  DIG_DB_Transfer (short device, short grp, short _far halfBuffer[],
 long ptsTfr);
 
short  DIG_Grp_Config (short device, short grp, short grpsize,
 short port, short direction);
short  DIG_Grp_Mode (short device, short grp, short sigType, short
 edge, short reqpol, short ackpol, short settleTime);
short  DIG_Grp_Status (short device, short grp, short _far *status);
short  DIG_In_Grp (short device, short grp, short _far *grp_pat);
short  DIG_In_Line (short device, short port, short linenum, short
 _far *status);
short  DIG_In_Port (short device, short port, short _far *pattern);
short  DIG_Line_Config (short device, short port, short linenum,
 short direction);
short  DIG_Out_Grp (short device, short grp, short grp_pat);
short  DIG_Out_Line (short device, short port, short linenum,
 short status);
short  DIG_Out_Port (short device, short port, short pattern);
short  DIG_Prt_Config (short device, short port, short latch_mode,
 short direction);
short  DIG_Prt_Status (short device, short port, short _far *status);
short  DIG_SCAN_Setup (short device, short grp, short numPorts,
 short _far portList[], short direction);
short  DSP2200_Calibrate (short device, short mode, short ADCref);
short  DSP2200_Config (short device, short aitranslate, short
 aotranslate, short demux);

// infoType and *infoVal have been changed from "unsigned long" to "long" 
short  Get_DAQ_Device_Info (short device, long infoType,
 long _far *infoVal);

// timeOut has been changed from "unsigned long" to "long"
short  Get_DAQ_Event (long timeOut, short _far *handle,
 short _far *msg, short _far *wParam, long _far *lParam);

// *version has been changed from "unsigned long" to "long" 
short  Get_NI_DAQ_Version (long _far *version);

// gpCounterNumber, paramID and paramValue have been changed from
// "unsigned long" to "long"
short  GPCTR_Change_Parameter (short device, long
 gpCounterNumber, long paramID, long paramValue);

// gpCounterNumber, reserved, numPoshorts and buffer[] have been changed from
// "unsigned long" to "long"
short  GPCTR_Config_Buffer (short device, long gpCounterNumber,
 long reserved, long numPoshorts, long _far buffer[]);

// gpCounterNumber and action have been changed from "unsigned long" to "long"
short  GPCTR_Control (short device, long gpCounterNumber,
 long action);

// gpCounterNumber application have been changed from "unsigned long" to "long" 
short  GPCTR_Set_Application (short device, long
 gpCounterNumber, long application);

// gpCounterNumber, watchID and *watchValue have been changed from
// "unsigned long" to "long"
short  GPCTR_Watch (short device, long gpCounterNumber,
 long watchID, long _far *watchValue);

// *count has been changed from "unsigned short" to "short"
short  ICTR_Read (short device, short counter, short _far *count);

short  ICTR_Reset (short device, short counter, short state);

// cnt has been changed from "unsigned short" to "short"
short  ICTR_Setup (short device, short counter, short mode, 
 short cnt, short binBCD);

short  Init_DA_Brds (short device, short _far *brdCode);

// *retrieved has been changed from "unsigned short" to "short"
short  Lab_ISCAN_Check (short device, short _far *status, 
 long _far *retrieved, short _far finalScanOrder[]);

// cnt has been changed from "unsigned long" to "long" 
short  Lab_ISCAN_Op (short device, short numChans, short gain,
 short _far buffer[], long cnt, double sampleRate, double scanRate,
 short _far finalScanOrder[]);

// cnt has been changed from "unsigned long" to "long"
// sampleshort and scanshort have been changed from "unsigned short" to "short" 
short  Lab_ISCAN_Start (short device, short numChans, short gain,
 short _far buffer[], long cnt, short timebase, short sampleshort, short scanshort);

// cnt has been changed from "unsigned long" to "long" 
short  Lab_ISCAN_to_Disk (short device, short numChans, short
 gain, char _far fileName[], long cnt, double sampleRate, double
 scanRate, short concat);
 
short  LPM16_Calibrate (short device);
short  MAI_Arm (short device, short onOff);
short  MAI_Clear (short device);
short  MAI_Coupling (short device, short numChans, short _far coupling[]);
short  MAI_Read (short device, short _far reading[]);

// numScans has been changed from "unsigned long" to "long"
short  MAI_Scale (short device, long numScans, short
 _far values[], double _far volts[]);

// muxshorterval has been changed from "unsigned short" to "short" 
short  MAI_Setup (short device, short numChans, short _far chanList[],
 short _far gainList[], short muxshorterval, short timebase, short muxMode);
 
short  Master_Slave_Config (short device, short numSlaves, short
 _far saveList[]);

// *framesDone and *scansDone have been changed from "unsigned long" to "long" 
short  MDAQ_Check (short device, short fullCheck, short _far *acqDone,
 long _far *framesDone, long _far *scansDone);

short  MDAQ_Clear (short device);

// numToGet, startFrame, startScan, *numGotten, *lastFrame and *lastScan have
// been changed from "unsigned long" to "long"
short  MDAQ_Get (short device, short scansOrFrames, short getOrTap,
 long numToGet, long startFrame, long startScan, long timeout, short _far getBuffer[], 
 long _far *numGotten, long _far *lastFrame, long _far *lastScan, short _far *acqDone);

// shorterval has been changed from "unsigned short" to "short"
short  MDAQ_ScanRate (short device, short shorterval,
 short timebase);

// bufferSize, preTrigScans and postTrigScans have been changed from "unsigned long" to "long"
short  MDAQ_Setup (short device, long bufferSize, short scansOrFrames, long preTrigScans, 
long postTrigScans, short _far acqBuffer[]);

// numTriggers has been changed from "unsigned long" to "long"
short  MDAQ_Start (short device, long numTriggers);

short  MDAQ_Stop (short device);

// numToGet, startFrame, startScan, *numGotten, *lastFrame and *lastScan have
// been changed from "unsigned long" to "long"
short  MDAQ_StrGet (short device, short scansOrFrames, short getOrTap,
 long numToGet, long startFrame, long startScan, long timeout, char _far getBuffer[], 
 long _far *numGotten, long _far *lastFrame, long _far *lastScan, short _far *acqDone);

// postTrigDelay has been changed from "unsigned short" to "short"
short  MDAQ_Trig_Delay (short device, short postTrigDelay, short timebase);

short  MDAQ_Trig_Select (short device, short dTrigMode, short
 dEdge, short aTrigMode, short aSlope, short aLevel, short aTrigChan);
short  MIO_Calibrate (short device, short calOP, short saveNewCal,
 short EEPROMloc, short CalRefChan, short DAC0Chan, short DAC1Chan, double calRefVolts,
 short refLoc);
short  MIO_Config (short device, short dither, short useAMUX);

// numElements has been changed from "unsigned long" to "long"
short  NI_DAQ_Mem_Alloc (short _far *handle, short elementSize,
 long numElements, short memType, short memSource);

// *numElements has been changed from "unsigned long" to "long"
short  NI_DAQ_Mem_Attributes (short handle, short _far *elementSize,
 long _far *numElements, short _far *lockCnt, short _far *memType, short _far *memSource);

// startIndex and numEl has been changed from "unsigned long" to "long"
short  NI_DAQ_Mem_Copy (short handle, short _far buffer[], 
 long startIndex, long numEl, short CopyDirection);

short  NI_DAQ_Mem_Free (short handle);

// *address has been changed from "unsigned long" to "long"
short  NI_DAQ_Mem_Lock (short handle, long _far *address);

short  NI_DAQ_Mem_Unlock (short handle);

// timeOut has been changed from "unsigned long" to "long"
short  Peek_DAQ_Event (long timeOut, short _far *handle,
 short _far *msg, short _far *wParam, long _far *lParam);

// *registerValue has been changed from "unsigned long" to "long"
short  REG_Level_Read (short device, short registerIndex, long _far *registerValue);

// bitsAffected, bitSettings and *registerValue have been changed from 
// "unsigned long" to "long"
short  REG_Level_Write (short device, short registerIndex, 
 long bitsAffected, long bitSettings, long _far *registerValue);

short  RTSI_Clear (short device);
short  RTSI_Clock (short device, short connect, short direction);
short  RTSI_Conn (short device, short brdSignal, short busLine,
 short direction);
short  RTSI_DisConn (short device, short brdSignal, short busLine);
short  SC_2040_Config (short device, short channel, short sc2040Gain);

// cnt has been changed from "unsigned long" to "long"
short  SCAN_Demux (short _far buffer[], long cnt,
 short numChans, short muxMode);

// cnt has been changed from "unsigned long" to "long"
short  SCAN_Op (short device, short numChans, short _far chans[],
 short _far gains[], short _far buffer[], long cnt, double sampleRate, double scanRate);

// bufferSize and samplesPerChanVector[] have been changed from "unsigned long" to "long"
short  SCAN_Sequence_Demux (short numChans, short _far chanVector[],
 long bufferSize, short _far buffer[], short samplesPerSequence, short
 _far scanSequenceVector[], long samplesPerChanVector[]);

short  SCAN_Sequence_Retrieve (short device, short samplesPerSequence,
 short _far scanSequenceVector[]);
short  SCAN_Sequence_Setup (short device, short numChans, short
 _far chanVector[], short _far gainVector[], short _far scanRateDivVector[], short
 _far *scansPerSequence, short _far *samplesPerSequence);
short SCAN_Setup (short device, short num_chans, short *chans,
 short _far gains[]);

// cnt has been changed from "unsigned long" to "long"
// si1 and si2 have been changed from "unsigned short" to "short"
short  SCAN_Start (short device, short _far buffer[], 
 long cnt, short tb1, short si1, short tb2, short si2);

// cnt has been changed from "unsigned long" to "long"
short  SCAN_to_Disk (short device, short numChans, short _far chans[],
 short _far gains[], char _far fileName[], long cnt, double sampleRate,
 double scanRate, short concat);

short  SCXI_AO_Write (short chassisID, short module, short DACchannel,
 short rangeCode, short opCode, double voltCurrentData, short binaryDat, short _far
 *binaryWritten);
short  SCXI_Cal_Constants (short chassisID, short module, short
 SCXIchannel, short operation, short calArea, short rangeCode, double SCXIgain,
 short DAQdevice, short DAQchannel, short DAQgain, double TBgain, double volt1,
 double binary1, double volt2, double binary2, double _far *binEEprom1, double
 _far *binEEprom2);
short  SCXI_Calibrate_Setup (short chassisID, short module,
 short calOp);
short  SCXI_Change_Chan (short chassisID, short module, short
 chan);

// cutoffDivDown and outClkDivDown have been changed from "unsigned short" to "short"
short  SCXI_Configure_Filter (short chassisID, short module, short channel, 
 short filterMode, double freq, short cutoffDivDown, short outClkDivDown, double _far *actFreq);

short  SCXI_Get_Chassis_Info (short chassisID, short _far *chassisType,
 short _far *address, short _far *commMode, short _far *commPath, short _far *numSlots);
short  SCXI_Get_Module_Info (short chassisID, short device,
 long _far *modulePresent, short _far *opMode, short _far *DAQdevice);
short  SCXI_Get_State (short chassisID, short module, short port,
 short channel, long _far *data);
short  SCXI_Get_Status (short chassisID, short module, short wait,
 long _far *data);
short  SCXI_Load_Config (short chassisID);

// muxCtrVal has been changed from "unsigned short" to "short"
short  SCXI_MuxCtr_Setup (short device, short enable, short scanDiv, short muxCtrVal);

short  SCXI_Reset (short chassisID, short moduleSlot);

// numPoshorts has been changed from "unsigned long" to "long"
short  SCXI_Scale (short chassisID, short module, short SCXIchannel,
 double SCXIgain, double TBgain, short DAQdevice, short DAQchannel, short DAQgain,
 long numPoshorts, short _far binArray[], double _far voltArray[]);

short  SCXI_SCAN_Setup (short chassisID, short numModules, short
 _far modules[], short _far numChans[], short _far startChans[], short DAQdevice,
 short modeFlag);
short  SCXI_Set_Config (short chassisID, short chassisType,
 short address, short commMode, short slotOrCOMM, short numSlots, long _far moduleTypes[],
 short _far opModes[], short _far DAQdevices[]);
short  SCXI_Set_Gain (short chassisID, short module, short channel,
 double gain);
short  SCXI_Set_Input_Mode (short chassisID, short module, short
 inputMode);
short  SCXI_Set_State (short chassisID, short module, short port,
 short channel, long data);
short  SCXI_Single_Chan_Setup (short chassisID, short module,
 short chan, short DAQdevice);
short  SCXI_Track_Hold_Control (short chassisID, short module,
 short state, short DAQdevice);
short  SCXI_Track_Hold_Setup (short chassisID, short module,
 short mode, short source, short send, short holdCnt, short DAQdevice);

// signal, source and sourceSpec have been changed from "unsigned long" to "long"
short  Select_Signal (short device, long signal, long source, long sourceSpec);

// infoType and infoVal have been changed from "unsigned long" to "long"
short  Set_DAQ_Device_Info (short device, long infoType, long infoVal);

short  Timeout_Config (short device, long numTicks);

// windowSize has been changed from "unsigned short" to "short"
short  Trigger_Window_Config(short device, short mode, short windowSize);

short  WFM_Chan_Control (short device, short channel, short operation);

// *poshortsDone and *itersDone have been changed from "unsigned long" to "long"
short  WFM_Check (short device, short channel, short _far *status,
 long _far *poshortsDone, long _far *itersDone);

// updateshorterval has been changed from "unsigned long" to "long"
short  WFM_ClockRate (short device, short group, short whickClock,
 short timebase, long updateshorterval, short mode);

short  WFM_DB_Config (short device, short numChans, short _far
 chanVect[], short DBMode, short oldDataStop, short partialTransfer);
short  WFM_DB_HalfReady (short device, short numChans, short _far
 chanVect[], short _far *halfReady);

// count has been changed from "unsigned long" to "long"
short  WFM_DB_Transfer (short device, short numChans, short _far
 chanVect[], short _far buffer[], long count);

// count has been changed from "unsigned long" to "long"
short  WFM_DB_StrTransfer (short device, short numChans, short
 _far chanVect[], char _far strBuffer[], long count);

// startPts, endPts and iterations have been changed from "unsigned long" to "long"
short  WFM_from_Disk (short device, short numChans, short _far chanVect[],
 char _far fileName[], long startPts, long endPts, long iterations, double rate);

short  WFM_Group_Control (short device, short group, short operation);
short  WFM_Group_Setup (short device, short numChans, short _far
 chanVect[], short group);

// count and iterations have been changed from "unsigned long" to "long"
short  WFM_Load (short device, short numChans, short _far chanVect[],
 short _far buffer[], long count, long iterations, short mode);

// count and iterations have been changed from "unsigned long" to "long"
short  WFM_Op (short device, short numChans, short _far chanVect[],
 short _far buffer[], long count, long iterations, double rate);

// *updateshorterval has been changed from "unsigned long" to "long"
short  WFM_Rate (double rate, short units, short _far *timebase,
 long _far *updateshorterval);

// count has been changed from "unsigned long" to "long"
short  WFM_Scale (short device, short chan, long count,
 double gain, double _far voltArray[], short _far binArray[]);


/*************************************************************************
 *
 *    NI-DAQ Windows - Obsolete Function Prototypes
 *
 *************************************************************************/
/*
short  AI_Scale (short device, short gain, short value, double
 _far *voltage);
short  AI_Config (short device, short singOrDiff, short range,
 short uniOrBi);
short  AO_Config (short device, short chan, short outputPolarity,
 double refVoltage, short updateMode);
short  DAQ_Scale (short device, short gain, unsigned long cnt,
 short _far rawData[], double _far scaledData[]);
short  DAQ_Trigger_Config (short device, short preTrig, unsigned
 long preTrigCnt);
short  Get_DA_Brds_Info (short device, short _far *brdCode, short
 _far *baseAddr, short _far *irq1Lvl, short _far *irq2Lvl, short _far *irqTrigMode,
 short _far *dma1Lvl, short _far *dma2Lvl, short _far *daqMode);
short  Lab_SCAN_Check (short device, short _far *status, unsigned
 long _far *retrieved, short _far finalScanOrder[]);
short  Lab_SCAN_Op (short device, short numChans, short gain,
 short _far buffer[], unsigned long cnt, double sampleRate, short _far finalScanOrder[]);
short  Lab_SCAN_Start (short device, short numChans, short gain,
 short _far buffer[], unsigned long cnt, short timebase, unsigned short sampleshort);
short  Lab_SCAN_to_Disk (short device, short numChans, short gain,
 char _far fileName[], unsigned long cnt, double sampleRate, short concat);
short  MDAQ_Ext_Setup (short device, unsigned long bufferSize,
 short scansOrFrames, unsigned long preTrigScans, unsigned long postTrigScans,
 unsigned long extMemAddr);
short  MIO16_F5_Config (short device, short dither);
short  MIO16_F5_Calibrate (short device, short calOP, short saveNewCal,
 short EEPROMloc, short CalRefChan, short DAC0Chan, short DAC1Chan, double calRefVolts,
 short refLoc);
short  SCXI_1200_Calibrate (short device, short calOP, short saveNewCal,
 short EEPROMloc, short calRefChan, short grndRefChan, short DAC0chan, short DAC1chan,
 double calRefVolts, double gain);
short  SCXI_Set_Filter (short chassisID, short module, short channel,
 unsigned short extDivideDown, double freq, double _far *actFreq);
short  SCXI_Set_Module_Gain (short chassisID, short module,
 short gain);
short  Set_DAQ_Mode (short device, short newDaqMode);
short  WF_Check (short device, short chan, short _far *status,
 unsigned long _far *itersDone, unsigned long _far *nextPoshort);
short  WF_Clear (short device);
short  WF_DB_Config (short device, short chan, short DBmode, short
 oldDataStop);
short  WF_DB_StrTransfer (short device, short chan, char _far
 buffer[], unsigned long cnt);
short  WF_DB_Transfer (short device, short chan, short _far buffer[],
 unsigned long cnt);
short  WF_from_Disk (short device, short chan, char _far fileName[],
 unsigned long iters, double rate, unsigned long startPt, unsigned long
 endPt);
short  WF_Load (short device, short chan, short _far buffer[],
 unsigned long cnt, unsigned long iterations);
short  WF_Op (short device, short chan, short _far buf0[], short
 _far buf1[], unsigned long cnt0, unsigned long cnt1, unsigned long iters0,
 unsigned long iters1, double rate);
short  WF_Pause (short device);
short  WF_Rate (double rate, short units, short _far *timebase,
 unsigned short _far *updateshort);
short  WF_Resume (short device);
short  WF_Scale (short device, short chan, unsigned long cnt,
 double gain, double _far realArray[], short _far shortArray[]);
short  WF_Start (short device, short timebase, unsigned short
 updateshort);
short  WFM_UpdateRate (short device, short group, short timebase,
 unsigned long updateshorterval, short mode);



/*************************************************************************
 *
 *    NI-DAQ Windows - Compatibility with NI-DAQ DOS
 *
 *************************************************************************/

short  USE_E_Series (void);
short  USE_E_Series_AI (void);
short  USE_E_Series_AO (void);
short  USE_E_Series_DAQ (void);
short  USE_E_Series_DIO (void);
short  USE_E_Series_GPCTR (void);
short  USE_E_Series_GPCTR_Simple (void);
short  USE_E_Series_Misc (void);
short  USE_E_Series_WFM (void);


#ifdef __cplusplus
   }
#endif
