#pragma once 

// Public Function definitions - modify and use as thou wilt
#ifdef __cplusplus
extern "C" {
#endif

	// Returns value of register at registerAddr if succeeds
	// Failure codes: -1 (found PIC, but failed to communicate with it)
	//				  -2 (could not find PIC)
	//				  -3 (PIC communication successful, device communication failed)
	int __declspec( dllexport ) readi2c(int deviceAddr, int registerAddr);

	// Returns 0 if succeeds, same failure codes as readi2c
	int __declspec( dllexport ) writei2c(int deviceAddr, 
											int registerAddr,
											int data);

#ifdef __cplusplus
}
#endif



// #defines 
#define VID 0x04D8 // USB vendor ID - assigned by USB consortium to Microchip
#define PID 0xFEAA // USB product ID - assigned to ADI by Microchip