#ifndef __TH3800_HEADER
#define __TH3800_HEADER

#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

    /*- I/O buffer size -----------------------------------------------------*/
#define BUFFER_SIZE                             128L 
#define RESPONSE_SIZE							128L

#define IVI_STATUS_CODE_BASE                    0x3FFA0000L

#define IVI_WARN_BASE                           (IVI_STATUS_CODE_BASE)
#define IVI_CROSS_CLASS_WARN_BASE               (IVI_WARN_BASE + 0x1000)
#define IVI_CLASS_WARN_BASE                     (IVI_WARN_BASE + 0x2000)
#define IVI_SPECIFIC_WARN_BASE                  (IVI_WARN_BASE + 0x4000)
#define IVI_MAX_SPECIFIC_WARN_CODE              (IVI_WARN_BASE + 0x7FFF)

#define IVI_ERROR_BASE                          (_VI_ERROR + IVI_STATUS_CODE_BASE)
#define IVI_CROSS_CLASS_ERROR_BASE              (IVI_ERROR_BASE + 0x1000)
#define IVI_CLASS_ERROR_BASE                    (IVI_ERROR_BASE + 0x2000)
#define IVI_SPECIFIC_ERROR_BASE                 (IVI_ERROR_BASE + 0x4000)
#define IVI_MAX_SPECIFIC_ERROR_CODE             (IVI_ERROR_BASE + 0x7FFF)

#define TH3800_INTERFACE_ERROR 			(IVI_SPECIFIC_ERROR_BASE + 1)
#define TH3800_IN_BUFF_OVERFLOW			(IVI_SPECIFIC_ERROR_BASE + 2)
#define TH3800_OUT_BUFF_OVERFLOW		(IVI_SPECIFIC_ERROR_BASE + 3)
#define TH3800_UNIDENTIFIED_ERROR		(IVI_SPECIFIC_ERROR_BASE + 4)
#define TH3800_PARSER_ERROR				(IVI_SPECIFIC_ERROR_BASE + 5)
#define TH3800_TOO_HIGH_ERROR 			(IVI_SPECIFIC_ERROR_BASE + 6)
#define TH3800_TOO_LOW_ERROR 			(IVI_SPECIFIC_ERROR_BASE + 7)
#define TH3800_INCORRECT_CHANNEL		(IVI_SPECIFIC_ERROR_BASE + 8)
#define TH3800_BAD_COMMAND_SYNTAX 		(IVI_SPECIFIC_ERROR_BASE + 9)
#define TH3800_PROGRAM_NUMBER			(IVI_SPECIFIC_ERROR_BASE + 10)
#define TH3800_INTERVAL_SEQUENCE		(IVI_SPECIFIC_ERROR_BASE + 11)
#define TH3800_MEMORY_FULL	 			(IVI_SPECIFIC_ERROR_BASE + 12)
#define TH3800_ILLEGAL_STOP 			(IVI_SPECIFIC_ERROR_BASE + 13)
#define TH3800_ILLEGAL_HOLD 			(IVI_SPECIFIC_ERROR_BASE + 14)
#define TH3800_ILLEGAL_RUN_MANUAL		(IVI_SPECIFIC_ERROR_BASE + 15)
#define TH3800_INCORRECT_MODE 			(IVI_SPECIFIC_ERROR_BASE + 16)
#define TH3800_RUN_PROGRAM_ERROR		(IVI_SPECIFIC_ERROR_BASE + 17)
#define TH3800_RESUME_ERROR 			(IVI_SPECIFIC_ERROR_BASE + 18)
#define TH3800_OPTIONS_ERROR 			(IVI_SPECIFIC_ERROR_BASE + 19)

// Init and Close Functions

ViStatus _VI_FUNC  TH3800_init( ViRsrc resourceName, ViBoolean IDQuery, ViInt32 nBaudRate, ViSession *vi );
ViStatus _VI_FUNC  TH3800_InitWithOptions( ViRsrc resourceName, ViBoolean IDQuery, ViString optionString, ViInt32 nBaudRate, ViSession *newVi );
ViStatus _VI_FUNC  TH3800_close( ViSession vi );   

// Lock Functions

ViStatus _VI_FUNC  TH3800_LockSession (ViSession vi, ViBoolean *callerHasLock);  
ViStatus _VI_FUNC  TH3800_UnlockSession (ViSession vi, ViBoolean *callerHasLock); 

// Error Functions

ViStatus _VI_FUNC  TH3800_error_query( ViSession vi, ViInt32 *errorCode, ViChar errorMessage[] );
ViStatus _VI_FUNC  TH3800_error_message( ViSession vi, ViStatus errorCode, ViChar errorMessage[256] );
ViStatus _VI_FUNC  TH3800_GetErrorInfo (ViSession vi, ViStatus *primaryError, ViStatus *secondaryError, ViChar errorElaboration[256]);
ViStatus _VI_FUNC  TH3800_ClearErrorInfo (ViSession vi); 

// User Interface To The Machine

ViStatus _VI_FUNC TH3800_SetSetpoint( ViSession vi,ViInt32 nChannel, ViReal64 dSetValue );
ViStatus _VI_FUNC TH3800_SetTimeLeft( ViSession vi, ViInt32 nHours, ViInt32 nMinutes, ViInt32 nSeconds );
ViStatus _VI_FUNC TH3800_SetDeviation ( ViSession vi, ViInt32 nChannel, ViReal64 dDevValue );
ViStatus _VI_FUNC TH3800_SetAccessLevel( ViSession vi, ViInt32 nLockLevel );
ViStatus _VI_FUNC TH3800_SetLoopsLeft( ViSession vi, ViInt32 nLoopValue );
ViStatus _VI_FUNC TH3800_SetFinalValue( ViSession vi, ViInt32 nChannel, ViReal64 dFinalValue );
ViStatus _VI_FUNC TH3800_SetClock( ViSession vi, ViInt32 nMonth, ViInt32 nDay, ViInt32 nHour, ViInt32 nMin );
ViStatus _VI_FUNC TH3800_SetManualRamp( ViSession vi, ViInt32 nChannel, ViReal64 cUnitsPerMin );
ViStatus _VI_FUNC TH3800_SetTempScale( ViSession vi, ViInt32 nScaleCode );
ViStatus _VI_FUNC TH3800_SetManualOptions( ViSession vi, ViInt32 OptionCode );
ViStatus _VI_FUNC TH3800_SetAux( ViSession vi, ViInt32 nAuxGroup, ViInt32 nOptionCode );
ViStatus _VI_FUNC TH3800_SetMatchInterval( ViSession vi, ViInt32 nIntervalValue );
ViStatus _VI_FUNC TH3800_SetServiceReqMask( ViSession vi, ViInt32 nMaskCode );
ViStatus _VI_FUNC TH3800_SetProgConfigToMem( ViSession vi, ViInt32 nProgNum, ViChar strProgName[], ViInt32 nNumIntervals );
ViStatus _VI_FUNC TH3800_SetInitIntervalValues( ViSession vi, ViReal64 dChannel1, ViReal64 dChannel2, ViReal64 dChannel3, ViReal64 dChannel4, ViInt32 nActiveChCode );
ViStatus _VI_FUNC TH3800_SetIntervalValues( ViSession vi, ViInt32 nIntervalNum, ViReal64 dFinal1, ViReal64 dFinal2, ViReal64 dFinal3, ViReal64 dFinal4, ViReal64 dDev1, ViReal64 dDev2, ViReal64 dDev3, ViReal64 dDev4, ViInt32 nHours, ViInt32 nMinutes, ViInt32 nSeconds, ViInt32 nParamGroup, ViInt32 nNumLoops, ViInt32 nNextInterval, ViInt32 nAuxGroup1, ViInt32 nAuxGroup2, ViInt32 nDisplayStatus, ViInt32 nOptionsCode );
ViStatus _VI_FUNC TH3800_SetParValues( ViSession vi, ViInt32 nChannel, ViInt32 nParGroup, ViReal64 dHeatSet, ViReal64 dCoolSet, ViInt32 nHeatTime, ViInt32 nCoolTime, ViReal64 dHeatLimit, ViReal64 dCoolLimit );
ViStatus _VI_FUNC TH3800_GetTimeLeft( ViSession vi, ViInt32 *nHours, ViInt32 *nMinutes, ViInt32 *nSeconds );
ViStatus _VI_FUNC TH3800_GetProcVariable( ViSession vi, ViInt32 nChannel, ViReal64 *dVarValue );
ViStatus _VI_FUNC TH3800_GetDeviation( ViSession vi, ViInt32 nChannel, ViReal64 *dDevValue );
ViStatus _VI_FUNC TH3800_GetSetpoint( ViSession vi, ViInt32 nChannel, ViReal64 *dSetPtValue );
ViStatus _VI_FUNC TH3800_GetAlarm( ViSession vi, ViInt32 nChannel, ViInt32 *nAlarmCode );
ViStatus _VI_FUNC TH3800_GetStop( ViSession vi, ViInt32 *nStopCode );
ViStatus _VI_FUNC TH3800_GetStatus( ViSession vi, ViInt32 *nStatusCode );
ViStatus _VI_FUNC TH3800_GetCurrentProgNum( ViSession vi, ViInt32 *nProgNum );
ViStatus _VI_FUNC TH3800_GetVarUnitsChar( ViSession vi, ViInt32 nChannel, ViChar *strUnitChar );
ViStatus _VI_FUNC TH3800_GetChannelConfig( ViSession vi, ViInt32 nChannel, ViInt32 *nConfigCode );
ViStatus _VI_FUNC TH3800_GetSystemConfig( ViSession vi, ViInt32 *nConfigCode );
ViStatus _VI_FUNC TH3800_GetAccessLevel( ViSession vi, ViInt32 *nLockLevel );
ViStatus _VI_FUNC TH3800_GetProgMem( ViSession vi, ViInt32 *nMemValue );
ViStatus _VI_FUNC TH3800_GetClock( ViSession vi, ViInt32 *nMonth, ViInt32 *nDay, ViInt32 *nHour, ViInt32 *nMinute, ViInt32 *nSecond );
ViStatus _VI_FUNC TH3800_GetManualRamp( ViSession vi, ViInt32 nChannel, ViReal64 *dUnitsPerMin );
ViStatus _VI_FUNC TH3800_GetManualOptions( ViSession vi, ViInt32 *nOptionCode );
ViStatus _VI_FUNC TH3800_GetTempScale( ViSession vi, ViInt32 *nScaleCode );
ViStatus _VI_FUNC TH3800_GetThrottle( ViSession vi, ViInt32 nChannel, ViReal64 *dThrottleValue );
ViStatus _VI_FUNC TH3800_GetAux( ViSession vi, ViInt32 nAuxGroup, ViInt32 *nOptionCode );
ViStatus _VI_FUNC TH3800_GetID( ViSession vi, ViChar strDeviceID[] );
ViStatus _VI_FUNC TH3800_GetVersion( ViSession vi, ViChar strVersion[] );
ViStatus _VI_FUNC TH3800_GetInitialValue( ViSession vi, ViInt32 nChannel, ViReal64 *dInitialValue );
ViStatus _VI_FUNC TH3800_GetLoopsLeft( ViSession vi, ViInt32 *nLoopsValue );
ViStatus _VI_FUNC TH3800_GetNumLoops( ViSession vi, ViInt32 *dLoopsValue );
ViStatus _VI_FUNC TH3800_GetNextInterval( ViSession vi, ViInt32 *nIntervalValue );
ViStatus _VI_FUNC TH3800_GetProgName( ViSession vi, ViChar strProgramName[] );
ViStatus _VI_FUNC TH3800_GetFinalValue( ViSession vi, ViInt32 nChannel, ViReal64 *dFinalValue );
ViStatus _VI_FUNC TH3800_GetCurrentInterval( ViSession vi, ViInt32 *nIntervalValue );
ViStatus _VI_FUNC TH3800_GetProgIntervalTime( ViSession vi, ViInt32 *nHours, ViInt32 *nMinutes, ViInt32 *nSeconds ); 
ViStatus _VI_FUNC TH3800_GetChannelStatus( ViSession vi, ViInt32 *nChStatusCode );
ViStatus _VI_FUNC TH3800_GetMatchInterval( ViSession vi, ViInt32 *nIntervalValue );
ViStatus _VI_FUNC TH3800_GetServiceReqByte( ViSession vi, ViInt32 *nServiceCode );
ViStatus _VI_FUNC TH3800_GetServiceReqMask( ViSession vi, ViInt32 *nMaskCode );
ViStatus _VI_FUNC TH3800_GetProgConfigFromMem( ViSession vi, ViInt32 nProgNum, ViChar strProgName[], ViInt32 *nNumIntervals );
ViStatus _VI_FUNC TH3800_GetInitIntervalValues( ViSession vi, ViReal64 *dChannel1, ViReal64 *dChannel2, ViReal64 *dChannel3, ViReal64 *dChannel4, ViInt32 *nActiveChCode );
ViStatus _VI_FUNC TH3800_GetIntervalValues( ViSession vi, ViInt32 nIntervalNum, ViReal64 *dFinal1, ViReal64 *dFinal2, ViReal64 *dFinal3, ViReal64 *dFinal4, ViReal64 *dDev1, ViReal64 *dDev2, ViReal64 *dDev3, ViReal64 *dDev4, ViInt32 *nHours, ViInt32 *nMinutes, ViInt32 *nSeconds, ViInt32 *nParamGroup, ViInt32 *nNumLoops, ViInt32 *nNextInterval, ViInt32 *nAuxGroup1, ViInt32 *nAuxGroup2, ViInt32 *nDisplayStatus, ViInt32 *nOptionsCode );										
ViStatus _VI_FUNC TH3800_GetParValues( ViSession vi, ViInt32 nChannel, ViInt32 nParGroup, ViReal64 *dHeatSet, ViReal64 *dCoolSet, ViInt32 *nHeatTime, ViInt32 *nCoolTime, ViReal64 *dHeatLimit, ViReal64 *dCoolLimit );
ViStatus _VI_FUNC TH3800_RunProgram( ViSession vi, ViInt32 nProgramNumber, ViInt32 nIntervalNumber, ViBoolean bSingleStepMode );
ViStatus _VI_FUNC TH3800_Hold( ViSession vi );
ViStatus _VI_FUNC TH3800_Resume( ViSession vi );
ViStatus _VI_FUNC TH3800_Stop( ViSession vi );
ViStatus _VI_FUNC TH3800_Manual( ViSession vi );
ViStatus _VI_FUNC TH3800_LoadProgramFromFile( ViSession vi, ViChar strFilenameAndPath[] );
ViStatus _VI_FUNC TH3800_SendInstruction( ViSession vi, ViChar strInstruction[], ViChar strReturnString[] );
ViStatus _VI_FUNC  TH3800_IviInit( ViRsrc resourceName, ViBoolean IDQuery, ViInt32 nBaudRate, ViSession vi );
ViStatus _VI_FUNC  TH3800_IviClose( ViSession vi );   


#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif
#endif /* __TH3800_HEADER */




