Imports System.Windows.Forms
Imports System.Drawing
Imports System.IO

Public Class Snap
    'Klasse zum Abfotografieren von Bildschirminhalten und Teilinhalten
    Private Declare Function GetDesktopWindow Lib "user32" () _
      As System.IntPtr
    Private Declare Function GetActiveWindow Lib "user32" () _
      As System.IntPtr
    Private Declare Function GetCapture Lib "user32" () _
      As System.IntPtr
    Private Declare Function GetForegroundWindow Lib "user32" () _
      As System.IntPtr
    Private Declare Function SetForegroundWindow Lib "user32" ( _
      ByVal hWnd As System.IntPtr) As Integer
    Private Declare Function GetWindow Lib "user32" (ByVal hWnd As _
      System.IntPtr, ByVal wCmd As Integer) As System.IntPtr
    Private Declare Function GetFocus Lib "user32" () As System.IntPtr
    Private Declare Function EnumWindows Lib "user32" (ByVal Callback As EnumWindowsProc, _
      ByVal Parm As Integer) As Integer
    Private Delegate Function EnumWindowsProc(ByVal hwnd As System.IntPtr, _
      ByVal p As Integer) As Boolean
    Private Declare Function IsWindowVisible Lib "user32" (ByVal hwnd As System.IntPtr) As Boolean
    Private Declare Function IsChild Lib "user32" (ByVal hwnd As System.IntPtr) As Boolean
    Private Declare Function IsIconic Lib "user32" (ByVal hwnd As System.IntPtr) As Boolean
    Private Declare Function GetParent Lib "user32" (ByVal hwnd As System.IntPtr) As System.IntPtr
    Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" _
      (ByVal hwnd As System.IntPtr, ByVal Idx As Integer) As Integer
    Private Declare Function GetWindowDC Lib "user32" (ByVal hwnd As _
      System.IntPtr) As System.IntPtr
    Private Declare Function GetDC Lib "user32" (ByVal hwnd As _
      System.IntPtr) As System.IntPtr
    Private Declare Function GetWindowRect Lib "user32" (ByVal _
      hwnd As System.IntPtr, ByRef lpRect As RECT) As Integer
    Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC _
      As System.IntPtr, ByVal x As Integer, ByVal y As Integer, _
      ByVal nWidth As Integer, ByVal nHeight As Integer, _
      ByVal hSrcDC As System.IntPtr, ByVal xSrc As Integer, _
      ByVal ySrc As Integer, ByVal dwRop As System.Int32) As System.UInt64
    Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd _
            As System.IntPtr, ByVal hdc As System.IntPtr) As Integer

    Structure RECT
        Dim Left As Integer
        Dim Top As Integer
        Dim Width As Integer
        Dim Height As Integer
    End Structure

    Const SRCCOPY As Integer = &HCC0020
    Const GWL_EXTSTYLE As Integer = (-20)
    Const GW_OWNER As Integer = 4
    Const WS_EX_APPWINDOW As Integer = &H40000

    Public Enum PictureFormat
        'untersttzte Bildformate
        Bmp '0
        Jpg '1
        Gif '2
        Tif '3
        Png '4
    End Enum

    'Member-Variablen
    Dim mPath As String
    Dim mEnumFormat As PictureFormat = PictureFormat.Jpg
    Dim mEnumMode As Boolean = True
    Dim mHwnd() As System.IntPtr
    Dim mCounter As Integer = 0
    Dim mEnumPath As String

    Public Property EnumPath() As String
        'in dieser Eigenschaft kann das Zielverzeichnis fr das
        'Abfotografieren aller aktiver Fenster gesetzt werden
        Get
            Return mEnumPath
        End Get
        Set(ByVal Value As String)
            mEnumPath = Value
        End Set
    End Property

    Public Property EnumFormat() As PictureFormat
        Get
            Return mEnumFormat
        End Get
        Set(ByVal Value As PictureFormat)
            mEnumFormat = Value
        End Set
    End Property

    Public Sub New()
        'fr COM-Klasse erforderlich, um die Klasse via CreateObject
        'instanzieren zu knnen
        MyBase.New()
    End Sub

    Public Property PicturePath() As String
        'Pfad abfragen
        'Standard: Benutzerverzeichnis\Eigene Bilder
        Get
            If EnumPath <> "" Then
                Return EnumPath
            Else
                'Pfad wurde nicht angegeben, also autom. setzen
                Dim Personal As String = Environment.GetFolderPath( _
                  Environment.SpecialFolder.Personal)
                Dim PersPicture As String = Personal & "\Eigene Bilder"
                If mPath = "" Then
                    If Directory.Exists(PersPicture) Then
                        Return PersPicture
                    ElseIf Directory.Exists(Personal) Then
                        Return Personal
                    Else
                        Return ""
                    End If
                Else
                    Return mPath
                End If
            End If
        End Get
        'Pfad setzen (optional, ansonsten Standardverzeichnis s.o.)
        Set(ByVal Value As String)
            If System.IO.Directory.Exists(Value) Then
                mPath = Value
            Else
                'anlegen versuchen
                Try
                    Directory.CreateDirectory(Value)
                Catch
                    'nicht mglich, also Anwendungsverzeichnis nutzen
                    mPath = Environment.GetFolderPath( _
                      Environment.SpecialFolder.Personal)
                Finally
                    'gewhlten/zulssigen Pfad bernehmen
                    mPath = Value
                End Try
            End If
        End Set
    End Property

    Public Function SnapScreen(ByVal fmt As PictureFormat, ByVal FileName As String) As String
        'Desktop-Screenshot
        Dim ScrHwnd As System.IntPtr
        Dim ScrHdc As System.IntPtr
        Dim DestHdc As System.IntPtr
        Dim Height As Integer = _
          Screen.PrimaryScreen.Bounds.Height
        Dim Width As Integer = _
          Screen.PrimaryScreen.Bounds.Width
        Dim PictureRect As RECT
        Dim Img As Image = New Bitmap(Width, Height)
        Dim gImg As Graphics = Graphics.FromImage(Img)
        ScrHwnd = GetDesktopWindow()
        ScrHdc = GetWindowDC(ScrHwnd)
        DestHdc = gImg.GetHdc()
        GetWindowRect(ScrHwnd, PictureRect)
        BitBlt(DestHdc, PictureRect.Left, PictureRect.Top, _
          PictureRect.Width, PictureRect.Height, ScrHdc, _
          0, 0, SRCCOPY)
        ReleaseDC(ScrHwnd, ScrHdc)
        gImg.ReleaseHdc(ScrHdc)
        SavePicture(Img, fmt, FileName)
        Img = Nothing
        Return FileName
    End Function

    Public Function SnapRegion(ByVal fmt As PictureFormat, ByVal FileName As String, _
      ByVal StartX As Integer, ByVal StartY As Integer, ByVal sWidth As Integer, _
      ByVal sHeight As Integer) As String
        'aktives Formular
        Dim ScrHwnd As System.IntPtr
        Dim ScrHdc As System.IntPtr
        Dim DestHdc As System.IntPtr
        Dim PictureRect As RECT
        ScrHwnd = GetDesktopWindow()
        ScrHdc = GetWindowDC(ScrHwnd)
        Dim Img As Image = New Bitmap(sWidth, sHeight)
        Dim gImg As Graphics = Graphics.FromImage(Img)
        DestHdc = gImg.GetHdc()
        BitBlt(DestHdc, 0, 0, _
          sWidth, sHeight, ScrHdc, _
          StartX, StartY, SRCCOPY)
        ReleaseDC(ScrHwnd, ScrHdc)
        gImg.ReleaseHdc(ScrHdc)
        SavePicture(Img, fmt, FileName)
        Img = Nothing
        Return FileName
    End Function

    Public Function SnapWindow(ByVal fmt As PictureFormat, ByVal FileName As String) As String
        'aktives Formular
        Dim ScrHwnd As System.IntPtr
        Dim ScrHdc As System.IntPtr
        Dim DestHdc As System.IntPtr
        Dim PictureRect As RECT
        'aktives Vordergrundfenster 
        ScrHwnd = GetForegroundWindow()
        If ScrHwnd.ToInt32 = 0 Then
            'Script-Version per Enumeration
            mCounter = 0
            EnumWindows(AddressOf EnumWins, 0)
            ScrHwnd = mHwnd(1)
        End If
        If ScrHwnd.ToInt32 <> 0 Then
            ScrHdc = GetWindowDC(ScrHwnd)
            GetWindowRect(ScrHwnd, PictureRect)
            Dim Img As Image = New Bitmap(PictureRect.Width - PictureRect.Left, _
              PictureRect.Height - PictureRect.Top)
            Dim gImg As Graphics = Graphics.FromImage(Img)
            DestHdc = gImg.GetHdc()
            BitBlt(DestHdc, 0, 0, _
              PictureRect.Width, PictureRect.Height, ScrHdc, _
              0, 0, SRCCOPY)
            ReleaseDC(ScrHwnd, ScrHdc)
            gImg.ReleaseHdc(ScrHdc)
            SavePicture(Img, fmt, FileName)
            Img = Nothing
            Return FileName
        End If
    End Function

    Public Function SnapMainWindows()
        'alle Hauptformulare abfotografieren
        'aktives Fenster sichern und nach Enumeration wiederherstellen
        '(Dateiformat ber EnumFormat-Eigenschaft setzbar)
        Dim ActiveHwnd As System.IntPtr = GetForegroundWindow()
        mCounter = 0
        EnumWindows(AddressOf EnumWins, 0)
        Dim mH As System.IntPtr
        For Each mH In mHwnd
            If mH.ToInt32 <> 0 Then
                SetForegroundWindow(mH)
                SavePicByHwnd(mH)
            End If
        Next
        If ActiveHwnd.ToInt32 <> 0 Then
            SetForegroundWindow(ActiveHwnd)
        End If
    End Function

    Public Function GenerateFileName(ByVal Format As PictureFormat, Optional ByVal Main As String = "Snap-") As String
        'Dateinamen generieren
        Dim Path As String = PicturePath
        If Right(Path, 1) <> "\" Then
            Path = Path & "\"
        End If
        'Startwert
        Dim Counter As Integer = 1
        Dim MainName As String
        Do
            'Hauptname ohne Suffix
            MainName = Main & Fill(Counter)
            'Suffix anfgen
            Select Case Format
                Case PictureFormat.Bmp
                    MainName = MainName & ".bmp"
                Case PictureFormat.Gif
                    MainName = MainName & ".gif"
                Case PictureFormat.Jpg
                    MainName = MainName & ".jpg"
                Case PictureFormat.Png
                    MainName = MainName & ".png"
                Case PictureFormat.Tif
                    MainName = MainName & ".tif"
            End Select
            Counter = Counter + 1
        Loop Until File.Exists(Path & MainName) = False
        Return Path & MainName
    End Function

    Public Function Fill(ByVal c As Integer)
        'Bildnummer mindestens zwlfstellig auffllen
        Dim Str As String = c.ToString
        Dim Laenge As Integer = Len(Str)
        If Laenge < 12 Then
            Return Format(c, "000000000000")
        Else
            Return Str
        End If
    End Function

    Private Sub SavePicture(ByVal Img As Image, ByVal Format As PictureFormat, ByVal FileName As String, Optional ByVal Main As String = "Snap-")
        'Dateiname prfen
        If FileName = "" Or System.IO.File.Exists(FileName) Then
            'ggfs. ersetzen (hier Hauptname ohne Suffix)
            FileName = GenerateFileName(Format, Main)
        End If
        If System.IO.File.Exists(FileName) Then
            'ggfs. lschen
            Kill(FileName)
        End If
        'Grafik in gewhltem Format speichern
        Select Case Format
            Case PictureFormat.Bmp
                'ggfs. erforderliches Dateikrzel anhngen
                If Right(LCase(FileName), 4) <> ".bmp" Then
                    FileName = FileName & ".bmp"
                End If
                'Bild in Datei speichern
                Img.Save(FileName, Imaging.ImageFormat.Bmp)
            Case PictureFormat.Gif
                If Right(LCase(FileName), 4) <> ".gif" Then
                    FileName = FileName & ".gif"
                End If
                Img.Save(FileName, Imaging.ImageFormat.Gif)
            Case PictureFormat.Jpg
                If Right(LCase(FileName), 4) <> ".jpg" Then
                    FileName = FileName & ".jpg"
                End If
                Img.Save(FileName, Imaging.ImageFormat.Jpeg)
            Case PictureFormat.Png
                If Right(LCase(FileName), 4) <> ".png" Then
                    FileName = FileName & ".png"
                End If
                Img.Save(FileName, Imaging.ImageFormat.Png)
            Case PictureFormat.Tif
                If Right(LCase(FileName), 4) <> ".tif" Then
                    FileName = FileName & ".tif"
                End If
                Img.Save(FileName, Imaging.ImageFormat.Tiff)
        End Select
    End Sub

    Function EnumWins(ByVal hwnd As System.IntPtr, ByVal Parm As Integer) As Boolean
        'Fensterkennung merken
        'nur sichtbare, keine Kindfenster, keine verkleinerten Fenster
        Try
            If IsWindowVisible(hwnd) Then
                If Not IsIconic(hwnd) And Not IsChild(hwnd) Then
                    'kein Elternfenster vorhanden?
                    If GetParent(hwnd).ToInt32 = 0 Then
                        Dim wStyle As Integer = GetWindowLong(hwnd, GWL_EXTSTYLE)
                        'Anwendungsfenster?
                        If wStyle And WS_EX_APPWINDOW <> 0 Then
                            'kein untergeordnetes Fenster?
                            If GetWindow(hwnd, GW_OWNER).ToInt32 = 0 Then
                                'Fenster in den Vordergund
                                If SetForegroundWindow(hwnd) <> 0 Then
                                    'Kennungen sichern
                                    SaveWinHandles(hwnd)
                                End If
                            End If
                        End If
                    End If
                End If
            End If
        Catch
        Finally
        End Try
        Return True
    End Function

    Sub SavePicByHwnd(ByVal Hwnd As System.IntPtr)
        Dim ScrHdc As System.IntPtr
        Dim DestHdc As System.IntPtr
        Dim PictureRect As RECT
        ScrHdc = GetWindowDC(Hwnd)
        GetWindowRect(Hwnd, PictureRect)
        Dim xWidth, xHeight As Integer
        If PictureRect.Width > PictureRect.Left And _
          PictureRect.Height > PictureRect.Top Then
            xWidth = PictureRect.Width - PictureRect.Left
            xHeight = PictureRect.Height - PictureRect.Top
        Else
            xWidth = PictureRect.Width
            xHeight = PictureRect.Height
        End If
        Dim Img As Image = New Bitmap(xWidth, xHeight)
        Dim gImg As Graphics = Graphics.FromImage(Img)
        DestHdc = gImg.GetHdc()
        BitBlt(DestHdc, 0, 0, _
        PictureRect.Width - PictureRect.Left, PictureRect.Height - PictureRect.Top, ScrHdc, _
          0, 0, SRCCOPY)
        ReleaseDC(Hwnd, ScrHdc)
        gImg.ReleaseHdc(ScrHdc)
        'Hauptdateinme vorgegeben, Bildformat muss
        'ber EnumFormat gesetzt worden sein
        SavePicture(Img, EnumFormat, "", "SnapEnum-")
        System.Windows.Forms.Application.DoEvents()
        Img = Nothing
    End Sub

    Sub SaveWinHandles(ByVal hwnd As System.IntPtr)
        'Kennungen in Datenfeld sichern
        ReDim Preserve mHwnd(mCounter)
        mHwnd(mCounter) = hwnd
        mCounter = mCounter + 1
    End Sub
End Class


