

/*Makes 'Port' an input*/
_declspec(dllexport) long MakePortInput(long Port)
{
   INST cmdr;
   long temp;
   char* strret;
   
   /* Print message and terminate on error */
   ionerror (error_handler);

   /* Open the instrument session */
   cmdr = iopen ("hpib7,9,0");
   itermchr (cmdr, 0x0a);

   /* Select Port x */
   if ((Port >=0) && (Port<4))
   {
	   iprintf (cmdr,"DIAG:POKE #H1FCE04,16,64766\n");
	   temp= 2084392 + Port;
   }
   else if ((Port >=4) && (Port <8))
   {
	   iprintf (cmdr,"DIAG:POKE #H1FCE04,16,65022\n");
	   temp= 2084388 + Port;
   }
   else if ((Port >=8) && (Port <12))
   {
	   iprintf (cmdr,"DIAG:POKE #H1FCE04,16,65278\n");
	   temp= 2084384 + Port;
   }
   else 
   {
	   iclose(cmdr);
	   return 2001;
   }
         
/* Send the string and read the return*/   
   iprintf (cmdr, "DIAG:PEEK? %d,8\n",temp);
   iread (cmdr, strret, 5,NULL,NULL);
   
/* Convert to long*/
   long sign1= (long) *strret;
   if (sign1==45)
   {
	   sign1= -1;
   }
   else 
   {
	   sign1= 1;
   }
   long word=0;
   long power=1;
   for (int i=3;i>0;i--)
   {
	   if (((int) *(strret+i)>47) && ((int) *(strret+i)<58))
	   {
		   power *= 10;
		   word += ((int) *(strret+i) -48)* power;
	   }
   }

   /* Bitwise OR with bit 6 to set the I/O line high for input*/
   word = ((word/10)*sign1) | 64;
   iprintf (cmdr, "DIAG:POKE %d,8,%d\n", temp, word);
   
   /* Close the instrument session */
   iclose(cmdr);
   
return 0;
}


/*Makes 'Port' an output*/
_declspec(dllexport) long MakePortOutput(long Port)
{
   INST cmdr;
   long temp;
   char* stringret;
   
   /* Print message and terminate on error */
   ionerror (error_handler);

   /* Open the instrument session */
   cmdr = iopen ("hpib7,9,0");
   int a=itermchr (cmdr, 0x0a);

   /* Select Port x */
   if ((Port >=0) && (Port<4))
   {
	   iprintf (cmdr,"DIAG:POKE #H1FCE04,16,64766\n");
	   temp= 2084392 + Port;
   }
   else if ((Port >=4) && (Port <8))
   {
	   iprintf (cmdr,"DIAG:POKE #H1FCE04,16,65022\n");
	   temp= 2084388 + Port;
   }
   else if ((Port >=8) && (Port <12))
   {
	   iprintf (cmdr,"DIAG:POKE #H1FCE04,16,65278\n");
	   temp= 2084384 + Port;
   }
   else 
   {
	   iclose(cmdr);
	   return 2001;
   }
   
   /*PEEK the Port control status register*/
   int b=iprintf (cmdr, "DIAG:PEEK? %d,8\n", temp);
   int c=iread (cmdr, stringret,5,NULL,NULL);

/* Bitwise OR with bit 6 to set the I/O line high for input*/
   long sign2= (long) *stringret;
   if (sign2==45)
   {
	   sign2= -1;
   }
   else 
   {
	   sign2= 1;
   }
   long word=0;
   long power=1;
   for (int i=3;i>0;i--)
   {
	   if (((int) *(stringret+i)>47) && ((int) *(stringret+i)<58))
	   {
		   power *= 10;
		   word += ((int) *(stringret+i) -48)* power;
	   }
   }

   /* Bitwise AND with word to set bit 6 low for Output*/
   word = ((word/10)*sign2) & 191;
   iprintf (cmdr, "DIAG:POKE %d,8,%d\n", temp, word);
   
   /* Close the instrument session */
   iclose(cmdr);
return 0;
} 

