#pragma once

#if !defined(QARBDISCOVERYLIBRARY_INCLUDED)
#define QARBDISCOVERYLIBRARY_INCLUDED

//////////////////////////////////////////////////////////////////////
/// \file QarbDiscoveryLibrary.cpp This file is the interface to a DLL
/// that tries to identify all the N6030A instruments which reside
/// in the card cage with the computer or are attenched to the computer
/// through a PXI interface.  Visa by itself will not identify these
/// instruments, so it is necessary to use the N6030A's IVI driver to 
/// perform the discovery.  This libary is written in managed c++ and
/// is compiled into a .Net DLL, not a native Windows DLL.  The
/// implications are that we can link directly against this DLL from 
/// a C# file, like the CM server or STW Instrument Explorer, and
/// and that dynamically allocated memory is garbage collected,
/// meaning that there is no need to delete memory we have new'd.
/// For an example illustrating the use of the functions in this 
/// library, refer the file QarbDiscovery.cpp in the parent directory
/// of the directory that contains this source file.
//////////////////////////////////////////////////////////////////////
// $RCSfile: QarbDiscoveryLibrary.h,v $
// $Revision: 1.2 $
// $Date: 2005/11/29 17:49:29 $
// $Author: doomer $
//////////////////////////////////////////////////////////////////////

using namespace System;
using namespace System::Collections;

/// This class encapsulates the ability to enumerate N6030A instruments using the 
/// instrument's IVI driver.  The __gc means that this is a garbage-collected
/// .Net class.  This class is written in managed C++, meaning that the .Net garbage
/// collecter will clean up dynamically-alloccated memory.
public __gc class QarbDiscovery
{
    static Hashtable *rsrcIdTable = new Hashtable();

public:
    /// This function will try to load the N6030A IVI driver in an attempt
    /// to enumerate the Visa resource strings used to identify particular 
    /// instruments.  We call into a native windows DLL to check that the version
    /// of IVI driver on the system is late enough to meet our needs.  Earlier versions
    /// of the IVI driver ued a different number of arguments in the discovery function.
    /// We need a native DLL to do this, because managed C++ will not compie the version
    /// information header file.
    /// \param resources A reference to an ArrayList that gets populated with the Visa
    /// resource strings corresponding to an instrument.  This function does not clear
    /// the array; it just adds whatever resource strings it finds to the end of
    /// the list.
    /// \return True if we can dynamically load the IVI driver, it is of a sufficient
    /// revision, the driver DLL contains the discovery function, and we succesfully
    /// called the discovery function.  Otherwise, we return false.
    static bool EnumQarbResources(ArrayList *resources);

    /// Given a Visa resource, return the corresponding instrument description.  Before calling this 
    /// function, you should have previously called EnumQarbResources.
    /// \param resource The Visa resource corresponding to the instrument whose description you
    /// want.
    /// \return The instrument description or a null string if we can't find a description
    /// corresponding to resource.
    static String* GetIdForQarbAtRsrc(String *resource);
};

#endif

//////////////////////////////////////////////////////////////////////
// $Log: QarbDiscoveryLibrary.h,v $
// Revision 1.2  2005/11/29 17:49:29  doomer
// documentation
//
// Modified Files:
// 	QarbDiscovery/QarbDiscovery.cpp
// 	QarbDiscovery/QarbDiscoveryHelper/QarbDiscoveryHelper.cpp
// 	QarbDiscovery/QarbDiscoveryHelper/QarbDiscoveryHelper.h
// 	QarbDiscovery/QarbDiscoveryLibrary/QarbDiscoveryLibrary.cpp
// 	QarbDiscovery/QarbDiscoveryLibrary/QarbDiscoveryLibrary.h
//
//////////////////////////////////////////////////////////////////////
