#if !defined(QARBDISCOVERYHELPER_INCLUDED)
#define QARBDISCOVERYHELPER_INCLUDED

//////////////////////////////////////////////////////////////////////
/// \file QarbDiscoveryHelper.h This file is the interface to a DLL
/// that attempts to find the version information resource in the
/// N6030A IVI driver.  This DLL contains only one function, because
/// I couldn't put this function in a .Net assembly, so I created a 
/// native win32 DLL to house the function.
//////////////////////////////////////////////////////////////////////
// $RCSfile: QarbDiscoveryHelper.h,v $
// $Revision: 1.2 $
// $Date: 2005/11/29 17:49:29 $
// $Author: doomer $
//////////////////////////////////////////////////////////////////////

#ifdef QARBDISCOVERYHELPER_EXPORTS
#define QARBDISCOVERYHELPER_API __declspec(dllexport)
#else
#define QARBDISCOVERYHELPER_API __declspec(dllimport)
#endif

extern "C"
{
/// Try to load the version information resource for the N6030A's IVI
/// driver.  
/// \return True, if we can find the driver and the driver version is
/// sufficient for our use, false otherwise.
QARBDISCOVERYHELPER_API bool __stdcall QarbDllVersionIsSufficient();
}

//////////////////////////////////////////////////////////////////////
// $Log: QarbDiscoveryHelper.h,v $
// Revision 1.2  2005/11/29 17:49:29  doomer
// documentation
//
// Modified Files:
// 	QarbDiscovery/QarbDiscovery.cpp
// 	QarbDiscovery/QarbDiscoveryHelper/QarbDiscoveryHelper.cpp
// 	QarbDiscovery/QarbDiscoveryHelper/QarbDiscoveryHelper.h
// 	QarbDiscovery/QarbDiscoveryLibrary/QarbDiscoveryLibrary.cpp
// 	QarbDiscovery/QarbDiscoveryLibrary/QarbDiscoveryLibrary.h
//
//////////////////////////////////////////////////////////////////////

#endif

