//////////////////////////////////////////////////////////////////////
/// \file QarbDiscoveryHelper.h This file is the implementation of a DLL
/// that attempts to find the version information resource in the
/// N6030A IVI driver.  This DLL contains only one function, because
/// I couldn't put this function in a .Net assembly, so I created a 
/// native win32 DLL to house the function.
//////////////////////////////////////////////////////////////////////
// $RCSfile: QarbDiscoveryHelper.cpp,v $
// $Revision: 1.2 $
// $Date: 2005/11/29 17:49:29 $
// $Author: doomer $
//////////////////////////////////////////////////////////////////////

#include "QarbDiscoveryHelper.h"

#include <windows.h>

#include <malloc.h>

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}

/// We use this class to encapsulate the Qarb IVI driver DLL version information.
struct QArbDllVersionInfo
{
    unsigned long m_major;
    unsigned long m_minor;
    unsigned long m_buildMajor;
    unsigned long m_buildMinor;

    QArbDllVersionInfo() : m_major(0), m_minor(0), m_buildMajor(0), m_buildMinor(0) {}

    /// Initialize an instance of this class with version information.  Usually, this
    /// is 4 period-separated numbers that form a Windows version resource.
    QArbDllVersionInfo(unsigned long major, unsigned long minor,
        unsigned long buildMajor, unsigned long buildMinor) :
    m_major(major), m_minor(minor), m_buildMajor(buildMajor), m_buildMinor(buildMinor) {}

    /// Check to see that this instance's version information is >= the version of
    /// the instance identified in rhs.  An example using this operator is found by looking
    /// at the QarbDllVersionIsSufficient function.
    /// \param rhs An instance of this class.  It is permissible, though not terrinbly useful,
    /// for rhs to be the same instance as this.
    bool operator>=(const QArbDllVersionInfo &rhs){
        bool result = false;

        if(m_major > rhs.m_major) return true;
        if(m_major == rhs.m_major){
            if(m_minor > rhs.m_minor) return true;
            if(m_minor == rhs.m_minor){
                if(m_buildMajor > rhs.m_buildMajor) return true;
                if(m_buildMajor == rhs.m_buildMajor){
                    if(m_buildMinor >= rhs.m_buildMinor) result = true;
                }
            }
        }

        return result;
    }
};

/// Try to load the version information resource for the N6030A's IVI
/// driver.  
/// \return True, if we can find the driver and the driver version is
/// sufficient for our use, false otherwise.
QARBDISCOVERYHELPER_API bool __stdcall QarbDllVersionIsSufficient()
{
    bool result = false;

    const char *qarbDllName = "AGN6030A.dll";
    VS_FIXEDFILEINFO vsf;
    void *rawVersionInfo = 0;

    __try{
        DWORD dwHandle = 0;
        DWORD rawVersionInfoSize = GetFileVersionInfoSize(qarbDllName,&dwHandle);
        if (rawVersionInfoSize == 0) 
            __leave;
        rawVersionInfo = calloc(rawVersionInfoSize, sizeof(char));
        if( ! rawVersionInfo)
            __leave;
        BOOL bret = GetFileVersionInfo(qarbDllName,dwHandle,rawVersionInfoSize,rawVersionInfo);
        if (!bret) 
            __leave;
        UINT uLen;
        void *pbuf;
        bret = VerQueryValue(rawVersionInfo,"\\",&pbuf,&uLen);
        if (!bret) 
            __leave;
        memcpy(&vsf,pbuf,sizeof(VS_FIXEDFILEINFO));

        unsigned short bitsToShift = (sizeof(vsf.dwFileVersionMS) / 2) * 8;

        unsigned long major = (vsf.dwFileVersionMS & (0xffff << bitsToShift)) >> bitsToShift;
        unsigned long minor = vsf.dwFileVersionMS & 0xffff;
        unsigned long buildMajor = (vsf.dwFileVersionLS & (0xffff << bitsToShift)) >> bitsToShift;
        unsigned long buildMinor = vsf.dwFileVersionLS & 0xffff;

        result = QArbDllVersionInfo(major, minor, buildMajor, buildMinor) >=
            QArbDllVersionInfo(1, 8, 0, 0);
    }
    __finally{
        if(rawVersionInfo){
            free(rawVersionInfo);
        }
    }

    return result;
}

//////////////////////////////////////////////////////////////////////
// $Log: QarbDiscoveryHelper.cpp,v $
// Revision 1.2  2005/11/29 17:49:29  doomer
// documentation
//
// Modified Files:
// 	QarbDiscovery/QarbDiscovery.cpp
// 	QarbDiscovery/QarbDiscoveryHelper/QarbDiscoveryHelper.cpp
// 	QarbDiscovery/QarbDiscoveryHelper/QarbDiscoveryHelper.h
// 	QarbDiscovery/QarbDiscoveryLibrary/QarbDiscoveryLibrary.cpp
// 	QarbDiscovery/QarbDiscoveryLibrary/QarbDiscoveryLibrary.h
//
//////////////////////////////////////////////////////////////////////
