/*********************************************************************
 *********************************************************************

 NrpZxxCalc.h : Main header file for DLL NrpZxxCalc.dll

 Author: Toralf Bratfisch, 1GP3

 *********************************************************************
 *********************************************************************/

#ifndef NRPZXXCALC_DLL_H
#define NRPZXXCALC_DLL_H

#ifndef NRPZXXCALCDLL_VERSION_INFO
#define NRPZXXCALCDLL_VERSION_INFO  270
#endif

#ifdef NRPZXXCALCDLL_EXPORTS
#define NRPZXXCALCDLL_API __declspec ( dllexport )
#else   // NRPZXXCALCDLL_EXPORTS
#define NRPZXXCALCDLL_API __declspec ( dllimport )
#endif  // NRPZXXCALCDLL_EXPORTS

#include "NRPZXXCALCDLL_ERROR_T.H"
#include "NRPZXXCALCDLL_CONFIG_T.H"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct NrpZxxCalcDLLSParaInfo
{
  double freq;
  double re_s11;
  double im_s11;
  double exp_unc_s11;
  double re_s21;
  double im_s21;
  double exp_unc_s21_db;
  double re_s12;
  double im_s12;
  double exp_unc_s12_db;
  double re_s22;
  double im_s22;
  double exp_unc_s22;
  BOOL interpolate;
} NRPZXXCALCDLL_S_PARA_INFO_T;

typedef union NrpZxxCalcDLLParamVal
{
  long longVal;
  BOOL boolVal;
  double doubleVal;
  char *pCharVal;
} NRPZXXCALCDLL_PARAM_VAL_T;

typedef enum NrpZxxCalcDLLParamType
{
  firstType,

  errorType = firstType,
  longType,
  boolType,
  doubleType,
  pCharType,

  numberOfTypes
} NRPZXXCALCDLL_PARAM_TYPE_T;

typedef struct NrpZxxCalcDLLSensorParam
{
  NRPZXXCALCDLL_PARAM_VAL_T paramVal;
  NRPZXXCALCDLL_PARAM_TYPE_T paramType;
} NRPZXXCALCDLL_SENSOR_PARAM_T;

typedef enum NrpZxxCalcDLLSensorParamID
{
  firstSensorParamID,

  name = firstSensorParamID,
  stocknumber,
  attribute,
  usbid,
  gain,
  vref,
  hwversion,
  hwvariant,
  hwsubvariant,
  ep0packetsize,
  channels,
  llsmethod,
  impedance,
  spcdefault,
  spclock,
  minp,
  maxp,
  minpp,
  maxpp,
  tempcal,
  linearize,
  intpolytype,
  intpolydegree,
  ditherdefault,
  rnulldefault,
  rserdefault,
  nrefdefault,
  athermdefault,
  bthermdefault,
  cthermdefault,
  dthermdefault,
  cjuncdefault,
  format3,
  revision3,
  pseudochannels,
  configurations,
  noisevoltage,
  noisecorner,
  minf,
  maxf,
  platform,
  features,
  application,
  bootloader,
  targetdescr,
  caldatadefault,
  sensordbformat,
  sensordbdate,

  numberOfUnindexedSensorParamIDs,

  llsfactor_length = numberOfUnindexedSensorParamIDs,
  llsfactor,
  fullscale_length,
  fullscale,
  intpolydata_length,
  intpolydata,
  zerodefault_length,
  zerodefault,
  cfg0_length,
  cfg0,
  cfg0if0ep1_length,
  cfg0if0ep1,
  cfg0if0ep2_length,
  cfg0if0ep2,

  numberOfSensorParamIDs
} NRPZXXCALCDLL_SENSOR_PARAM_ID_T;

typedef struct NrpZxxCalcDLLPoint
{
  double x;
  double y;
  double unc;
} NRPZXXCALCDLL_POINT_T;

typedef struct NrpZxxCalcQuadraticPoly
{
  double x_start;
  double coeff[ 4 ];
  double unc;
} NRPZXXCALCDLL_QUADRATIC_POLY_T;

NRPZXXCALCDLL_API
unsigned long NrpZxxCalcDLL_version_info
(
  void
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_CONFIG_T NrpZxxCalcDLL_getConfig
(
  void
);

NRPZXXCALCDLL_API
void NrpZxxCalcDLL_setConfig
(
  NRPZXXCALCDLL_CONFIG_T config
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_run_user_script
(
  const char* user_script_name,
  unsigned long argc,
  const char* argv[]
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_load_buf
(
  const char* cds_name,
  BOOL* pFormat3
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_load_buf2
(
  const char* pCds_mem,
  unsigned long cds_size,
  BOOL* pFormat3
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_store_buf
(
  const char* cds_name,
  BOOL format3
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_store_buf2
(
  const char* pCds_mem,
  unsigned long* pCds_size,
  BOOL format3
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_generate_buf
(
  const char* new_sensor_name,
  BOOL* pFormat3
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_generate_buf2
(
  const char* new_sensor_name,
  const char* new_stock_no,
  BOOL* pFormat3
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_generate_buf3
(
  const char* new_sensor_name,
  const char* new_stock_no,
  const char* new_attribute,
  BOOL* pFormat3
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_precalibrate_buf
(
  const char* temp_mdf_name,
  const char* lin_mdf_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_abso_refl_buf
(
  const char* abso_mdf_name,
  const char* refl_mdf_name,
  const char* out_prot_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_lin_buf
(
  const char* lin_mdf_name,
  const char* out_prot_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_s_para_buf
(
  const char* s_para_file_name,
  const char* unc_raw_name,
  const char* cal_lab,
  const char* cal_engineer,
  const float* min_power_padded,
  const float* max_power_padded,
  const unsigned long* s_para_corr_default,
  const char* spd_mnemonic
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_misc_buf
(
  const char* misc_mdf_name,
  BOOL excludeDiodeParameters
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_testpower_buf
(
  const float* pTestpower
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_visualize_buf
(
  const char* vis_file_name,
  const char* out_prot_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_get_sensorname_buf
(
  char* name,
  unsigned long max_name_size
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_get_stocknumber_buf
(
  char* stock_no,
  unsigned long max_stock_no_size
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_get_serialnumber_buf
(
  char* ser_no,
  unsigned long max_ser_no_size
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_get_attribute_buf
(
  char* attribute,
  unsigned long max_attribute_size
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_get_expiry_date_buf
(
  char* expiry_date,
  unsigned long max_expiry_date_size
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_get_certificate_no_buf
(
  char* certificate_no,
  unsigned long max_certificate_no_size
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_patch_buf
(
  const char* new_name,
  const char* new_stock_no,
  const char* new_ser_no,
  BOOL mark_as_modified
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_low_level_sens_buf
(
  double* sensitivities,
  unsigned long maxElements
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_s_para_info_buf
(
  NRPZXXCALCDLL_S_PARA_INFO_T* s_para_info,
  unsigned long maxElements
);

NRPZXXCALCDLL_API
unsigned long NrpZxxCalcDLL_error_text
(
  NRPZXXCALCDLL_ERROR_T error_code,
  unsigned long buffer_size,
  char* error_text
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_sensorDB_parse
(
  const char* sensorName
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_sensorDB_parse2
(
  const char* sensorName,
  const char* stockNumber
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_sensorDB_parse3
(
  const char* sensorName,
  const char* stockNumber,
  const char* attribute
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_sensorDB_query
(
  NRPZXXCALCDLL_SENSOR_PARAM_T* parameter,
  NRPZXXCALCDLL_SENSOR_PARAM_ID_T paramID,
  unsigned long index
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_init_quadratic_polynomial_table
(
  NRPZXXCALCDLL_QUADRATIC_POLY_T* poly_table,
  const NRPZXXCALCDLL_POINT_T* point_table,
  unsigned long pointCount
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_quadratic_interpolation
(
  double* pXY,
  unsigned long xyCount,
  const NRPZXXCALCDLL_QUADRATIC_POLY_T* poly_table,
  unsigned long polyCount
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_pulse_parameters
(
  double* pOvershoot,
  double* pUndershoot,
  double* pStartRising,
  double* pStartFalling,
  double* pRiseTime,
  double* pFallTime,
  const double* pSamples,
  unsigned long sampleCount,
  double lower_threshold,
  double upper_threshold
);

NRPZXXCALCDLL_API
unsigned long NrpZxxCalcDLL_warning_messages
(
  unsigned long buffer_size,
  char* warnings
);

// *** old interface ***

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T perform_generate_new
(
  const char* new_sensor_name,
  const char* new_cds_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_patch
(
  const char* new_name,
  const char* new_stock_no,
  const char* new_ser_no,
  BOOL mark_as_modified,
  const char* old_cds_name,
  const char* new_cds_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_precalibrate
(
  const char* temp_mdf_name,
  const char* lin_mdf_name,
  const char* old_cds_name,
  const char* new_cds_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T perform_calibration
(
  const char* abso_mdf_name,
  const char* refl_mdf_name,
  const char* temp_mdf_name,
  const char* lin_mdf_name,
  const char* s_para_mdf_name,
  const char* misc_mdf_name,
  const char* old_cds_name,
  const char* new_cds_name,
  const char* out_prot_name,
  const float* min_power_padded,
  const float* max_power_padded,
  const unsigned long* s_para_corr_default
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T perform_recalibration
(
  const char* abso_mdf_name,
  const char* refl_mdf_name,
  const char* lin_mdf_name,
  const char* old_cds_name,
  const char* new_cds_name,
  const char* out_prot_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T perform_merge_s_para
(
  const char* s_para_raw_name,
  const char* unc_raw_name,
  const char* old_cds_name,
  const char* new_cds_name,
  float min_power_padded,
  float max_power_padded,
  unsigned long s_para_corr_default,
  const char* spd_mnemonic
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_s_para
(
  const char* s_para_file_name,
  const char* unc_raw_name,
  const char* cal_lab,
  const char* cal_engineer,
  const char* old_cds_name,
  const char* new_cds_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_misc
(
  const char* misc_mdf_name,
  const char* old_cds_name,
  const char* new_cds_name,
  BOOL excludeDiodeParameters
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_recal_testpower
(
  const float* pTestpower,
  const char* old_cds_name,
  const char* new_cds_name
);

NRPZXXCALCDLL_API
unsigned long get_last_error_text
(
  NRPZXXCALCDLL_ERROR_T error_code,
  unsigned long buffer_size,
  char* error_text
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_visualize
(
  const char* cds_name,
  const char* vis_file_name,
  const char* out_prot_name
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T get_low_level_sens
(
  const char* cds_name,
  double* sensitivities,
  unsigned long maxElements
);

NRPZXXCALCDLL_API
NRPZXXCALCDLL_ERROR_T NrpZxxCalcDLL_s_para_info
(
  const char* cds_name,
  NRPZXXCALCDLL_S_PARA_INFO_T* s_para_info,
  unsigned long maxElements
);

#ifdef __cplusplus
}
#endif

#endif // NRPZXXCALC_DLL_H
