/*********************************************************************
 *********************************************************************

 NRPZXXCALCDLL_ERROR_T.H: defines error messages for NrpZxxCalc.dll.

 Author: Toralf Bratfisch, 1GP3

 *********************************************************************
 *********************************************************************/

#ifndef NRPZXXCALCDLL_ERROR_T_H
#define NRPZXXCALCDLL_ERROR_T_H


typedef enum NrpZxxCalcDLLErrorType
{
  no_error                  =    0, // everything fine

  // file access errors
  file_r_error              =    1, // file read access failed
  file_w_error              =    2, // file write access failed

  last_common_nrvc_error = file_w_error,

  // general errors
  memory_error              =  101, // memory allocation failed
  unmatched_error           =  102, // measurement data files do not match
  frequency_error           =  103, // frequencies for absolute calibration and reflection do not match
  argument_error            =  104, // unknown argument
  table_error               =  105, // tried to access a non-existent table entry
  int_poly_error            =  106, // unsupported interpolation polynomial type or degree
  xml_error                 =  107, // generic xml error
  dll_error                 =  108, // DLL not found or wrong DLL version
  f_monotonicity_error      =  109, // calibration frequencies must be sorted in ascending order
  t_monotonicity_error      =  110, // calibration temperatures must be sorted in ascending order
  l_monotonicity_error      =  111, // calibration levels must be sorted in ascending order

  // calibration data set errors
  cds_parse_error           =  201, // error while parsing calibration data set
  cds_size_error            =  202, // calibration data set is too large (> 128 KByte)
  cds_invalid_error         =  203, // calibration data set is invalid
  cds_signature_error       =  204, // calibration data set has wrong signature
  cds_version_error         =  205, // calibration data set has unsupported version
  cds_revision_error        =  206, // calibration data set has unsupported revision
  cds_checksum_error        =  207, // calibration data set checksum test failed
  cds_abso_uncal_error      =  208, // table of absolute calibration points is empty
  cds_refl_uncal_error      =  209, // table of reflection calibration points is empty
  cds_s_para_uncal_error    =  210, // no s-parameter device or table of s-parameter cal points is empty
  cds_convergence_error     =  211, // delinearization failed
  cds_fixed_point_error     =  212, // conversion to fixed-point format failed
  cds_incompatible_error    =  213, // feature is incompatible with this version of calibration data set

  // measurement data file errors
  mdf_parse_error           =  301, // error while parsing measurement data file
  mdf_signature_error       =  302, // measurement data file has wrong signature
  mdf_type_error            =  303, // measurement data file contains wrong type of data
  mdf_assignment_error      =  304, // assignment failure during parsing of measurement data file
  mdf_table_row_error       =  305, // table does not have expected number of rows
  mdf_table_column_error    =  306, // table does not have expected number of columns
  mdf_fkf_error             =  307, // calibration with inactive frequency correction is not supported
  mdf_unit_error            =  308, // wrong unit
  mdf_complex_error         =  309, // complex data expected
  mdf_family_error          =  310, // unknown power meter family
  mdf_lin_level_error       =  311, // linearization levels must be positive
  mdf_linpoint_nr_error     =  312, // too few linearization value pairs
  mdf_polyfit_error         =  313, // matrix is singular

  // s2p file errors
  s2p_option_line_error     =  401, // option line in s2p file not found
  s2p_parameter_error       =  402, // s2p file contains parameters other than s-parameters or uncertainty parameters

  // sensor database errors
  sensordb_argument_error   =  501, // missing sensor database name
  sensordb_parse_error      =  502, // parser error in sensor database
  sensordb_match_error      =  503, // sensor not found in sensor database
  sensordb_incon_error      =  504, // inconsistent data in sensor database (check array data!)
  sensordb_obsolete_error   =  505, // obsolete sensor database

  // errors in NRP-Z81 characterization data files
  ftl_cal_error_level_0     =  601, // calibration factor for level 0 is undefined
  ftl_cal_error_level_undef =  602, // calibration factor undefinded because of unrecoverable interpolation error
  ftl_cal_error_no_caldata  =  603, // no calibration data for this frequency/temperature/channel combination

  // interpolator errors
  interpolator_input_error  =  701, // too few points for interpolation with given degree
  interpolator_error        =  702, // interpolation failed

  // user script errors
  user_script_error_syntax  =  801, // syntax error in Lua user script
  user_script_error_runtime =  802, // runtime error in Lua user script
  user_script_error_trace   =  802  // error in user script error handler
} NRPZXXCALCDLL_ERROR_TYPE_T;

typedef struct NrpZxxCalcDLLError
{
  NRPZXXCALCDLL_ERROR_TYPE_T type;
  const char* file;
} NRPZXXCALCDLL_ERROR_T;

typedef struct NrpZxxCalcDLLErrorMapping
{
  NRPZXXCALCDLL_ERROR_TYPE_T type;
  const char* text;
} NRPZXXCALCDLL_ERROR_MAPPING;

#define NRPZXXCALCDLL_UNKNOWN_ERROR_MSG "An unknown error occured!"

#define NRPZXXCALCDLL_ERROR_MSG {                                                                                                              \
  { no_error                  , "No error occurred."                                                                                        }, \
  { file_r_error              , "File read access failed!"                                                                                  }, \
  { file_w_error              , "File write access failed!"                                                                                 }, \
  { memory_error              , "Memory allocation failed!"                                                                                 }, \
  { unmatched_error           , "You can't mix measurement data files for different sensors!"                                               }, \
  { frequency_error           , "Measurement frequencies for absolute calibration and reflection don't match!"                              }, \
  { argument_error            , "Missing or wrong argument(s)!"                                                                             }, \
  { table_error               , "Invalid access on table entry!"                                                                            }, \
  { int_poly_error            , "Unsupported type or degree of interpolation polynomial for linearization!"                                 }, \
  { xml_error                 , "Generic XML error!"                                                                                        }, \
  { dll_error                 , "DLL not found or wrong DLL version!"                                                                       }, \
  { f_monotonicity_error      , "Calibration frequencies must be sorted in ascending order!"                                                }, \
  { t_monotonicity_error      , "Calibration temperatures must be sorted in ascending order!"                                               }, \
  { l_monotonicity_error      , "Calibration levels must be sorted in ascending order!"                                                     }, \
  { cds_parse_error           , "Calibration data set could not be parsed!"                                                                 }, \
  { cds_size_error            , "Generated calibration data set is too large!"                                                              }, \
  { cds_invalid_error         , "Calibration data set is invalid!"                                                                          }, \
  { cds_signature_error       , "Calibration data set has wrong signature!"                                                                 }, \
  { cds_version_error         , "Calibration data set has unsupported version!"                                                             }, \
  { cds_revision_error        , "Calibration data set has unsupported revision!"                                                            }, \
  { cds_checksum_error        , "Calibration data set checksum test failed!"                                                                }, \
  { cds_abso_uncal_error      , "You must add at least one absolute calibration point! Storing was cancelled!"                              }, \
  { cds_refl_uncal_error      , "You must add at least one reflection calibration point! Storing was cancelled!"                            }, \
  { cds_s_para_uncal_error    , "You must add at least one s-parameter device and one calibration point per device! Storing was cancelled!" }, \
  { cds_convergence_error     , "Delinearization failed because algorithm did not converge!"                                                }, \
  { cds_fixed_point_error     , "Conversion to fixed-point format failed!"                                                                  }, \
  { cds_incompatible_error    , "Feature is incompatible with this version of calibration data set!"                                        }, \
  { mdf_parse_error           , "Measurement data file could not be parsed!"                                                                }, \
  { mdf_signature_error       , "Measurement data file has wrong signature!"                                                                }, \
  { mdf_type_error            , "Measurement data file contains wrong type of data!"                                                        }, \
  { mdf_assignment_error      , "Missing variable(s)!"                                                                                      }, \
  { mdf_table_row_error       , "Number of rows in value table does not match DataPoints!"                                                  }, \
  { mdf_table_column_error    , "Number of columns in value table does not match ValuesPerPoint!"                                           }, \
  { mdf_fkf_error             , "Calibration with inactive frequency correction is not supported!"                                          }, \
  { mdf_unit_error            , "Wrong unit!"                                                                                               }, \
  { mdf_complex_error         , "Reflection coefficient must be complex!"                                                                   }, \
  { mdf_family_error          , "Wrong power meter family!"                                                                                 }, \
  { mdf_lin_level_error       , "Linearization levels must be positive!"                                                                    }, \
  { mdf_linpoint_nr_error     , "The number of linearization value pairs must not be smaller than the polynomial degree!"                   }, \
  { mdf_polyfit_error         , "Polynomial fit failed because matrix is singular!"                                                         }, \
  { s2p_option_line_error     , "S2P file option line corrupt or not found!"                                                                }, \
  { s2p_parameter_error       , "S2P file contains wrong parameter type!"                                                                   }, \
  { sensordb_argument_error   , "Missing sensor database name!"                                                                             }, \
  { sensordb_parse_error      , "Parser error in sensor database!"                                                                          }, \
  { sensordb_match_error      , "Sensor not found in sensor database!"                                                                      }, \
  { sensordb_incon_error      , "Sensor database contains inconsistent data!"                                                               }, \
  { sensordb_obsolete_error   , "Sensor database is obsolete!"                                                                              }, \
  { ftl_cal_error_level_0     , "Frequency/temperature/level calibration factor for level = 0 is undefined!"                                }, \
  { ftl_cal_error_level_undef , "Frequency/temperature/level calibration factor undefined because of unrecoverable interpolation error!"    }, \
  { ftl_cal_error_no_caldata  , "No calibration data is available for this frequency/temperature/channel combination!"                      }, \
  { interpolator_input_error  , "Too few points for interpolation with given degree!"                                                       }, \
  { interpolator_error        , "Interpolation failed!"                                                                                     }, \
  { user_script_error_syntax  , "Syntax error in user script!"                                                                              }, \
  { user_script_error_runtime , "Runtime error in user script!"                                                                             }, \
  { user_script_error_trace   , "Error in user script error handler!"                                                                       }  \
}

#ifdef __cplusplus

/*********************************************************************
 Throws an exception of type NrpZxxCalcDLLError.
 *********************************************************************/
inline
void ThrowError( NrpZxxCalcDLLErrorType type, const char* pFileName = 0 )
{
  NrpZxxCalcDLLError e = { type, pFileName };
  throw e;
}

#endif // __cplusplus

#endif // NRPZXXCALCDLL_ERROR_T_H
