/*********************************************************************
 *********************************************************************

 NRPZXXCALCDLL_CONFIG_T.h: defines Type NRPZXXCALCDLL_CONFIG_T for
 NRP_Z21_Calc and NrpZxxCalc.dll

 Author: Toralf Bratfisch, 1GP3

 *********************************************************************
 *********************************************************************/

#ifndef NRPZXXCALCDLL_CONFIG_T_H
#define NRPZXXCALCDLL_CONFIG_T_H


#ifndef BOOL
typedef int BOOL;
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


typedef struct tag_NRPZXXCALCDLL_CONFIG_T
{
  const char *sensordb;             // alternative sensor database path (path is not changed if NULL is passed)

  struct NRPZXXCALCDLL_TESTFLAGS_T
  {
    BOOL suppressUnmatchedError;    // no sensor name/stocknumber/serial number checking in files
    BOOL suppressFixedPointError;   // no error message if calibration factor cannot be represented in internal
                                    // fixed-point format - calibration factor is clipped instead
    BOOL suppressFrequencyError;    // allow different frequencies for absolut calibration factors
                                    // and reflection coefficients
    BOOL enableLogging;             // enable output of logfile
  } testflags;
} NRPZXXCALCDLL_CONFIG_T;

#define NRPZXXCALCDLL_DEFAULT_CONFIG  { "sensordb.xml", FALSE, FALSE, FALSE, FALSE }

#endif  // NRPZXXCALCDLL_CONFIG_T_H
