VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ListSubFoldersAndFiles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Dim IncFiles As Boolean, IncFolders As Boolean

Public Function ListSubFoldersAndFiles(ByVal RootPath As String, ByVal IncludeFiles As Boolean, ByVal IncludeFolders As Boolean) As String()
    Dim StrList As StringList
    Set StrList = New StringList
    
    IncFiles = IncludeFiles
    IncFolders = IncludeFolders
    
    If Not IncFiles And Not IncFolders Then
        Err.Description = "Method ""ListSubFoldersAndFiles"" called with paramaters ""IncludeFiles"" and ""IncludeFolders"" both set to False.  At least 1 option must be set to true."
        Err.Raise 1
    End If
    
    ListSubFoldersContents RootPath, StrList
    
    ListSubFoldersAndFiles = StrList.GetList
    Set StrList = Nothing
End Function

Private Sub ListSubFoldersContents(ByVal Path As String, ByRef StrList As StringList)
    Dim fso As Scripting.FileSystemObject
    Dim fsoFolder As Scripting.Folder
    Dim objFile As Scripting.File
    Dim objFolder As Scripting.Folder
    Dim FolderName As String
    
    Set fso = New Scripting.FileSystemObject
    Set fsoFolder = fso.GetFolder(Path)
    
    If Right(Path, 1) = "\" Then PathSeperator = "" Else PathSeperator = "\"
    
    If IncFiles Then
        For Each objFile In fsoFolder.Files
            StrList.AddItem Path & PathSeperator & objFile.Name
        Next objFile
    End If
    For Each objFolder In fsoFolder.SubFolders
        FolderName = Path & PathSeperator & objFolder.Name
        If IncFolders Then
            StrList.AddItem FolderName
        End If
        ListSubFoldersContents FolderName, StrList
    Next objFolder
End Sub
