using System;
using System.Windows.Forms;

namespace GlomEvents
{
	/// <summary>
	/// Subscribes a single events to multiple sources.
	/// </summary>
	public class ConglomerateEvents
	{
		public ConglomerateEvents() {}

		// Button click.
		public void SubscribeToBtnClick(Button source)
		{
			// Subscribes our handler to the source's Click event.
			source.Click += new EventHandler(BtnClickHandler);
		}
		public delegate void GotBtnClick(object sender, EventArgs e);
		public event GotBtnClick BtnClick;
		void BtnClickHandler(object sender, EventArgs e) {BtnClick(sender, e);}

		
		// ComboBox TextChanged
		public void SubscribeToComboTextChanged(ComboBox source)
		{
			// Subscribes our handler to the source's Click event.
			source.TextChanged += new EventHandler(ComboTextChangedHandler);
		}
		public delegate void GotComboTextChanged(object sender, EventArgs e);
		public event GotComboTextChanged ComboTextChanged;
		void ComboTextChangedHandler(object sender, EventArgs e) {ComboTextChanged(sender, e);}

		
		// NumericUpDown TextChanged
		public void SubscribeToUpDnTextChanged(NumericUpDown source)
		{
			// Subscribes our handler to the source's Click event.
			source.TextChanged += new EventHandler(UpDnTextChangedHandler);
		}
		public delegate void GotUpDnTextChanged(object sender, EventArgs e);
		public event GotUpDnTextChanged UpDnTextChanged;
		void UpDnTextChangedHandler(object sender, EventArgs e) {UpDnTextChanged(sender, e);}

	}
}
