// Windows defines.
#define STRICT							1	//Use strict type checking.
#define WIN32_LEAN_AND_MEAN	1	//Make it small.

// Get wisdom from Microsoft.
#include <windows.h>

// Just to save some typing.
#define DllExport __declspec(dllexport)

// If this gets compiled as C++, don't mangle export names.
#ifdef __cplusplus
extern "C" {
#endif

// These are the two methods we're exporting.
DllExport	int	GetDrivesUsingQDD(char **ppDrives);
DllExport	int	GetDrivesUsingGDT(char **ppDrives);

// Stop unmangling.
#ifdef __cplusplus
}
#endif

/////////////////////////////////////////////////////////////////////////////
// GLOBALS.
char	szDriveQueryFmt[]		= "%c:\\";	//Format used to call GetDriveType.
char	szDriveReportFmt[]	= "%s%d";		//Format used to report drive types.

/////////////////////////////////////////////////////////////////////////////
// ENTRY POINT.
BOOL WINAPI DllMain(HINSTANCE hInst, DWORD dwReason, LPVOID lpReserved)
{return TRUE;}

/////////////////////////////////////////////////////////////////////////////
// Exported functions.
DllExport int GetDrivesUsingQDD(char **ppDrives)
{
	int		iNumDevices;
	char	buf[1024];
	char	*pDevice;

	// Init.
	pDevice			= buf;
	iNumDevices	= 0;

	// Make sure call works.
	if(QueryDosDevice(NULL, buf, sizeof(buf))) {

		// Pick off devices.
		while(*pDevice) {

			// Make sure there's enough room to copy device name.
			if(lstrlen(pDevice) <= lstrlen(ppDrives[iNumDevices]) + 1)
				lstrcpy(ppDrives[iNumDevices++], pDevice);

			// Next device.
			pDevice += lstrlen(pDevice) +	1;
		}
	}

	return iNumDevices;
}

DllExport int GetDrivesUsingGDT(char **ppDrives)
{
	int		iDrive;
	UINT	uDriveType;
	char	buf[4];

	// Test all drives.
	for(iDrive = 0; iDrive < 26; iDrive++) {

		// Construct a root path.
		wsprintf(buf, szDriveQueryFmt, 'A' + iDrive);

		// Check type.
		uDriveType = GetDriveType(buf);

		// Make sure there's enough room to copy path name & type.
		if(lstrlen(ppDrives[iDrive]) >= 5)
			wsprintf(ppDrives[iDrive], szDriveReportFmt, buf, uDriveType);
	}

	return iDrive;
}

