#define STRICT
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <commdlg.h>
#include <commctrl.h>

#define DllExport __declspec(dllexport)

CHAR					*gpTitle = "Select File";
CHAR					gpFile[MAX_PATH];
UINT_PTR			guiTimer = 0;
HINSTANCE			ghInst = NULL;
OPENFILENAME	gOfn;

BOOL WINAPI DllMain(HINSTANCE hInst, DWORD dwReason, LPVOID lpReserved)
{
	switch(dwReason) {
		case DLL_PROCESS_ATTACH: ghInst = hInst;
		case DLL_PROCESS_DETACH: ghInst = NULL;
	}
	return TRUE;
}

VOID CALLBACK TimerProc(HWND hWnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
	HWND	hParent = NULL;
	HWND	hToolbar = NULL;
	RECT	rc;

	// First, kill this timer.
	KillTimer(NULL, idEvent);

	// Find the toolbar.
	hParent = FindWindow(NULL, gpTitle);
	hToolbar = FindWindowEx(hParent, NULL, "ToolbarWindow32", NULL);

	// Get view menu button stuff & press button.
	SendMessage(hToolbar, TB_GETITEMRECT, (WPARAM)3, (LPARAM)&rc);
	SendMessage(hToolbar, WM_LBUTTONDOWN, MK_LBUTTON, MAKELPARAM(rc.left + 5, rc.top + 5));
}

UINT_PTR CALLBACK HookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	HWND	hParent = NULL;
	HWND	hToolbar = NULL;

	LPOFNOTIFY	pNotify = (LPOFNOTIFY)lParam;

	// Wait for CDN_INITDONE message.
	if(uiMsg == WM_NOTIFY) {
		if(pNotify->hdr.code == CDN_INITDONE) {

			// Set a timer for a brief while.
			guiTimer = SetTimer(NULL, 0, 50, (TIMERPROC)TimerProc);
		}
	}
	return 0;
}

DllExport BOOL SelectFile(char *pFileName)
{
	// Initialize OFN.
	ZeroMemory(&gOfn, sizeof(gOfn));
	gOfn.lStructSize = sizeof(gOfn);
	gOfn.hInstance = ghInst;
	gOfn.lpstrFile = gpFile;
	gOfn.lpstrTitle = gpTitle;
	gOfn.nMaxFile = MAX_PATH;
	gOfn.Flags = OFN_ENABLEHOOK | OFN_EXPLORER;
	gOfn.lpfnHook = HookProc;

	// Display the dialog.
	GetOpenFileName(&gOfn);

	// Copy return value to VEE & return.
	lstrcpy(pFileName, gpFile);
	return TRUE;
}
