/****************************************************************************
*                       Agilent Arbitrary Waveform Generator                           
*---------------------------------------------------------------------------
*   Copyright (c) Agilent Technologies 2004,2005. All Rights Reserved.      
*---------------------------------------------------------------------------
*                                                                          
* Title:    AGN6030A_VEE.h                                        
* Purpose:  Agilent Arbitrary Waveform Generator                                       
*           instrument driver declarations. This version of the file
*  		contains hard-coded numbers for attributes and values for use
*		with Agilent VEE. Be sure to read comments in the standard
*		IVI include file, AGN6030A.h                               
*                                                                          
****************************************************************************/

#ifndef __AGN6030A_HEADER
#define __AGN6030A_HEADER

#include <ivi.h>
#include <ivifgen.h>

/* ??? not found in main function
  #ifdef __BUILD_AGN6030A_DRIVER__
  #define  __declspec(dllexport)
  #else
  #define 
  #endif
*/

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif
	
/****************************************************************************
*----------------- Instrument Driver Revision Information -----------------*
****************************************************************************/

#define AGN6030A_MAJOR_VERSION                1     /* Instrument driver major version   */
#define AGN6030A_MINOR_VERSION                7     /* Instrument driver minor version   */
	
#define AGN6030A_CLASS_SPEC_MAJOR_VERSION     2     /* Class specification major version */
#define AGN6030A_CLASS_SPEC_MINOR_VERSION     0     /* Class specification minor version */
	
#define AGN6030A_SUPPORTED_INSTRUMENT_MODELS  "N6030A"
#define AGN6030A_DRIVER_VENDOR                "Agilent Technologies, Inc."
#define AGN6030A_DRIVER_DESCRIPTION           "IVI-C Driver for N6030A Arbitrary Waveform Generator"
		
/**************************************************************************** 
*------------------------------ Useful Macros -----------------------------* 
****************************************************************************/
		
/**************************************************************************** 
*---------------------------- Attribute Defines ---------------------------* 
****************************************************************************/
	
/*- IVI Inherent Instrument Attributes ---------------------------------*/	  
	
/* User Options */
#define AGN6030A_ATTR_RANGE_CHECK                   1050002  /* ViBoolean */
#define AGN6030A_ATTR_QUERY_INSTR_STATUS            1050003  /* ViBoolean */
#define AGN6030A_ATTR_CACHE                         1050004  /* ViBoolean */
#define AGN6030A_ATTR_SIMULATE                      1050005  /* ViBoolean */
#define AGN6030A_ATTR_RECORD_COERCIONS              1050006  /* ViBoolean */
	
/* Instrument Capabilities */
#define AGN6030A_ATTR_CHANNEL_COUNT                 1050203  /* ViInt32,  read-only  */   
#define AGN6030A_ATTR_NUM_CHANNELS                  1050203  /* ViInt32,  read-only  */

/* Driver Information  */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_PREFIX        1050302  /* ViString, read-only  */
#define AGN6030A_ATTR_SUPPORTED_INSTRUMENT_MODELS   1050327  /* ViString, read-only  */
#define AGN6030A_ATTR_GROUP_CAPABILITIES            1050401  /* ViString, read-only  */
#define AGN6030A_ATTR_INSTRUMENT_MANUFACTURER       1050511  /* ViString, read-only  */
#define AGN6030A_ATTR_INSTRUMENT_MODEL              1050512  /* ViString, read-only  */
#define AGN6030A_ATTR_INSTRUMENT_FIRMWARE_REVISION  1050510  /* ViString, read-only  */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION 1050503  /* ViInt32,  read-only  */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_MINOR_VERSION 1050504  /* ViInt32,  read-only  */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_REVISION      1050551  /* ViString, read-only  */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_VENDOR        1050513  /* ViString, read-only  */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_DESCRIPTION   1050514  /* ViString, read-only  */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION 1050515 /* ViInt32, read-only */
#define AGN6030A_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION 1050516 /* ViInt32, read-only */

/* Error Info */
#define AGN6030A_ATTR_PRIMARY_ERROR                 1050101  /* ViInt32  */
#define AGN6030A_ATTR_SECONDARY_ERROR               1050102  /* ViInt32  */
#define AGN6030A_ATTR_ERROR_ELABORATION             1050103  /* ViString */
	
/* Advanced Session Information */
#define AGN6030A_ATTR_LOGICAL_NAME                  1050305  /* ViString, read-only  */
#define AGN6030A_ATTR_RESOURCE_DESCRIPTOR           1050304  /* ViString, read-only  */
#define AGN6030A_ATTR_IO_SESSION                    1050322  /* ViSession, read-only */
#define AGN6030A_ATTR_IO_SESSION_TYPE               1050324  /* ViSession, read-only */
#define AGN6030A_ATTR_DRIVER_SETUP                  1050007  /* ViString */
#define AGN6030A_ATTR_INTERCHANGE_CHECK             1050021  /* ViBoolean */
/* ???: ATR_IO_RESOURCE_DESCRIPTOR, ATTR_QUERY_INSTRUMENT_STATUS */

/*- Instrument-Specific Attributes -------------------------------------*/
	
/*- Basic Instrument Operation -----------------------------------------*/
#define AGN6030A_ATTR_OUTPUT_MODE              1250001  /* ViInt32                        */
#define AGN6030A_ATTR_REF_CLOCK_SOURCE         1250002  /* ViInt32                        */
#define AGN6030A_ATTR_OUTPUT_ENABLED           1250003  /* ViBoolean, multi-channel       */
#define AGN6030A_ATTR_OUTPUT_IMPEDANCE         1250004  /* ViReal64,  multi-channel, ohms */
#define AGN6030A_ATTR_OPERATION_MODE           1250005  /* ViInt32,   multi-channel       */
	
/*- Arbitrary Waveform Generation --------------------------------------*/
#define AGN6030A_ATTR_ARB_WAVEFORM_HANDLE  1250201  /* ViInt32,  multi-channel         */
#define AGN6030A_ATTR_ARB_GAIN             1250202  /* ViReal64, multi-channel         */
#define AGN6030A_ATTR_ARB_OFFSET           1250203  /* ViReal64, multi-channel, volts  */
#define AGN6030A_ATTR_ARB_SAMPLE_RATE      1250204  /* ViReal64, samples-per-second    */
#define AGN6030A_ATTR_MAX_NUM_WAVEFORMS    1250205  /* ViInt32,  read-only             */
#define AGN6030A_ATTR_WAVEFORM_QUANTUM     1250206  /* ViInt32,  read-only             */
#define AGN6030A_ATTR_MIN_WAVEFORM_SIZE    1250207  /* ViInt32,  read-only             */
#define AGN6030A_ATTR_MAX_WAVEFORM_SIZE    1250208  /* ViInt32,  read-only             */
	
/*- Arbitrary Sequence Generation --------------------------------------*/
#define AGN6030A_ATTR_ARB_SEQUENCE_HANDLE  1250211  /* ViInt32, multi-channel */
#define AGN6030A_ATTR_MAX_NUM_SEQUENCES    1250212  /* ViInt32, read-only */
#define AGN6030A_ATTR_MIN_SEQUENCE_LENGTH  1250213  /* ViInt32, read-only */
#define AGN6030A_ATTR_MAX_SEQUENCE_LENGTH  1250214  /* ViInt32, read-only */
#define AGN6030A_ATTR_MAX_LOOP_COUNT       1250215  /* ViInt32, read-only */
	
/*- Trigger Configuration ----------------------------------------------*/
#define AGN6030A_ATTR_TRIGGER_SOURCE  1250302  /* ViInt32, multi-channel */

/*- Burst Configuration ------------------------------------------------*/
#define AGN6030A_ATTR_BURST_COUNT  1250350  /* ViInt32, multi-channel */

#define AGN6030A_ATTR_PXI_MANF_ID	    (1150001)	/* ViInt32, read-only			*/
#define AGN6030A_ATTR_PXI_MODEL_CODE	    (1150002)	/* ViInt32, read-only			*/
#define AGN6030A_ATTR_OUTPUT_BANDWIDTH      (1150003)	/* ViReal64, multi-channel		*/
#define AGN6030A_ATTR_OUTPUT_FILTER_ENABLED (1150004)	/* ViBoolean, multi-channel		*/
#define AGN6030A_ATTR_OUTPUT_CONFIGURATION  (1150005)	/* ViInt32, multi-channel		*/
#define AGN6030A_ATTR_CLOCK_SOURCE          (1150006)	/* ViInt32, read-only			*/
#define AGN6030A_ATTR_CLOCK_FREQUENCY       (1150024)	/* ViReal64, read-only			*/
#define AGN6030A_ATTR_SYNC_ENABLED          (1150007)	/* ViBoolean */
#define AGN6030A_ATTR_SYNC_MODE             (1150008)	/* ViReal64,	multi-channel		*/
/* ??? old defines, not found in modern file, NOT SUPPORTED */
/*
  #define AGN6030A_ATTR_SEQUENCE_ID_SOURCE (1150009)  
  #define AGN6030A_ATTR_SEQUENCE_JUMP_MODE (1150010)	
  #define AGN6030A_ATTR_SEQUENCE_PLAY_MODE (1150011)	
*/
#define AGN6030A_ATTR_SCENARIO_ID_SOURCE (1150009)
#define AGN6030A_ATTR_STOP_TRIGGER_SOURCE (1150012)  /* NOT SUPPORTED */
#define AGN6030A_ATTR_ACTIVE_MARKER       (1150017)  /* ViString	"1" through "4" are valid */
#define AGN6030A_ATTR_MARKER_SOURCE       (1150013)  /* ViInt32	*/
#define AGN6030A_ATTR_MARKER_DELAY        (1150018)  /* ViReal64, applies to active mkr	*/
#define AGN6030A_ATTR_MARKER_PULSE_WIDTH  (1150019)  /* ViReal64, applies to active mkr	*/
#define AGN6030A_ATTR_MARKER_POLARITY     (1150027)  /* ViBoolean, VI_TRUE for active high, applies to active marker */
#define AGN6030A_ATTR_TRIGGER_THRESHOLD_A (1150020)  /* ViReal64, in volts				*/
#define AGN6030A_ATTR_TRIGGER_THRESHOLD_B (1150021)  /* ViReal64, in volts				*/
#define AGN6030A_ATTR_ACTIVE_TRIGGER      (1150022)  /* ViString, "1" through "4" are valid */
#define AGN6030A_ATTR_TRIGGER_POLARITY    (1150023)  /* ViBoolean, VI_TRUE for positive edge, applies to active trigger */
#define AGN6030A_ATTR_ARB_OFFSET_MIN      (1150025)  /* ViReal64, multi-channel, read-only */
#define AGN6030A_ATTR_ARB_OFFSET_MAX      (1150026)  /* ViReal64, multi-channel, read-only */

/* Predistortion */
#define AGN6030A_ATTR_PREDISTORTION_ENABLED   (1150028)  /* ViBoolean */
#define AGN6030A_ATTR_PREDISTORTION_SCALE     (1150029)
#define AGN6030A_ATTR_PREDISTORTION_BANDWIDTH (1150030)
#define AGN6030A_ATTR_PREDISTORTION_VALID     (1150045)
#define AGN6030A_ATTR_PREDISTORTION_AUTOSCALE (1150037)

/* Advanced Sequencing */
#define AGN6030A_ATTR_HOLD_TRIGGER_SOURCE          (1150031)
#define AGN6030A_ATTR_RESUME_TRIGGER_SOURCE        (1150032)
#define AGN6030A_ATTR_WFM_ADV_TRIGGER_SOURCE       (1150033)
#define AGN6030A_ATTR_WFM_JUMP_TRIGGER_SOURCE      (1150034)
#define AGN6030A_ATTR_SCENARIO_ADV_TRIGGER_SOURCE  (1150035)
#define AGN6030A_ATTR_SCENARIO_JUMP_TRIGGER_SOURCE (1150036)
#define AGN6030A_ATTR_MAX_NUM_SCENARIOS            (1150038)
#define AGN6030A_ATTR_MIN_SCENARIO_LENGTH          (1150039)
#define AGN6030A_ATTR_MAX_SCENARIO_LENGTH          (1150040)
#define AGN6030A_ATTR_MAX_SCENARIO_LOOP_COUNT      (1150041)
#define AGN6030A_ATTR_ARB_SCENARIO_HANDLE          (1150042)
#define AGN6030A_ATTR_SCENARIO_PLAY_MODE           (1150043)
#define AGN6030A_ATTR_SCENARIO_JUMP_MODE           (1150044)

//add Oct07
#define AGN6030A_ATTR_DDS_ENABLED				   (1150055)	//(IVI_SPECIFIC_PUBLIC_ATTR_BASE + 55L)  


/**************************************************************************** 
*------------------------ Attribute Value Defines -------------------------* 
****************************************************************************/
/*- Defined values for attribute AGN6030A_ATTR_OPERATION_MODE --------------*/

#define AGN6030A_VAL_OPERATE_CONTINUOUS    0
#define AGN6030A_VAL_OPERATE_BURST         1

/*- Defined values for attribute AGN6030A_ATTR_OUTPUT_MODE --------------*/

#define AGN6030A_VAL_OUTPUT_ARB            1
#define AGN6030A_VAL_OUTPUT_SEQ            2

#define AGN6030A_VAL_OUTPUT_ADV_SEQ        (1001)

/*- Defined values for attribute AGN6030A_ATTR_REF_CLOCK_SOURCE ------*/

#define AGN6030A_VAL_REF_CLOCK_INTERNAL       0
#define AGN6030A_VAL_REF_CLOCK_EXTERNAL       1

#define AGN6030A_VAL_REF_CLOCK_PXI  (1001)   

/*- Defined values for Arbitrary Waveform Handles ---------------------------------*/

#define AGN6030A_VAL_ALL_WAVEFORMS         -1

/*- Defined values for attribute AGN6030A_ATTR_ARB_WAVEFORM_HANDLE ---*/

#define AGN6030A_VAL_ALL_SEQUENCES         -1
#define AGN6030A_VAL_ALL_SCENARIOS         -1

/*- Defined values for attribute AGN6030A_ATTR_TRIGGER_SOURCE --------*/

#define AGN6030A_VAL_EXTERNAL                      1
#define AGN6030A_VAL_SOFTWARE_TRIG                 2

#define AGN6030A_VAL_TRIG_FLAG_BASE (1024)
#define AGN6030A_VAL_NOTRIG_FLAG    (1024)
#define AGN6030A_VAL_SOFTWARE_FLAG  (1025)
#define AGN6030A_VAL_EXTERNAL1_FLAG (1026) 
#define AGN6030A_VAL_EXTERNAL2_FLAG (1028) 
#define AGN6030A_VAL_EXTERNAL3_FLAG (1032) 
#define AGN6030A_VAL_EXTERNAL4_FLAG (1040) 
#define AGN6030A_VAL_SOFTWARE1_FLAG (1025)
#define AGN6030A_VAL_SOFTWARE2_FLAG (1056)
#define AGN6030A_VAL_SOFTWARE3_FLAG (1088)
#define AGN6030A_VAL_MARKER1_FLAG   (1280)
#define AGN6030A_VAL_MARKER2_FLAG   (1536)
#define AGN6030A_VAL_MARKER3_FLAG   (2048)
#define AGN6030A_VAL_MARKER4_FLAG   (3072)
#define AGN6030A_VAL_AUX_PORT_FLAG  (5120)
#define AGN6030A_VAL_TRIG_FLAG_MAX  (9215)

/* Instrument specific attribute value definitions */

/* AGN6030A_ATTR_OUTPUT_CONFIGURATION settings */
#define AGN6030A_VAL_CONFIGURATION_DIFFERENTIAL  0
#define AGN6030A_VAL_CONFIGURATION_SINGLE_ENDED  1
#define AGN6030A_VAL_CONFIGURATION_AMPLIFIED     2


/* AGN6030A_ATTR_SYNC_MODE settings */
#define AGN6030A_VAL_SYNC_MASTER  0
#define AGN6030A_VAL_SYNC_SLAVE   1

/* AGN6030A_ATTR_CLOCK_SOURCE settings */
#define AGN6030A_VAL_CLOCK_INTERNAL  0
#define AGN6030A_VAL_CLOCK_EXTERNAL  1

/* ??? these are not defined in AGN6030A.h
  #define AGN6030A_VAL_DATA15  149
  #define AGN6030A_VAL_DATA16  150
  #define AGN6030A_VAL_JUMP_END                                       1
  #define AGN6030A_VAL_DATA_PORT                                      2
*/

/* AGN6030A_ATTR_SCENARIO_ID_SOURCE */
#define AGN6030A_VAL_ID_SOFTWARE  0
/* ??? prior definition was #define AGN6030A_VAL_ID_ALL       1  */
#define AGN6030A_VAL_ID_AUX_PORT  1

/* AGN6030A_ATTR_SCENARIO_JUMP_MODE */
#define AGN6030A_VAL_JUMP_IMMEDIATE     0
#define AGN6030A_VAL_JUMP_END_WFM       1
#define AGN6030A_VAL_JUMP_END_SCENARIO  2

/* AGN6030A_ATTR_SCENARIO_PLAY_MODE */
#define AGN6030A_VAL_PLAY_SINGLE      0
#define AGN6030A_VAL_PLAY_CONTINUOUS  1

#define AGN6030A_VAL_MARKER_OFF         0
#define AGN6030A_VAL_MARKER_SOFTWARE    1
#define AGN6030A_VAL_CH1_M1               2
#define AGN6030A_VAL_CH1_M2               3
#define AGN6030A_VAL_CH2_M1               4
#define AGN6030A_VAL_CH2_M2               5
//add Oct07
#define AGN6030A_VAL_MARKER_DDS_WFM_START 6
#define AGN6030A_VAL_MARKER_SCENARIO_REP  7
#define AGN6030A_VAL_MARKER_WFM_START     9
#define AGN6030A_VAL_MARKER_WFM_REP       10
#define AGN6030A_VAL_MARKER_WFM_GATE      11
#define AGN6030A_VAL_MARKER_SEQ_START     12
#define AGN6030A_VAL_MARKER_SEQ_REP       13
#define AGN6030A_VAL_MARKER_SEQ_GATE      14

/* ??? these are not defined in AGN6030A.h
#define AGN6030A_VAL_TRIGGER_NEGATIVE                               0
#define AGN6030A_VAL_TRIGGER_POSITIVE                               1
*/

/**************************************************************************** 
*---------------- Instrument Driver Function Declarations -----------------* 
****************************************************************************/

/*- Init and Close Functions -------------------------------------------*/
 ViStatus _VI_FUNC  AGN6030A_init (ViRsrc resourceName, ViBoolean IDQuery,
                                  ViBoolean resetDevice, ViSession *vi);
 ViStatus _VI_FUNC  AGN6030A_InitWithOptions (ViRsrc resourceName, ViBoolean IDQuery,
                                             ViBoolean resetDevice, ViString optionString, 
                                             ViSession *newVi);
 ViStatus _VI_FUNC  AGN6030A_close (ViSession vi);   

/*- Coercion Info Functions --------------------------------------------*/
 ViStatus _VI_FUNC  AGN6030A_GetNextCoercionRecord (ViSession vi,
                                                   ViInt32 bufferSize,
                                                   ViChar record[]);

/*- Locking Functions --------------------------------------------------*/
 ViStatus _VI_FUNC  AGN6030A_LockSession (ViSession vi, ViBoolean *callerHasLock);   
 ViStatus _VI_FUNC  AGN6030A_UnlockSession (ViSession vi, ViBoolean *callerHasLock);


/*- Basic Instrument Operation -----------------------------------------*/

 ViStatus _VI_FUNC AGN6030A_ConfigureOperationMode (ViSession vi, 
                                                   ViConstString channelName,
                                                   ViInt32 outputMode);

 ViStatus _VI_FUNC AGN6030A_ConfigureOutputMode (ViSession vi, ViInt32 outputMode);

 ViStatus _VI_FUNC AGN6030A_ConfigureOutputConfiguration (ViSession instrumentHandle,
                                                         ViChar channelName[],
                                                         ViInt32 outputConfiguration,
                                                         ViBoolean outputFilterEnabled,
                                                         ViReal64 outputFilterBandwidth);

 ViStatus _VI_FUNC AGN6030A_ConfigureRefClockSource (ViSession vi,
													ViInt32 refClockSource);

 ViStatus _VI_FUNC AGN6030A_ConfigureOutputImpedance (ViSession vi,
													 ViConstString channelName,
													 ViReal64 outputImpedance);

 ViStatus _VI_FUNC AGN6030A_ConfigureOutputEnabled (ViSession vi, 
                                                   ViConstString channelName,
                                                   ViBoolean enabled);

 ViStatus _VI_FUNC AGN6030A_InitiateGeneration (ViSession vi);

 ViStatus _VI_FUNC AGN6030A_AbortGeneration (ViSession vi);

/*- Arbitrary Waveform Output -------------------------------------------*/

 ViStatus _VI_FUNC AGN6030A_QueryArbWfmCapabilities (ViSession vi,
                                                    ViInt32 *maxNumWfms,
                                                    ViInt32 *wfmQuantum,
                                                    ViInt32 *minWfmSize,
                                                    ViInt32 *maxWfmSize);

 ViStatus _VI_FUNC  AGN6030A_CreateArbWaveform (ViSession vi,
                                               ViInt32 wfmSize,
                                               ViReal64 wfmData[],
                                               ViInt32 *wfmHandle);

 ViStatus _VI_FUNC AGN6030A_ConfigureClockSync (ViSession instrumentHandle,
                                               ViBoolean clockSynchronizationEnabled,
                                               ViInt32 synchronizationMode);

 ViStatus _VI_FUNC  AGN6030A_ConfigureSampleClock (ViSession vi, ViInt32 source, ViReal64 frequency);

 ViStatus _VI_FUNC  AGN6030A_ConfigureSampleRate (ViSession vi, ViReal64 sampleRate);

 ViStatus _VI_FUNC AGN6030A_CreateArbWaveformWithMarkers (ViSession	instrumentHandle,
                                                         ViInt32	waveformSize,
                                                         ViReal64	waveformDataArray[],
														 ViInt32	markerSize,
                                                         char		markerDataArray[],
                                                         ViInt32	*waveformHandle  );


 ViStatus _VI_FUNC AGN6030A_CreateArbWaveformRaw(		ViSession	instrumentHandle,
                                                         ViInt32	waveformSize,
                                                         ViInt16	waveformDataArray[],
														 ViInt32	markerSize,
                                                         char		markerDataArray[],
                                                         ViInt32	*waveformHandle  );


 ViStatus _VI_FUNC  AGN6030A_ConfigureArbWaveform (ViSession vi,
                                                  ViConstString channelName,
                                                  ViInt32 wfmHandle,
                                                  ViReal64 arbGain,
                                                  ViReal64 arbOffset);

 ViStatus _VI_FUNC  AGN6030A_ClearArbWaveform (ViSession vi, ViInt32 wfmHandle);

/*- Arbitrary Sequence Output -------------------------------------------*/

 ViStatus _VI_FUNC AGN6030A_QueryArbSeqCapabilities (ViSession vi,
                                                    ViInt32 *maxNumSeqs,
                                                    ViInt32 *minSeqLength,
                                                    ViInt32 *maxSeqLength,
                                                    ViInt32 *maxLoopCount);

 ViStatus _VI_FUNC AGN6030A_CreateArbSequence (ViSession vi,
                                              ViInt32 seqLength,
                                              ViInt32 wfmHandle[],
                                              ViInt32 wfmLoopCount[],
                                              ViInt32 *seqHandle);

 ViStatus _VI_FUNC  AGN6030A_GetSeqHandleFromName (ViSession vi, ViConstString seqName,
                                                  ViInt32 *seqHandle);
 ViStatus _VI_FUNC  AGN6030A_GetSeqNameFromHandle (ViSession vi, ViInt32 seqHandle,
                                                  ViInt32 arraySize, ViChar seqName[]);
 ViStatus _VI_FUNC  AGN6030A_GetSeqNames (ViSession vi, ViInt32 arraySize,
                                         ViChar seqNames[]);

 ViStatus _VI_FUNC AGN6030A_ConfigureArbSequence (ViSession vi,
                                                 ViConstString channelName,
                                                 ViInt32 seqHandle,
                                                 ViReal64 arbGain,
                                                 ViReal64 arbOffset);

 ViStatus _VI_FUNC AGN6030A_ClearArbSequence (ViSession vi,
											 ViInt32 seqHandle);

 ViStatus _VI_FUNC AGN6030A_ClearArbMemory (ViSession vi);
 
 /*- Advanced Sequence Output (Scenarios) -------------------------------------------*/

ViStatus _VI_FUNC AGN6030A_CreateAdvancedSequence (ViSession vi,
                                              ViInt32 seqLength,
                                              ViInt32 wfmHandle[],
                                              ViInt32 wfmLoopCount[],
											  ViUInt8 wfmAdvanceMode[],
											  ViUInt8 wfmMarkerMask[],
                                              ViInt32 *seqHandle         );
// 
// Use these values for constructing elements of the wfmMarkerMask[] array.
// For each waveform in the sequence, you can enable or disable markers that are 
// automatically generated when the waveform starts, repeats or during the time
// the waveform is being played (gate). These values may be OR'ed together to 
// enable any desired set of markers for each point in the sequence.
//
// If you pass VI_NULL for the wfmMarkerMask parameter, all waveform event markers
// are automatically enabled for every element in the sequence.
//
#define AGN6030A_VAL_WFM_START_MASK		0x01
#define AGN6030A_VAL_WFM_REPEAT_MASK	0x02
#define AGN6030A_VAL_WFM_GATE_MASK		0x04

//
// waveform advance mode values.
//
// AUTO:		Plays the waveform, including repeats and advances to the next waveform
//				automatically. No trigger is required.
//
// CONTINUOUS:	Plays the waveform continuously. Waveform repeat count is ignored.
//				Only two types of trigger will stop waveform playback in this mode:
//
//				A waveform jump trigger will cause the sequencer to move on to the next
//				waveform in the sequence.
//
//				A stop trigger will stop waveform playback completely.
//
// PLAY_ALL_REPS:	The waveform is played, including repeats. Playback then pauses until
//					a waveform advance or waveform jump trigger is received.
//
// PLAY_ONE_REP:	One repetition of the waveform is played. Playback then pauses until
//					a waveform advance or waveform jump trigger is received. An advance
//					trigger continues playing repeats until the repeat count is exhausted,
//					while a jump trigger causes any remaining repeats to be skipped.
//
#define AGN6030A_VAL_WFM_ADV_AUTO			0

#define AGN6030A_VAL_WFM_ADV_PLAY_ALL_REPS	3	/* play all repetitions then wait for trigger before */
												/* advancing to next waveform in sequence */

#define AGN6030A_VAL_WFM_ADV_PLAY_ONE_REP	2	/* play one waveform repetition then wait for trigger */
												/* before playing next repetition or advancing to next */
												/* waveform in sequence */

#define AGN6030A_VAL_WFM_ADV_CONTINUOUS		1	/* not currently supported. do not include in customer release. */

												/* play waveform continuously until a waveform jump trigger is rec'd */

ViStatus _VI_FUNC AGN6030A_ClearAdvancedSequence (ViSession vi,
												  ViInt32 seqHandle);

ViStatus _VI_FUNC AGN6030A_CreateArbScenario(ViSession vi,
									 		 ViInt32 scenarioLength,
											 ViInt32 seqHandle[],
											 ViInt32 seqLoopCount[],
											 ViUInt8 seqMarkerMask[],
											 ViInt32 *scenarioHandle );

#define AGN6030A_VAL_SEQ_START_MASK		0x01
#define AGN6030A_VAL_SEQ_REPEAT_MASK	0x02
#define AGN6030A_VAL_SEQ_GATE_MASK		0x04

ViStatus _VI_FUNC  AGN6030A_GetScenarioHandleFromName (ViSession vi, ViConstString scenarioName,
                                                  ViInt32 *scenarioHandle);
ViStatus _VI_FUNC  AGN6030A_GetScenarioNameFromHandle (ViSession vi, ViInt32 scenarioHandle,
                                                  ViInt32 arraySize, ViChar scenarioName[]);
ViStatus _VI_FUNC  AGN6030A_GetScenarioNames (ViSession vi, ViInt32 arraySize,
                                         ViChar scenarioNames[]);

ViStatus _VI_FUNC AGN6030A_ConfigureArbScenario(ViSession		vi,
                                             ViConstString	channelName,
                                             ViInt32		scenarioHandle,
											 ViInt32		scenarioPlayMode,
											 ViInt32		scenarioJumpMode,
                                             ViReal64		arbGain,
                                             ViReal64		arbOffset );

ViStatus _VI_FUNC AGN6030A_ClearArbScenario (ViSession vi,
											 ViInt32 scenarioHandle);

/*- Advanced Sequence Output (Scenarios) -------------------------------------------*/
//mt missing: ViStatus _VI_FUNC AGN6030A_CreateAdvancedSequence(...)

 /*- DDS (Direct Digital Synthesis) -----------------------------------------*/

//
// DDS Sessions are always "locked" in the advanced sequencing mode.
//
// Advanced sequences and scenarios must be created using the functions below when using a DDS session.
//
// In addition to waveform information, each element of a DDS sequence contains information which
// configures the DDS engine's behavior.
//

ViStatus _VI_FUNC AGN6030A_CreateDdsSequence (ViSession vi,
                                              ViInt32 seqLength,
                                              ViInt32 wfmHandle[],
                                              ViInt32 wfmLoopCount[],
											  ViUInt8 wfmAdvanceMode[],
											  ViUInt8 wfmMarkerMask[],
											  ViReal64 initPhase[],
											  ViReal64 initFreq[],
											  ViReal64 freqSlope[],
											  ViReal64 initAmplitude[],
											  ViReal64 amplitudeSlope[],
											  ViBoolean initPhaseEnabled[],
                                              ViInt32 *seqHandle);


ViStatus _VI_FUNC AGN6030A_CreateDdsScenario(ViSession vi,
									 		 ViInt32 scenarioLength,
											 ViInt32 seqHandle[],
											 ViInt32 seqLoopCount[],
											 ViUInt8 seqMarkerMask[],
											 ViInt32 *scenarioHandle );

ViStatus _VI_FUNC AGN6030A_ClearDdsSequence (ViSession vi,
								   		     ViInt32 seqHandle);

ViStatus _VI_FUNC AGN6030A_ConfigureDdsScenario(ViSession		vi,
                                             ViConstString	channelName,
                                             ViInt32		scenarioHandle,
											 ViInt32		scenarioPlayMode,
											 ViInt32		scenarioJumpMode,
                                             ViReal64		arbGain,
                                             ViReal64		arbOffset );

ViStatus _VI_FUNC AGN6030A_ClearDdsScenario (ViSession vi,
											 ViInt32 scenarioHandle);

//
// These functions allow users to determine DDS parameter limits.
//

ViStatus _VI_FUNC AGN6030A_GetDdsMinMax(ViSession vi,
										ViReal64 *initPhaseMin, ViReal64 *initPhaseMax,
										ViReal64 *initFreqMin, ViReal64 *initFreqMax,
										ViReal64 *freqSlopeMin, ViReal64 *freqSlopeMax,
										ViReal64 *initAmpMin, ViReal64 *initAmpMax,
										ViReal64 *ampSlopeMin, ViReal64 *ampSlopeMax);

ViStatus _VI_FUNC AGN6030A_GetDdsQuanta(ViSession vi,
										ViReal64 *initPhaseQuanta,
										ViReal64 *initFreqQuanta,
										ViReal64 *freqSlopeQuanta,
										ViReal64 *initAmpQuanta,
										ViReal64 *ampSlopeQuanta);
//end of DDS function

/*- Triggering ----------------------------------------------------------*/

 ViStatus _VI_FUNC  AGN6030A_ConfigureTriggerSource (ViSession vi, 
													ViConstString channelName,
													ViInt32 trigSource);

/*- Software Triggering -------------------------------------------------*/

 ViStatus _VI_FUNC  AGN6030A_SendSoftwareTrigger (ViSession vi);
 
 // valid trigger numbers are 1,2,3,4
 
 ViStatus _VI_FUNC AGN6030A_SendNumberedSoftwareTrigger (ViSession vi, ViInt32 whichTrigger);

/*- Burst Configuration -------------------------------------------------*/

 ViStatus _VI_FUNC AGN6030A_ConfigureBurstCount (ViSession vi,
												ViConstString channelName,
												ViInt32 burstCount);

/*- Error Functions ----------------------------------------------------*/
 ViStatus _VI_FUNC  AGN6030A_error_query (ViSession vi, ViInt32 *errorCode,
                                         ViChar errorMessage[]);
 ViStatus _VI_FUNC  AGN6030A_GetErrorInfo (ViSession vi, ViStatus *primaryError, 
                                          ViStatus *secondaryError, 
                                          ViChar errorElaboration[256]);
 ViStatus _VI_FUNC  AGN6030A_ClearErrorInfo (ViSession vi);
 ViStatus _VI_FUNC  AGN6030A_error_message (ViSession vi, ViStatus errorCode,
                                           ViChar errorMessage[256]);

/*- Utility Functions --------------------------------------------------*/
 ViStatus _VI_FUNC  AGN6030A_reset (ViSession vi);
 ViStatus _VI_FUNC  AGN6030A_self_test (ViSession vi, ViInt16 *selfTestResult,
                                       ViChar selfTestMessage[]);
 ViStatus _VI_FUNC  AGN6030A_revision_query (ViSession vi, 
                                            ViChar instrumentDriverRevision[],
                                            ViChar firmwareRevision[]);

 ViStatus _VI_FUNC AGN6030A_query_available_instruments(
	ViInt16		arraySize,
	ViInt16		*busNumber,
	ViInt16		*deviceNumber,
	ViInt16		*slotNumber,
	char		**serialNumber,
	char		**visaResourceString,
	ViInt16		*numArbsFound );

/*- Set, Get, and Check Attribute Functions ----------------------------*/

 ViStatus _VI_FUNC  AGN6030A_GetAttrMinMaxViInt32( 
	ViSession vi, ViConstString channelName, ViUInt32 attr, ViInt32 *min, ViInt32 *max, ViBoolean *hasMin, ViBoolean *hasMax );

 ViStatus _VI_FUNC  AGN6030A_GetAttrMinMaxViReal64( 
	ViSession vi, ViConstString channelName, ViUInt32 attr, ViReal64 *min, ViReal64 *max, ViBoolean *hasMin, ViBoolean *hasMax );

 ViStatus _VI_FUNC  AGN6030A_GetAttributeViInt32 (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViInt32 *value);
 ViStatus _VI_FUNC  AGN6030A_GetAttributeViReal64 (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViReal64 *value);
 ViStatus _VI_FUNC  AGN6030A_GetAttributeViString (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViInt32 bufSize, ViChar value[]); 
 ViStatus _VI_FUNC  AGN6030A_GetAttributeViSession (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViSession *value);
 ViStatus _VI_FUNC  AGN6030A_GetAttributeViBoolean (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViBoolean *value);

 ViStatus _VI_FUNC  AGN6030A_SetAttributeViInt32 (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViInt32 value);
 ViStatus _VI_FUNC  AGN6030A_SetAttributeViReal64 (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViReal64 value);
 ViStatus _VI_FUNC  AGN6030A_SetAttributeViString (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViConstString value); 
 ViStatus _VI_FUNC  AGN6030A_SetAttributeViSession (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViSession value);
 ViStatus _VI_FUNC  AGN6030A_SetAttributeViBoolean (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViBoolean value);

 ViStatus _VI_FUNC  AGN6030A_CheckAttributeViInt32 (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViInt32 value);
 ViStatus _VI_FUNC  AGN6030A_CheckAttributeViReal64 (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViReal64 value);
 ViStatus _VI_FUNC  AGN6030A_CheckAttributeViString (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViConstString value); 
 ViStatus _VI_FUNC  AGN6030A_CheckAttributeViSession (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViSession value);
 ViStatus _VI_FUNC  AGN6030A_CheckAttributeViBoolean (ViSession vi, ViConstString channelName, ViUInt32 attribute, ViBoolean value);

/*********************************************************
Functions reserved for class driver use only.
End-users should not call these functions.  
*********************************************************/
 ViStatus _VI_FUNC  AGN6030A_IviInit (ViRsrc resourceName, ViBoolean IDQuery, 
                                     ViBoolean reset, ViSession vi);
 ViStatus _VI_FUNC  AGN6030A_IviClose (ViSession vi);   

/****************************************************************************
*------------------------ Error And Completion Codes ----------------------*
****************************************************************************/
#define AGN6030A_ERROR_NO_WFMS_AVAILABLE         IVIFGEN_ERROR_NO_WFMS_AVAILABLE      
#define AGN6030A_ERROR_WFM_IN_USE                IVIFGEN_ERROR_WFM_IN_USE             
#define AGN6030A_ERROR_NO_SEQS_AVAILABLE         IVIFGEN_ERROR_NO_SEQS_AVAILABLE      
#define AGN6030A_ERROR_SEQ_IN_USE                IVIFGEN_ERROR_SEQ_IN_USE             
#define AGN6030A_ERROR_TRIGGER_NOT_SOFTWARE      IVIFGEN_ERROR_TRIGGER_NOT_SOFTWARE

#define AGN6030A_ERROR_INVALID_WFM_HANDLE		 (0xBFFA4000 + 1)
#define AGN6030A_ERROR_INVALID_SEQ_HANDLE		 (0xBFFA4000 + 2)
#define AGN6030A_ERROR_WRONG_CHANNEL_FOR_WFM	 (0xBFFA4000 + 3)
#define AGN6030A_ERROR_UNKNOWN					 (0xBFFA4000 + 4) 
#define AGN6030A_ERROR_IO_OPERATION_FAILED		 (0xBFFA4000 + 5)
#define AGN6030A_ERROR_OUT_OF_MEMORY			 (0xBFFA4000 + 6)
#define AGN6030A_ERROR_MISSING_CLOCK			 (0xBFFA4000 + 7)
#define AGN6030A_ERROR_WRONG_FIRMWARE_VERSION	 (0xBFFA4000 + 8)
#define AGN6030A_ERROR_CORRUPT_CALIBRATION_DATA	 (0xBFFA4000 + 9)
#define AGN6030A_ERROR_CLOCK_SYNC				 (0xBFFA4000 + 10)

/**************************************************************************** 
*---------------------------- End Include File ----------------------------* 
****************************************************************************/
#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif
#endif /* __AGN6030A_HEADER */




