#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <sicl.h>
#include <sys/types.h>

#define HPIB "hpib"
#define ECAL_ADDR 18

#ifdef _WIN32
#define DLLEXPORT __declspec(dllexport)

DLLEXPORT
#endif

int main()
{
	int vx;
	return 0;
}

int phase_unwrap(int npoints,
		 double *phase)
{
    int i;
    double pincr = 0;
    double *unwrapped = NULL;

    unwrapped = malloc(npoints*sizeof(double));
    for (i=1; i<npoints; i++) {
        if (phase[i-1] - phase[i] > 180.0)
            pincr = pincr - 360.0;

        if (phase[i-1] - phase[i] < -180.0)
            pincr = pincr + 360.0;
    
        unwrapped[i] = phase[i] - pincr;
    }
    
    for (i=1; i<npoints; i++) 
        phase[i] = unwrapped[i];
	
    free(unwrapped);    
    return 0;
}

int hp85060_pass_cntrl()
{
    int err = 0;
    int hpib_addr;
    int actctlr;
    INST bus;
    
    /* open bus interface session */
    bus = iopen(HPIB);
    
    /* get host address */
    err = igpibbusstatus(bus, I_GPIB_BUS_ADDR, &hpib_addr);
    
    /* pass control to ecal */
    err = igpibpassctl(bus, ECAL_ADDR);
        if (err) {
            printf("Error passing control to ECAL\n");
            goto quit;
        }
    
    /* wait for completion */
    do {
        err = igpibbusstatus(bus, I_GPIB_BUS_ACTCTLR, &actctlr);
        if (err) {
            printf("Error reading igpibbusstatus\n");
            goto quit;
        }
        err = hp85060_delay(1.0);
        if (err) {
            printf("Error in hp85060_delay\n");
            goto quit;
        }
        
    } while (!actctlr);
    
quit:
    err = iclose(bus);
    return err;
    
}

int hp85060_delay(double time)
{
    int err = 0;
    struct timedelay {
        unsigned long delay_sec;
        long delay_usec;
    } t; 
    double mx = 1000000.0;
    double x;
    
    x = floor(time);
    t.delay_sec = x;
    t.delay_usec = mx * (time-x);
    err = select(NULL, NULL, NULL, NULL, &t);
    
    return err;
}

int arrayMinMaxC(int npoints, int max,
	     double *array1, 
	     double *array2,
	     double *resultArray)
{
    int indx;
    for (indx=0; indx<npoints; indx++) {
        if (max) {
            if ( array1[indx] > array2[indx] )
                resultArray[indx] = array1[indx];
            else
                resultArray[indx] = array2[indx];
                }
        else {
            if ( array1[indx] < array2[indx] )
                resultArray[indx] = array1[indx];
            else
                resultArray[indx] = array2[indx];
        }
    }
    return 0;
}
