#include <stdlib.h>
#include <windows.h>
#include <string.h>

#ifdef WIN32
#  define DLLEXPORT __declspec(dllexport)
#else
#  define DLLEXPORT
#endif

#define MAX_CLASSNAME_LEN 512


// The description will show up on the Program Explorer when you select
// "Show Description" from the object menu and the Function Selection
// dialog box in the small window on the bottom of the box.

DLLEXPORT char numWindowInstances_desc[] = "numWindowInstances(char* className) - This function counts the number of top-level windows that are of class \"className\"";



static long numInstances;
static char wndClassName[MAX_CLASSNAME_LEN+1];

//
// The window callback procedure for EnumWindows()
//
DLLEXPORT BOOL CALLBACK enumWindowsCallback(HWND hwnd, LPARAM lParam) {
	char tmpClassName[MAX_CLASSNAME_LEN+1];

	// Get className of this window and compare it against one passed in
	// by the user. Do compares case-insensitive
	if (GetClassName(hwnd, tmpClassName, MAX_CLASSNAME_LEN)) {
		tmpClassName[MAX_CLASSNAME_LEN] = '\0';
		if (stricmp(wndClassName, tmpClassName)==0)
			numInstances++;
		}
	return TRUE;
}


DLLEXPORT long numWindowInstances(char* className) {

	// Reset count
	numInstances = 0;

	// Copy className to static so it is visible to callback function
	strncpy(wndClassName, className, MAX_CLASSNAME_LEN);
	wndClassName[MAX_CLASSNAME_LEN] = '\0';

	// Have windows enumerate the top-level windows
	if (EnumWindows(enumWindowsCallback, 0))
		return numInstances;
	else
		return -1;
}


