// ****************************************************************************
//
// File Name:    TYPEDEF.H
//
// Description:  Global defines used in many projects.
//      This file contains general purpose definitions.
//      By defining synonyms for the physical data types to be manipulated,
//      portability between memory models and machines can be maintained.
//
//      Note: This file follows the system include files and before
//      any application include files.
//
//  ORIGINATOR: Geoffrey Peterson 
//
//  HISTORY
//    who     when     what
// -------- --------- ----------------------------------------------------
//  Geof    07-17-97  This file is a merge of some of the typedef and #defines
//                    from Bob Robert with some #defines (made to be a typedef)
//                    I am accustom to. It is the foundation of my general defines.
//                    Thus, not all typedef and defines below are used now.
// ****************************************************************************


// Note: 
//       BOOLean logic is defined for code reading clarity.  While
//       bit wise operations are NOT defined.  Normal flow control logic is 
//       defined as capitals but bit twiddling is left for standard 'C' syntax.

#define AND      &&             /* For BOOLEAN arithmetic.. Needed by Geof ...*/
#define OR       ||             /* Needed by Geof                             */
#define EQ       ==             /* Needed by Geof                             */
#define NE       !=             /* Strongly preferred by Geof.                */
#define NOT      !              /* Needed by Geof                             */
#define MOD      %              /* Needed by Geof                             */

// NOTE: ALL defines are ALL capital letters.  Every variable will have at least
// one lower case letter.  Thus, defines are easily spotted in the source code.

// WORD and BYTE save typing for one and two byte unsigned values (common).
typedef unsigned char   BYTE;   /* Signed byte                                */
typedef unsigned int    WORD;   /* Signed word (16 bits)                      */
typedef unsigned int    UINT;   /* Specifically an integer, not just two byes.*/
typedef unsigned long   ULONG;
typedef long double     LDOUBLE ;

// BOOLEAN TRUE and FALSE are allwasy one and zero.
#ifndef TRUE
#define TRUE            1
#define FALSE           0
#endif
 
// typedef enum { FALSE = 0, TRUE } BOOL ;  /* Simple enumeration for booleans */
// Much existing code uses defines, and conflict with the enumeration.

// .........................  MACROS ............................

//================================================================
// Macro: returns the number of elements in an array
// Example Use: for (i=0; i < DIM(ArrayName); ++i)
//                  ArrayName [i] = 0;
#define DIM(a) \
    (sizeof(a)/sizeof(a[0]))

//================================================================
// Macro: returns the number of elements in an array minus 1
// Example Use: Value = ArrayName [LAST_INDEX(ArrayName)];
#define LAST_INDEX(a) \
    (DIM(a)-1)

//================================================================
// Macro: represents the address of the last value of an array
// Example Use: pArray = ArrayName
//              while (p <= LAST_ADDR(ArrayName))
//                  *p++ = 0;
#define LAST_ADDR(a) \
    ((a)+DIM(a)-1)
    
//================================================================
// Macro: represents the address of the first value beyond the end an array
// Example Use: pArray = ArrayName
//              while (p < BEYOND (ArrayName))
//                  *p++ = 0;
#define BEYOND(a) \
    ((a) + DIM(a))

//================================================================
// Macro: provides more elegant way of dimensioning an array
// Example Use: char table[range('a','z')];
#define RANGE(lo, hi) \
    ((hi)-(lo)+1)

//================================================================
// Macro: Extract the low order byte of UINT 'x'
// Example Use:
#define LOWBYTE(x) \
    ((x) & 0xff)

//================================================================
// Macro: Extract the high order byte of UINT 'x'
// Example Use: UINT8 x = HIGHBYTE (*pUINT16);
//
#define HIGHBYTE(x) \
    LOWBYTE((x) >> 8)

#ifdef BIG_DATA
// Data access when using more than 16 bit words. Not with the 8051.

//================================================================
// Macro: Extract the low order word of 32bit value 'x'
// Example Use: UINT16 x = LOWWORD (*pUINT32);
#define LOWWORD(x) \
    ((x) & 0xffff)

//================================================================
// Macro: Extract the high order word of 32bit value 'x'
// Example Use: UINT16 x = HIGHWORD (*pUINT32);
//
#define HIGHWORD(x) \
    LOWWORD((x) >> 16)

#endif

//================================================================
// Macro: Returns the larger of two values
// Example Use: x = max (val1, val2)
#define MAX (a,b) \
  (((a) > (b)) ? (a) : (b))

//================================================================
// Macro: Returns the smaller of two values
// Example Use: x = min (val1, val2)
#define MIN (a,b) \
  (((a) < (b)) ? (a) : (b))
