// *******************************************************************
// External definitoins of gloable routines and data in preform.c

#define ESC             0x1B // Escape character, to exit back a menu.
#define CR              0x0D // Carriage return. The Enter key.
#define BELL            0x07 // ASCII Bell value, for output.
#define BACK_SPACE      0x08 // Back space character.
#define ARROW_HI_BYTE   0x00 // High byte value for arrow keys.
#define DELETE          0x53 // Lower byte of Del character, for input editing.
#define LEFT_ARROW      0x4B // Lower byte of left arrow key.
#define RIGHT_ARROW     0x4D // Lower byte of right arrow key.
#define BLANK_STR       0x00 // Used to blank (zero) out a string.
#define ANT_CHK_TIME       1 // Timeout value for antenna connected test.
#define GET_ID_TIME       10 // Seconds to search for a tag when reading tag ID.

#define KEY_HIT_TIME       1 // No time, to wait for a keystroke.
#define DISPLAY_TIME       2 // Number of seconds holding a display.
#define SHORT_DELAY        1 // Smallest number of seconds to delay.
#define BETWEEN_CHECK      1 // Wait this many seconds between antenna present tests.
// ALL valid numbers being entered will have the sign bit cleared. 
// Flag values, for things like ESC or ENTER, will have the sign bit set (0x8000).
// Tag address value that is too big is used as a flag for no valid tag data.
#define LARGEST_DEC    0x7FFF  // The largest decimal value is 32,767. Sigh cleared.
#define TOO_BIG_VAL    0xFFFF  // No valid input can be this big of a number.
#define ENTER_ALONE    0xFFFE  // When entering a number ENTER is with no digits.
#define TAG_OVERFLOW   HS232_SIZE // Maximum value for the biggest tag size.

#define BYTE_VALUE  0xFF       // Mask off all but a value that will fit into a byte.

#if TEST_MUX32                 // MUX32 data size restriction.
#define HMS827_MAX_DATA   55   // Data bytes in write/write command, for hole tag.
#else
#define HMS827_MAX_DATA  100   //Set it to 100 for HMS827, bigger than HMS814.
#endif

#define PASS_SIZE      20      // Extra byte for NULL termination.
                       // Actual length is 19, to fit with backspace on screen.
#define NO_PROTECTED_AREA  0xFFFF   // Bound flag for no tag write protection.

// Internal run time flag values for the selected antenna type being used.
// Hold a "flag" value for the antenna type selected.
extern enum ant_type {NOT_VALID, HMS_FAMILY, HS_FAMILY } antenna_type; 
extern WORD mem_size;           // Size of selected antenna type tag.
extern BYTE max_data_pkt;      // Maximum data bytes size for selected antanna.

extern enum data_type {HEX, DEC, ASCII, BIN } display_type; // Display forat chosen.
extern WORD start_adr;// Begin coping from this address.
extern WORD stop_adr; // Last address byte to be coping.

extern void display_delay_sht(void);
extern void print_code(BYTE error_num);
extern WORD display_data(BYTE* data_ptr, WORD num_bytes, WORD data_adr);
extern WORD inp_num(WORD max_value);
extern WORD inp_hex(void);
extern WORD inp_bin(void);
extern void ant_attached(void);
extern void print_tag_type(void);
extern void ContinueRead(void); // Continuouslly read  
extern void write_notcont(void); 
extern void read_notcont(void); 
extern void read_write_conf(void); 
extern void BlockRead(void); 
extern void pro_BlockWrite(BYTE prt_mode);
extern void SearchTag(void); 
extern void Get_tag_ID(void);
extern void ClearTag(void); 
extern void FillTag(void);
extern void copy_from_tag(void);
extern void copy_to_tag(void);
extern void disp_copied(void);
