# To run, in one terminal, run python3 server.py
# in another terminal, run python3 client.py
# USING VEE PRO AS CLIENT
# Run server.py in a terminal window
# open SocketClientEdited.vee in VEE Pro
# press the play button in VEE Pro
import json
from VEEParser import read_string, send_record, python_to_r
from VEEParser import send_string, PYTHON_TO_VEE_TYPES, Int32OrReal64, read_script, R_TO_PYTHON_TYPES
import socket
import argparse
import subprocess
import threading
import os
import uuid
import numpy as np
from bridgescripts import BRIDGE_SCRIPTS
import tempfile
import ast

PROTOCOLS = set(("DATA","SCRIPT", "SERVERSHUTDOWNTIMEOUT", "GETRESULT", "HALT", "EXECUTE", "BRIDGE", "STATUS", "QUIT"))
client_list = dict()
TIMEOUT = 120
TIMEOUTENABLE = True
HEADER_SIZE = 22
class Client:
    def __init__(self, id):
        self.id = id # Unique Client ID
        self.searchString = '' # SearchString for DATA 
        self.scriptString = '' # SearchString for SCRIPT
        self.inputData = {} # inputData from VEE(DATA)
        self.outputData = {} # OutputData from Python(GETRESULT)
        self.protocol = '' # Current protocol
        self.commands = () # commands for EXECUTE
        self.running = False # Check if EXECUTE is currently running
        self.error = [False, '']

    def python_bridge(self, conn):
        sendInputData = {}
        for key in self.inputData:
            value = self.inputData[key][1]
            sendInputData[key] = [type(value).__name__, str(value)]
        sendArray = [sendInputData, self.scriptString] # Send input Data and Script
        sendJSON = json.dumps(sendArray) # Use json library
        sendJSONSize = str(len(sendJSON)).zfill(10)
        sendToBridge = sendJSONSize + sendJSON
        conn.send(sendToBridge.encode())
        recievedDictSize = int(conn.recv(10).decode()) # recieve length of JSON string
        recievedDict = conn.recv(recievedDictSize).decode('utf-8') # Get Data back
        recievedDict = json.loads(recievedDict) # Use JSON library to load the dictionary
        for key in recievedDict: # Loop through each fieldName in the recieved Dictonary
            if(recievedDict[key][0] != "str"):
                recievedDict[key][1] = ast.literal_eval(recievedDict[key][1])
            dataType = type(recievedDict[key][1])
            if(dataType not in PYTHON_TO_VEE_TYPES):
                recievedDict["VEESTATUS"] = ["Int32", 1, 0, 0]
                recievedDict["ERRORMESSAGE"] = ["Text", f'{key} Python type/object not a supported VEE Type', 0, 0]
                break
            isArray = PYTHON_TO_VEE_TYPES[dataType]
            if(isArray == "Array"): # check if fieldName is an Array
                numDims = len(np.array(recievedDict[key][1]).shape) # Use numpy to get number of dimensions
                size = np.array(recievedDict[key][1]).shape # Use numpy to get the size of each dimension
                elements = np.array(recievedDict[key][1]).size # Use numpy to get the number of elements
                if(elements == 0):
                    recievedDict[key][0] = "Int32" 
                    recievedDict[key][1] = 0
                    recievedDict[key][2] = 0
                    recievedDict[key][3] = 0
                else:
                    if(recievedDict[key][0] == "int"):
                        recievedDict[key][1] = Int32OrReal64(recievedDict[key][1])
                    element = np.array(recievedDict[key][1]).item(0) # get first item to check the type
                    recievedDict[key][0] = PYTHON_TO_VEE_TYPES[type(element)]
                    recievedDict[key][2] = numDims
                    recievedDict[key][3] = size
            else:
                if(dataType == int):
                    recievedDict[key][1] = Int32OrReal64(recievedDict[key][1])
                recievedDict[key][0] = PYTHON_TO_VEE_TYPES[type(recievedDict[key][1])]
        self.outputData = recievedDict

    def r_bridge(self, conn):
        send_input_data = python_to_r(self.inputData) + "\n" + self.scriptString
        send_data_size = str(len(send_input_data))
        conn.send(send_data_size.encode())
        conn.recv(3)
        conn.send(send_input_data.encode())
        recieve_data_size = int(conn.recv(14).decode())
        conn.send(b'OK')
        recievedDict = conn.recv(recieve_data_size).decode()
        recievedDict = json.loads(recievedDict) # Use JSON library to load the dictionary
        for key in recievedDict:
            if(recievedDict[key][0] not in R_TO_PYTHON_TYPES): # checks if returned R type is valid
                recievedDict["VEESTATUS"] = ["Int32", 1, 0, 0]
                recievedDict["ERRORMESSAGE"] = ["Text", f'{key} R type/object not a supported VEE Type', 0, 0]
                break
            elements = np.array(recievedDict[key][1]).size # Use numpy to get the number of elements
            if(elements == 0):
                recievedDict[key][0] = "Int32" 
                recievedDict[key][1] = 0
                recievedDict[key][2] = 0
                recievedDict[key][3] = 0
                continue
            if(recievedDict[key][0] == "logical"):
                for i in range(len(recievedDict[key][1])):
                    if(recievedDict[key][1][i] == "FALSE"):
                        recievedDict[key][1][i] = bool(0)
                    else:
                        recievedDict[key][1][i] = bool(1)
            elif(recievedDict[key][0] == "integer"):
                recievedDict[key][1] = Int32OrReal64(recievedDict[key][1])
            elif(recievedDict[key][0] == "complex"):
                for i in range(len(recievedDict[key][1])):
                    recievedDict[key][1][i] = recievedDict[key][1][i].replace("i", "j")
                    recievedDict[key][1][i] = complex(recievedDict[key][1][i])
            else:
                for i in range(len(recievedDict[key][1])):
                    python_type = R_TO_PYTHON_TYPES[recievedDict[key][0]]
                    recievedDict[key][1][i] = python_type(recievedDict[key][1][i])
            element = np.array(recievedDict[key][1]).item(0) # get first item to check the type
            recievedDict[key][0] = PYTHON_TO_VEE_TYPES[type(element)]
        self.outputData = recievedDict
def handle_new_client(conn,s, HOST, PORT):
    global PROTOCOLS, PYTHON_TO_VEE_TYPES, HEADER_SIZE
    client = Client(str(uuid.uuid4()))
    client_list[client.id] = client
    while conn:
        # print('Connected by', addr)
        try:
            recievedMessage = conn.recv(HEADER_SIZE) # String given by VEEPro, print this for debugging
        except:
            conn.close()
            break
        print(repr(recievedMessage))
        recievedMessage = recievedMessage.decode().strip()
        if(not recievedMessage):
            break
        if(recievedMessage in PROTOCOLS): # Check if the recieved Message is a protocol
            client.protocol = recievedMessage
        else:
            conn.send(send_string("Incorrect Protocol").encode("utf-8"))
            continue
        if(client.protocol == "DATA"):
            conn.send(send_string("SEND").encode())
            recievedSize = conn.recv(11).decode("utf-8")
            size = int(recievedSize)
            conn.send(send_string("SIZE").encode())
            recievedContainer = conn.recv(size + 100)
            recievedContainer = recievedContainer.decode()
            print(repr(recievedContainer))
            lines = recievedContainer.split("\n")
            for line in lines:
                if(line != ''):
                    client.searchString += line + '\n'
            try:
                client.inputData = read_string(client.searchString)
            except TypeError as err:
                client.error[0] = True
                client.error[1] = err.args[0]
            client.searchString = ''
            client.protocol = ''
            conn.send(send_string("OK").encode())
            print(repr(client.inputData))

        elif(client.protocol == "SCRIPT"):
            conn.send(send_string("SIZE").encode())
            recievedSize = conn.recv(11).decode("utf-8")
            size = int(recievedSize)
            conn.send(send_string("SEND").encode())
            recievedContainer = conn.recv(size + 100).decode("utf-8")
            lines = recievedContainer.split("\n")
            for line in lines:
                if('[' in line):
                    client.scriptString = read_script(line)
                    if("#!" in client.scriptString[:4]):
                        client.commands = client.scriptString.partition('\n')[0][2:].strip().split(" ",1)
                        client.commands[0] = client.commands[0].lower()
                        client.scriptString = client.scriptString.partition('\n')[2] # remove first line of script
                    else:
                        client.commands = tuple(["python"])
            conn.send(send_string("OK").encode())

        elif(client.protocol == "EXECUTE"):
            if(not client.scriptString or not client.inputData):
                sendString = send_string(client.error[1])
                conn.send(sendString.encode("utf-8"))
                continue
            else:
                if("python" in client.commands[0]):
                    if(len(client.commands) > 1):
                        if(os.path.exists(client.commands[1])):
                            client.running = subprocess.Popen([client.commands[1], f'{tempfile.gettempdir()}\\bridge_python.py', 
                            client.id, f'--host={HOST}', f'--port={PORT}'])
                        else:
                            conn.send(send_string("Invalid Path").encode("utf-8"))
                            break
                    else:
                        client.running = subprocess.Popen(['.\\python.exe', f'{tempfile.gettempdir()}\\bridge_python.py', 
                        client.id, f'--host={HOST}', f'--port={PORT}'])
                if("fiji" in client.commands[0]):
                    filePath = client.commands[1]
                    command = f'{filePath} --ij2 --run "{tempfile.gettempdir()}\\bridge_jython.py" "id=\'{client.id}\', host=\'{HOST}\', port={PORT}"'
                    client.running = subprocess.Popen(command)
                if("r" in client.commands[0]):
                    invalid = False
                    for item in client.inputData:
                        if(not client.inputData[item][2]):
                            conn.send(send_string(f"{item} not an array").encode())
                            invalid = True
                    if(invalid):
                        continue
                    file_path = client.commands[1]
                    command = f'{file_path} --vanilla {tempfile.gettempdir()}\\bridge_R.r {client.id} {HOST} {PORT}'
                    client.running = subprocess.Popen(command)
                sendString = send_string("OK")
                conn.send(sendString.encode("utf-8"))

        elif(client.protocol == "STATUS"):
            if(client.error[0]):
                sendString = send_string(client.error[1])
                conn.send(sendString.encode("utf-8"))
            else:
                if(client.running):
                    if(client.running.poll() is None):
                        conn.send(send_string("BUSY").encode("utf-8"))
                    else:
                        conn.send(send_string("OK").encode("utf-8"))
                else:
                    conn.send(send_string("OK").encode("utf-8"))

        elif(client.protocol == "GETRESULT"):
            if(client.error[0]):
                sendString = send_string(client.error[1])
                conn.send(sendString.encode("utf-8"))
            else:
                sendString = send_record(client.outputData)
                sendBuffSize = str(len(sendString)) + "\n"
                sendToVEE = sendBuffSize + sendString
                conn.send(sendToVEE.encode())
                print(repr(sendToVEE))

        elif(recievedMessage == "BRIDGE"): # Bridge protocol (Reserved for Bridgescripts)
            del client_list[client.id] # deletes client from client_list as EXECUTE is a not a "real" new client
            del client
            conn.send(b'OK') # Send OK back
            recievedID = conn.recv(36).decode('utf-8') # Get real Client ID
            currentClient = client_list[recievedID]
            if(currentClient.commands[0] == "python"):
                currentClient.python_bridge(conn)
            if(currentClient.commands[0] == "embed"):
                currentClient.python_bridge(conn)
            if(currentClient.commands[0] == "fiji"):
                currentClient.python_bridge(conn)
            if(currentClient.commands[0] == "r"):
                currentClient.r_bridge(conn)
            conn.close()
            break

        elif(recievedMessage == "SERVERSHUTDOWNTIMEOUT"):
            conn.send(send_string("OK").encode("utf-8"))
            recievedSize = int(conn.recv(11).decode("utf-8"))
            s.settimeout(recievedSize)
            conn.send(send_string("OK").encode("utf-8"))

        elif(client.protocol == "QUIT"):
            cleanup()
            conn.send(send_string("OK").encode("utf-8"))
            print("Shutting down server...")
            conn.close()
            s.close()
            break
        
        elif(client.protocol == "HALT"):
            conn.send(send_string("OK").encode("utf-8"))
            print("Closing Connection...")
            del client_list[client.id]
            del client
            conn.close()
            break

def cleanup():
    for key in BRIDGE_SCRIPTS:
        if(os.path.exists(f'{tempfile.gettempdir()}\\bridge_{key}.{BRIDGE_SCRIPTS[key][1]}')):
            os.remove(f'{tempfile.gettempdir()}\\bridge_{key}.{BRIDGE_SCRIPTS[key][1]}')

def main(host, port):
    global PROTOCOLS, BRIDGE_SCRIPTS, TIMEOUT, TIMEOUTENABLE
    for key in BRIDGE_SCRIPTS:
        bridgeFile = open(f'{tempfile.gettempdir()}\\bridge_{key}.{BRIDGE_SCRIPTS[key][1]}','w')
        bridgeFile.write(BRIDGE_SCRIPTS[key][0])
        bridgeFile.close()
    isConnected = True
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
        try:
            if(TIMEOUTENABLE):
                s.settimeout(TIMEOUT)
            s.bind((host, port))
            print(f'Binded on host = {host} and port = {port}')
            print("Listening...")
            s.listen()
        except Exception as msg:
            print('An error occurred:\n' + str(msg))
            send_string('An error occurred: ' + str(msg))
            isConnected = False
        # This while loop means the server is continuously running
        while (isConnected):
            try:
                conn, addr = s.accept() # Waiting for a connection from VEEPro (async)
                t1 = threading.Thread(target=handle_new_client, args=(conn,s,host,port,))
                t1.daemon = True
                t1.start()
            except socket.timeout:
                print("TIMED OUT")
                cleanup()
                s.close()
                break
            except OSError:
                cleanup()
                s.close()
                break

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Initate the VEE to Python server connection')

    parser.add_argument('--host', default='127.0.0.1', help="Connect to a specific host. Default is 127.0.0.1 (localhost).")
    parser.add_argument('--port', default=65433, type=int, help="Port to connect to server. Default is 65433.")
    
    args = parser.parse_args()
    main(args.host, args.port)

