10! RE-SAVE  "transfer.bas"
20      !
30      !  variables are stored in COM to avoid being cleared at RUNtime
40      COM Message$[100]
50      COM Input_buffer$[8192] BUFFER,Output_buffer$[8192] BUFFER
60      !
70      INTEGER Max_wait,Watchdog
80      Max_wait=10
90      !
100     CLEAR SCREEN
110     PRINT "GetInput.prog"
120     PRINT 
130     PRINT "Uses TRANSFER to talk to named pipes."
140     PRINT 
150     PRINT "Upon receipt of a message (LF-terminated string),";
160     PRINT " program branches"
170     PRINT " to user input routine.";
180     PRINT " Any response is sent back."
190     PRINT 
200     PRINT "A watchdog timer allows escape from empty pipe after";
210     PRINT " getting first message."
220     PRINT 
230     PRINT "Program terminates by: 1) watchdog timer expiring"
240     PRINT "                       2) empty response to received message."
250     PRINT 
260     PRINT "To terminate arbitrarily, press Shift-Reset"
270     PRINT 
280     PRINT 
290     !
300     !  set up all I/O paths
310     ASSIGN @Input_pipe TO "/tmp/to_rmb";FORMAT OFF
320     ASSIGN @Output_pipe TO "/tmp/from_rmb";FORMAT OFF
330     ASSIGN @Input_buffer TO BUFFER Input_buffer$;FORMAT ON
340     ASSIGN @Output_buffer TO BUFFER Output_buffer$;FORMAT ON
350     !
360     !  whenever EOR arrives, branch to service routine
370     ON EOR @Input_pipe GOSUB Service_eol
380     !
390     !  start transfers, define EOR to be linefeed character
400     TRANSFER @Input_pipe TO @Input_buffer;EOR (DELIM CHR$(10)),CONT
410     TRANSFER @Output_buffer TO @Output_pipe;CONT
420     !
430     !
440     !  loop forever, UNTIL we get our first data
450     !  A cyclic interrupt will then see if the program gets stuck.
460     DISP "Waiting for initial data..."
470     Watchdog=1
480     REPEAT
490        !  BASIC does not use sleep() to pass time -- empty
500        !  loops are CPU intensive.  Short wait helps.
510        WAIT .1
520     UNTIL Watchdog=0
530     !
540     !
550 Kill_and_quit:!
560     !
570     !  terminate transfers, end program
580     ABORTIO @Input_pipe
590     ABORTIO @Output_pipe
600     CLEAR LINE
610     DISP "Program terminated."
620     !
630     STOP
640     !
650     !
660 Service_eol:!   a linefeed was received via inbound transfer
670     !
680     !  cancel the watchdog timer, for now
690     OFF CYCLE
700     !
710     !  service routine for EOR interrupt.
720     ENTER @Input_buffer;Message$
730     PRINT "Received data: ";Message$
740     !
750     !  get some data to send back
760     BEEP 
770     DISP "Response to """;Message$;""" =?";
780     DISP "   [no response == STOP]";
790     LINPUT "",Response$
800     !
810     !  terminate on null response
820     IF Response$="" THEN 
830        PRINT "Terminating on empty response!"
840        Watchdog=0
850        OFF EOR @Input_pipe
860        RETURN 
870     END IF
880     !
890     !  send response to output buffer
900     DISP "Sending response: ";Response$
910     PRINT "Response: ";Response$
920     OUTPUT @Output_buffer;Response$
930     DISP "Waiting for more input..."
940     !
950     !  setup watchdog timer for future data
960     Watchdog=Max_wait
970     ON CYCLE 1 GOSUB Countdown
980     RETURN 
990     !
1000    !
1010 Countdown:!
1020    !
1030    !  this routine is called by ON CYCLE every second
1040    !  If the watchdog counter reaches zero, kill transfers
1050    Watchdog=Watchdog-1
1060    DISP "Waiting...  ";Watchdog
1070    !
1080    IF Watchdog=0 THEN 
1090       PRINT "Terminating on expired timer!"
1100    END IF
1110    RETURN 
1120    !
1130    END
